/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.invoice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.proRations.InvoiceTestUtils;
import org.killbill.clock.Clock;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultInvoicePaymentApi
extends InvoiceTestSuiteWithEmbeddedDB {
    private static final BigDecimal THIRTY = new BigDecimal("30.00");
    private static final Currency CURRENCY = Currency.EUR;

    @Test(groups={"slow"})
    public void testFullRefundWithNoAdjustment() throws Exception {
        this.verifyRefund(THIRTY, THIRTY, THIRTY, false, (Map<UUID, BigDecimal>)ImmutableMap.of());
    }

    @Test(groups={"slow"})
    public void testPartialRefundWithNoAdjustment() throws Exception {
        this.verifyRefund(THIRTY, BigDecimal.TEN, BigDecimal.TEN, false, (Map<UUID, BigDecimal>)ImmutableMap.of());
    }

    @Test(groups={"slow"})
    public void testFullRefundWithBothInvoiceItemAdjustments() throws Exception {
        Invoice invoice = InvoiceTestUtils.createAndPersistInvoice(this.invoiceUtil, this.invoiceDao, (Clock)this.clock, (Iterable<BigDecimal>)ImmutableList.of((Object)THIRTY, (Object)BigDecimal.TEN), CURRENCY, (InternalCallContext)this.internalCallContext);
        HashMap<UUID, BigDecimal> adjustments = new HashMap<UUID, BigDecimal>();
        adjustments.put(((InvoiceItem)invoice.getInvoiceItems().get(0)).getId(), null);
        adjustments.put(((InvoiceItem)invoice.getInvoiceItems().get(1)).getId(), null);
        this.verifyRefund(invoice, new BigDecimal("40"), new BigDecimal("40"), BigDecimal.ZERO, true, adjustments);
    }

    @Test(groups={"slow"})
    public void testPartialRefundWithSingleInvoiceItemAdjustment() throws Exception {
        Invoice invoice = InvoiceTestUtils.createAndPersistInvoice(this.invoiceUtil, this.invoiceDao, (Clock)this.clock, (Iterable<BigDecimal>)ImmutableList.of((Object)THIRTY, (Object)BigDecimal.TEN), CURRENCY, (InternalCallContext)this.internalCallContext);
        HashMap<UUID, BigDecimal> adjustments = new HashMap<UUID, BigDecimal>();
        adjustments.put(((InvoiceItem)invoice.getInvoiceItems().get(0)).getId(), null);
        this.verifyRefund(invoice, new BigDecimal("40"), new BigDecimal("30"), BigDecimal.ZERO, true, adjustments);
    }

    @Test(groups={"slow"})
    public void testPartialRefundWithTwoInvoiceItemAdjustment() throws Exception {
        Invoice invoice = InvoiceTestUtils.createAndPersistInvoice(this.invoiceUtil, this.invoiceDao, (Clock)this.clock, (Iterable<BigDecimal>)ImmutableList.of((Object)THIRTY, (Object)BigDecimal.TEN), CURRENCY, (InternalCallContext)this.internalCallContext);
        ImmutableMap adjustments = ImmutableMap.of((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getId(), (Object)new BigDecimal("29"), (Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getId(), (Object)new BigDecimal("9"));
        this.verifyRefund(invoice, new BigDecimal("40"), new BigDecimal("38"), BigDecimal.ZERO, true, (Map<UUID, BigDecimal>)adjustments);
    }

    private void verifyRefund(BigDecimal invoiceAmount, BigDecimal refundAmount, BigDecimal finalInvoiceAmount, boolean adjusted, Map<UUID, BigDecimal> invoiceItemIdsWithAmounts) throws InvoiceApiException {
        Invoice invoice = InvoiceTestUtils.createAndPersistInvoice(this.invoiceUtil, this.invoiceDao, (Clock)this.clock, invoiceAmount, CURRENCY, (InternalCallContext)this.internalCallContext);
        this.verifyRefund(invoice, invoiceAmount, refundAmount, finalInvoiceAmount, adjusted, invoiceItemIdsWithAmounts);
    }

    private void verifyRefund(Invoice invoice, BigDecimal invoiceAmount, BigDecimal refundAmount, BigDecimal finalInvoiceAmount, boolean adjusted, Map<UUID, BigDecimal> invoiceItemIdsWithAmounts) throws InvoiceApiException {
        InvoicePayment payment = InvoiceTestUtils.createAndPersistPayment(this.invoiceInternalApi, (Clock)this.clock, invoice.getId(), invoiceAmount, CURRENCY, (InternalCallContext)this.internalCallContext);
        BigDecimal initialInvoiceBalance = this.invoiceInternalApi.getInvoiceById(invoice.getId(), (InternalTenantContext)this.internalCallContext).getBalance();
        Assert.assertEquals((int)initialInvoiceBalance.compareTo(BigDecimal.ZERO), (int)0);
        InvoicePayment refund = this.invoiceInternalApi.recordRefund(payment.getPaymentId(), refundAmount, adjusted, invoiceItemIdsWithAmounts, UUID.randomUUID().toString(), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)refund.getAmount().compareTo(refundAmount.negate()), (int)0);
        Assert.assertEquals((Object)refund.getCurrency(), (Object)CURRENCY);
        Assert.assertEquals((Object)refund.getInvoiceId(), (Object)invoice.getId());
        Assert.assertEquals((Object)refund.getPaymentId(), (Object)payment.getPaymentId());
        Assert.assertEquals((Object)refund.getType(), (Object)InvoicePaymentType.REFUND);
        BigDecimal newInvoiceBalance = this.invoiceInternalApi.getInvoiceById(invoice.getId(), (InternalTenantContext)this.internalCallContext).getBalance();
        Assert.assertEquals((int)newInvoiceBalance.compareTo(finalInvoiceAmount), (int)0);
    }
}

