/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.migration;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDaoHelper;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.util.callcontext.TenantContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultInvoiceMigrationApi
extends InvoiceTestSuiteWithEmbeddedDB {
    private LocalDate date_migrated;
    private LocalDate date_regular;
    private UUID accountId;
    private UUID migrationInvoiceId;
    private UUID regularInvoiceId;
    private static final BigDecimal MIGRATION_INVOICE_AMOUNT = new BigDecimal("100.00");
    private static final Currency MIGRATION_INVOICE_CURRENCY = Currency.USD;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.date_migrated = this.clock.getUTCToday().minusYears(1);
        this.date_regular = this.clock.getUTCToday();
        Account account = this.invoiceUtil.createAccount(this.callContext);
        this.accountId = account.getId();
        this.migrationInvoiceId = this.createAndCheckMigrationInvoice(this.accountId);
        this.regularInvoiceId = this.invoiceUtil.generateRegularInvoice(account, this.date_regular, this.callContext);
    }

    private UUID createAndCheckMigrationInvoice(UUID accountId) throws InvoiceApiException {
        RecurringInvoiceItem recurringItem = new RecurringInvoiceItem(null, accountId, null, null, "planName", "phaseName", new LocalDate(2016, 2, 1), new LocalDate(2016, 3, 1), MIGRATION_INVOICE_AMOUNT, MIGRATION_INVOICE_AMOUNT, MIGRATION_INVOICE_CURRENCY);
        UUID migrationInvoiceId = this.invoiceUserApi.createMigrationInvoice(accountId, this.date_migrated, (Iterable)ImmutableList.of((Object)recurringItem), this.callContext);
        Assert.assertNotNull((Object)migrationInvoiceId);
        InvoiceModelDao invoice = (InvoiceModelDao)this.invoiceDao.getById(migrationInvoiceId, (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((Object)invoice.getAccountId(), (Object)accountId);
        Assert.assertEquals((int)invoice.getTargetDate().compareTo((ReadablePartial)this.date_migrated), (int)0);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((int)((InvoiceItemModelDao)invoice.getInvoiceItems().get(0)).getAmount().compareTo(MIGRATION_INVOICE_AMOUNT), (int)0);
        Assert.assertEquals((Object)((InvoiceItemModelDao)invoice.getInvoiceItems().get(0)).getType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((int)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice).compareTo(BigDecimal.ZERO), (int)0);
        Assert.assertEquals((Object)invoice.getCurrency(), (Object)MIGRATION_INVOICE_CURRENCY);
        Assert.assertTrue((boolean)invoice.isMigrated());
        return migrationInvoiceId;
    }

    @Test(groups={"slow"})
    public void testUserApiAccess() {
        List byAccount = this.invoiceUserApi.getInvoicesByAccount(this.accountId, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)byAccount.size(), (int)1);
        Assert.assertEquals((Object)((Invoice)byAccount.get(0)).getId(), (Object)this.regularInvoiceId);
        List byAccountAndDate = this.invoiceUserApi.getInvoicesByAccount(this.accountId, this.date_migrated.minusDays(1), (TenantContext)this.callContext);
        Assert.assertEquals((int)byAccountAndDate.size(), (int)1);
        Assert.assertEquals((Object)((Invoice)byAccountAndDate.get(0)).getId(), (Object)this.regularInvoiceId);
        Collection unpaid = this.invoiceUserApi.getUnpaidInvoicesByAccountId(this.accountId, new LocalDate((Object)this.date_regular.plusDays(1)), (TenantContext)this.callContext);
        Assert.assertEquals((int)unpaid.size(), (int)1);
        Assert.assertEquals((Object)((Invoice)unpaid.iterator().next()).getId(), (Object)this.regularInvoiceId);
    }

    @Test(groups={"slow"})
    public void testBalance() throws InvoiceApiException {
        InvoiceModelDao migrationInvoice = (InvoiceModelDao)this.invoiceDao.getById(this.migrationInvoiceId, (InternalTenantContext)this.internalCallContext);
        InvoiceModelDao regularInvoice = (InvoiceModelDao)this.invoiceDao.getById(this.regularInvoiceId, (InternalTenantContext)this.internalCallContext);
        BigDecimal balanceOfAllInvoices = InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)migrationInvoice).add(InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)regularInvoice));
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance.compareTo(balanceOfAllInvoices), (int)0);
    }
}

