/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.user;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.model.ExternalChargeInvoiceItem;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.currency.KillBillMoney;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.clock.Clock;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultInvoiceUserApi
extends InvoiceTestSuiteWithEmbeddedDB {
    private UUID accountId;
    private UUID invoiceId;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        Account account = this.invoiceUtil.createAccount(this.callContext);
        this.accountId = account.getId();
        this.invoiceId = this.invoiceUtil.generateRegularInvoice(account, null, this.callContext);
    }

    @Test(groups={"slow"})
    public void testPostExternalChargeOnNewInvoice() throws Exception {
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        BigDecimal externalChargeAmount = BigDecimal.TEN;
        ExternalChargeInvoiceItem externalCharge = new ExternalChargeInvoiceItem(null, this.accountId, null, "description", this.clock.getUTCToday(), externalChargeAmount, accountCurrency);
        InvoiceItem externalChargeInvoiceItem = (InvoiceItem)this.invoiceUserApi.insertExternalCharges(this.accountId, this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)externalCharge), true, this.callContext).get(0);
        this.verifyExternalChargeOnNewInvoice(accountBalance, null, externalChargeAmount, externalChargeInvoiceItem);
        Assert.assertEquals((String)externalChargeInvoiceItem.getDescription(), (String)"description");
    }

    @Test(groups={"slow"})
    public void testPostExternalChargeForBundleOnNewInvoice() throws Exception {
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        BigDecimal externalChargeAmount = BigDecimal.TEN;
        UUID bundleId = UUID.randomUUID();
        ExternalChargeInvoiceItem externalCharge = new ExternalChargeInvoiceItem(null, this.accountId, bundleId, UUID.randomUUID().toString(), this.clock.getUTCToday(), externalChargeAmount, accountCurrency);
        InvoiceItem externalChargeInvoiceItem = (InvoiceItem)this.invoiceUserApi.insertExternalCharges(this.accountId, this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)externalCharge), true, this.callContext).get(0);
        this.verifyExternalChargeOnNewInvoice(accountBalance, bundleId, externalChargeAmount, externalChargeInvoiceItem);
    }

    private void verifyExternalChargeOnNewInvoice(BigDecimal initialAccountBalance, @Nullable UUID bundleId, BigDecimal externalChargeAmount, InvoiceItem externalChargeInvoiceItem) throws InvoiceApiException {
        Assert.assertNotNull((Object)externalChargeInvoiceItem.getInvoiceId());
        Assert.assertNotEquals((Object)externalChargeInvoiceItem.getInvoiceId(), (Object)this.invoiceId);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getBundleId(), (Object)bundleId);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getInvoiceItemType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getAccountId(), (Object)this.accountId);
        Assert.assertEquals((int)externalChargeInvoiceItem.getAmount().compareTo(externalChargeAmount), (int)0);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getCurrency(), (Object)accountCurrency);
        Assert.assertNull((Object)externalChargeInvoiceItem.getLinkedItemId());
        BigDecimal adjustedInvoiceBalance = this.invoiceUserApi.getInvoice(externalChargeInvoiceItem.getInvoiceId(), (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)adjustedInvoiceBalance.compareTo(externalChargeAmount), (int)0);
        BigDecimal adjustedAccountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)adjustedAccountBalance, (Object)initialAccountBalance.add(externalChargeAmount));
    }

    @Test(groups={"slow"})
    public void testOriginalAmountCharged() throws Exception {
        DefaultCallContext newCallContextLater = new DefaultCallContext(this.callContext.getTenantId(), this.callContext.getUserName(), this.callContext.getCallOrigin(), this.callContext.getUserType(), this.callContext.getUserToken(), (Clock)this.clock);
        BigDecimal externalChargeAmount = BigDecimal.TEN;
        ExternalChargeInvoiceItem externalCharge = new ExternalChargeInvoiceItem(null, this.accountId, null, UUID.randomUUID().toString(), this.clock.getUTCToday(), externalChargeAmount, accountCurrency);
        InvoiceItem externalChargeInvoiceItem = (InvoiceItem)this.invoiceUserApi.insertExternalCharges(this.accountId, this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)externalCharge), true, (CallContext)newCallContextLater).get(0);
        Invoice newInvoice = this.invoiceUserApi.getInvoice(externalChargeInvoiceItem.getInvoiceId(), (TenantContext)this.callContext);
        BigDecimal newAmountCharged = newInvoice.getChargedAmount();
        Assert.assertEquals((int)newInvoice.getOriginalChargedAmount().compareTo(externalChargeAmount), (int)0);
        Assert.assertEquals((int)newAmountCharged.compareTo(externalChargeAmount), (int)0);
    }

    @Test(groups={"slow"})
    public void testPostExternalChargeForBundle() throws Exception {
        BigDecimal externalChargeAmount = BigDecimal.TEN;
        UUID bundleId = UUID.randomUUID();
        ExternalChargeInvoiceItem externalCharge = new ExternalChargeInvoiceItem(null, this.accountId, bundleId, UUID.randomUUID().toString(), this.clock.getUTCToday(), externalChargeAmount, accountCurrency);
        InvoiceItem externalChargeInvoiceItem = (InvoiceItem)this.invoiceUserApi.insertExternalCharges(this.accountId, this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)externalCharge), true, this.callContext).get(0);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getBundleId(), (Object)bundleId);
    }

    private void verifyExternalChargeOnExistingInvoice(BigDecimal initialInvoiceBalance, @Nullable UUID bundleId, BigDecimal externalChargeAmount, InvoiceItem externalChargeInvoiceItem) throws InvoiceApiException {
        Assert.assertEquals((Object)externalChargeInvoiceItem.getInvoiceId(), (Object)this.invoiceId);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getBundleId(), (Object)bundleId);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getInvoiceItemType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getAccountId(), (Object)this.accountId);
        Assert.assertEquals((int)externalChargeInvoiceItem.getAmount().compareTo(externalChargeAmount), (int)0);
        Assert.assertEquals((Object)externalChargeInvoiceItem.getCurrency(), (Object)accountCurrency);
        Assert.assertNull((Object)externalChargeInvoiceItem.getLinkedItemId());
        BigDecimal adjustedInvoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)adjustedInvoiceBalance.compareTo(initialInvoiceBalance.add(externalChargeAmount)), (int)0);
        BigDecimal adjustedAccountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)adjustedAccountBalance, (Object)adjustedInvoiceBalance);
    }

    @Test(groups={"slow"}, expectedExceptions={InvoiceApiException.class}, expectedExceptionsMessageRegExp=".*it is already in COMMITTED status")
    public void testAdjustCommittedInvoice() throws Exception {
        BigDecimal invoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)invoiceBalance.compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountBalance, (Object)invoiceBalance);
        InvoiceItem creditInvoiceItem = this.invoiceUserApi.insertCreditForInvoice(this.accountId, this.invoiceId, invoiceBalance, this.clock.getUTCToday(), accountCurrency, "some description", this.callContext);
        Assert.assertEquals((Object)creditInvoiceItem.getInvoiceId(), (Object)this.invoiceId);
        Assert.assertEquals((Object)creditInvoiceItem.getInvoiceItemType(), (Object)InvoiceItemType.CREDIT_ADJ);
        Assert.assertEquals((Object)creditInvoiceItem.getAccountId(), (Object)this.accountId);
        Assert.assertEquals((int)creditInvoiceItem.getAmount().compareTo(invoiceBalance.negate()), (int)0);
        Assert.assertEquals((Object)creditInvoiceItem.getCurrency(), (Object)accountCurrency);
        Assert.assertEquals((String)creditInvoiceItem.getDescription(), (String)"some description");
        Assert.assertNull((Object)creditInvoiceItem.getLinkedItemId());
        BigDecimal adjustedInvoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)adjustedInvoiceBalance.compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal adjustedAccountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)adjustedAccountBalance, (Object)adjustedInvoiceBalance);
    }

    @Test(groups={"slow"})
    public void testCantAdjustInvoiceWithNegativeAmount() throws Exception {
        try {
            this.invoiceUserApi.insertCreditForInvoice(this.accountId, this.invoiceId, BigDecimal.TEN.negate(), this.clock.getUTCToday(), accountCurrency, null, this.callContext);
            Assert.fail((String)"Should not have been able to adjust an invoice with a negative amount");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CREDIT_AMOUNT_INVALID.getCode());
        }
    }

    @Test(groups={"slow"})
    public void testAdjustFullInvoiceItem() throws Exception {
        InvoiceItem invoiceItem = (InvoiceItem)this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getInvoiceItems().get(0);
        Assert.assertEquals((int)invoiceItem.getAmount().compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal invoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)invoiceBalance.compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountBalance, (Object)invoiceBalance);
        InvoiceItem adjInvoiceItem = this.invoiceUserApi.insertInvoiceItemAdjustment(this.accountId, this.invoiceId, invoiceItem.getId(), this.clock.getUTCToday(), null, this.callContext);
        Assert.assertEquals((Object)adjInvoiceItem.getInvoiceId(), (Object)this.invoiceId);
        Assert.assertEquals((Object)adjInvoiceItem.getInvoiceItemType(), (Object)InvoiceItemType.ITEM_ADJ);
        Assert.assertEquals((Object)adjInvoiceItem.getAccountId(), (Object)this.accountId);
        Assert.assertEquals((Object)adjInvoiceItem.getAmount(), (Object)invoiceItem.getAmount().negate());
        Assert.assertEquals((Object)adjInvoiceItem.getCurrency(), (Object)accountCurrency);
        Assert.assertEquals((Object)adjInvoiceItem.getLinkedItemId(), (Object)invoiceItem.getId());
        BigDecimal adjustedInvoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        this.verifyAdjustedInvoiceBalance(invoiceBalance, invoiceItem.getAmount(), invoiceItem.getCurrency(), adjustedInvoiceBalance);
        BigDecimal adjustedAccountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)adjustedAccountBalance, (Object)adjustedInvoiceBalance);
        Assert.assertNull((Object)this.invoiceUserApi.insertInvoiceItemAdjustment(this.accountId, this.invoiceId, invoiceItem.getId(), this.clock.getUTCToday(), null, this.callContext));
    }

    @Test(groups={"slow"})
    public void testAdjustPartialRecurringInvoiceItem() throws Exception {
        this.testAdjustPartialInvoiceItem(true);
    }

    @Test(groups={"slow"}, description="https://github.com/killbill/killbill/pull/831")
    public void testAdjustPartialFixedInvoiceItem() throws Exception {
        this.testAdjustPartialInvoiceItem(false);
    }

    private void testAdjustPartialInvoiceItem(boolean recurring) throws Exception {
        Account account = this.invoiceUtil.createAccount(this.callContext);
        UUID accountId = account.getId();
        BigDecimal fixedPrice = recurring ? null : BigDecimal.ONE;
        BigDecimal recurringPrice = !recurring ? null : BigDecimal.ONE;
        UUID invoiceId = this.invoiceUtil.generateRegularInvoice(account, fixedPrice, recurringPrice, null, this.callContext);
        InvoiceItem invoiceItem = (InvoiceItem)this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext).getInvoiceItems().get(0);
        Assert.assertEquals((int)invoiceItem.getAmount().compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal invoiceBalance = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)invoiceBalance.compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountBalance, (Object)invoiceBalance);
        BigDecimal adjAmount = invoiceItem.getAmount().subtract(new BigDecimal("0.01"));
        InvoiceItem adjInvoiceItem = this.invoiceUserApi.insertInvoiceItemAdjustment(accountId, invoiceId, invoiceItem.getId(), this.clock.getUTCToday(), adjAmount, accountCurrency, null, this.callContext);
        Assert.assertEquals((Object)adjInvoiceItem.getInvoiceId(), (Object)invoiceId);
        Assert.assertEquals((Object)adjInvoiceItem.getInvoiceItemType(), (Object)InvoiceItemType.ITEM_ADJ);
        Assert.assertEquals((Object)adjInvoiceItem.getAccountId(), (Object)accountId);
        Assert.assertEquals((Object)adjInvoiceItem.getAmount(), (Object)adjAmount.negate());
        Assert.assertEquals((Object)adjInvoiceItem.getCurrency(), (Object)accountCurrency);
        Assert.assertEquals((Object)adjInvoiceItem.getLinkedItemId(), (Object)invoiceItem.getId());
        BigDecimal adjustedInvoiceBalance = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext).getBalance();
        this.verifyAdjustedInvoiceBalance(invoiceBalance, adjAmount, accountCurrency, adjustedInvoiceBalance);
        BigDecimal adjustedAccountBalance = this.invoiceUserApi.getAccountBalance(accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)adjustedAccountBalance, (Object)adjustedInvoiceBalance);
        this.invoiceUtil.generateInvoice(account.getId(), null, new TestInvoiceHelper.DryRunFutureDateArguments(), (InternalCallContext)this.internalCallContext);
    }

    @Test(groups={"slow"})
    public void testCantAdjustInvoiceItemWithNegativeAmount() throws Exception {
        InvoiceItem invoiceItem = (InvoiceItem)this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getInvoiceItems().get(0);
        try {
            this.invoiceUserApi.insertInvoiceItemAdjustment(this.accountId, this.invoiceId, invoiceItem.getId(), this.clock.getUTCToday(), BigDecimal.TEN.negate(), accountCurrency, null, this.callContext);
            Assert.fail((String)"Should not have been able to adjust an item with a negative amount");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_ITEM_ADJUSTMENT_AMOUNT_SHOULD_BE_POSITIVE.getCode());
        }
    }

    private void verifyAdjustedInvoiceBalance(BigDecimal invoiceBalance, BigDecimal adjAmount, Currency currency, BigDecimal adjustedInvoiceBalance) {
        BigDecimal expectedBalance = KillBillMoney.of((BigDecimal)invoiceBalance.add(adjAmount.negate()), (Currency)currency);
        Assert.assertEquals((int)adjustedInvoiceBalance.compareTo(expectedBalance), (int)0);
    }

    @Test(groups={"slow"})
    public void testAddRemoveWrittenOffTag() throws InvoiceApiException, TagApiException {
        Invoice originalInvoice = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)originalInvoice.getBalance().compareTo(BigDecimal.ZERO), (int)1);
        this.invoiceUserApi.tagInvoiceAsWrittenOff(this.invoiceId, this.callContext);
        List tags = this.tagUserApi.getTagsForObject(this.invoiceId, ObjectType.INVOICE, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)tags.size(), (int)1);
        Assert.assertEquals((Object)((Tag)tags.get(0)).getTagDefinitionId(), (Object)ControlTagType.WRITTEN_OFF.getId());
        Invoice invoiceWithTag = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoiceWithTag.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        this.invoiceUserApi.tagInvoiceAsNotWrittenOff(this.invoiceId, this.callContext);
        tags = this.tagUserApi.getTagsForObject(this.invoiceId, ObjectType.INVOICE, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)tags.size(), (int)0);
        Invoice invoiceAfterTagRemoval = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoiceAfterTagRemoval.getBalance().compareTo(BigDecimal.ZERO), (int)1);
    }

    @Test(groups={"slow"})
    public void testCommitInvoice() throws Exception {
        BigDecimal invoiceBalance = this.invoiceUserApi.getInvoice(this.invoiceId, (TenantContext)this.callContext).getBalance();
        Assert.assertEquals((int)invoiceBalance.compareTo(BigDecimal.ZERO), (int)1);
        BigDecimal accountBalance = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountBalance, (Object)invoiceBalance);
        BigDecimal creditAmount = BigDecimal.TEN;
        InvoiceItem creditInvoiceItem = this.invoiceUserApi.insertCreditForInvoice(this.accountId, null, creditAmount, this.clock.getUTCToday(), accountCurrency, null, this.callContext);
        UUID invoiceId = creditInvoiceItem.getInvoiceId();
        Invoice creditInvoice = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)creditInvoice.getStatus(), (Object)InvoiceStatus.DRAFT);
        Assert.assertEquals((Object)creditInvoiceItem.getInvoiceId(), (Object)creditInvoice.getId());
        BigDecimal accountBalance2 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)accountBalance2, (Object)accountBalance);
        this.invoiceUserApi.commitInvoice(creditInvoice.getId(), this.callContext);
        creditInvoice = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)creditInvoice.getStatus(), (Object)InvoiceStatus.COMMITTED);
        try {
            ExternalChargeInvoiceItem externalCharge = new ExternalChargeInvoiceItem(invoiceId, this.accountId, null, "Initial external charge", this.clock.getUTCToday(), new BigDecimal("12.33"), accountCurrency);
            this.invoiceUserApi.insertExternalCharges(this.accountId, this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)externalCharge), true, this.callContext);
            Assert.fail((String)"Should fail to add external charge on already committed invoice");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_ALREADY_COMMITTED.getCode());
        }
        try {
            this.invoiceUserApi.insertCreditForInvoice(this.accountId, invoiceId, creditAmount, this.clock.getUTCToday(), accountCurrency, null, this.callContext);
            Assert.fail((String)"Should fail to add credit on already committed invoice");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_ALREADY_COMMITTED.getCode());
        }
    }
}

