/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.user;

import java.math.BigDecimal;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.user.DefaultInvoiceCreationEvent;
import org.killbill.billing.invoice.api.user.DefaultInvoiceNotificationInternalEvent;
import org.killbill.billing.invoice.api.user.DefaultNullInvoiceEvent;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEventJson
extends InvoiceTestSuiteNoDB {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Test(groups={"fast"})
    public void testInvoiceCreationEvent() throws Exception {
        DefaultInvoiceCreationEvent e = new DefaultInvoiceCreationEvent(UUID.randomUUID(), UUID.randomUUID(), new BigDecimal(12.0), Currency.USD, Long.valueOf(1L), Long.valueOf(2L), null);
        String json = mapper.writeValueAsString((Object)e);
        Object obj = mapper.readValue(json, DefaultInvoiceCreationEvent.class);
        Assert.assertEquals((Object)obj, (Object)e);
    }

    @Test(groups={"fast"})
    public void testInvoiceNotificationEvent() throws Exception {
        DefaultInvoiceNotificationInternalEvent e = new DefaultInvoiceNotificationInternalEvent(UUID.randomUUID(), new BigDecimal(12.0), Currency.USD, new DateTime(), Long.valueOf(1L), Long.valueOf(2L), null);
        String json = mapper.writeValueAsString((Object)e);
        Object obj = mapper.readValue(json, DefaultInvoiceNotificationInternalEvent.class);
        Assert.assertEquals((Object)obj, (Object)e);
    }

    @Test(groups={"fast"})
    public void testEmptyInvoiceEvent() throws Exception {
        DefaultNullInvoiceEvent e = new DefaultNullInvoiceEvent(UUID.randomUUID(), new LocalDate(), Long.valueOf(1L), Long.valueOf(2L), null);
        String json = mapper.writeValueAsString((Object)e);
        Object obj = mapper.readValue(json, DefaultNullInvoiceEvent.class);
        Assert.assertEquals((Object)obj, (Object)e);
    }
}

