/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.user;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.model.ExternalChargeInvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.ControlTagType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceFlagBehaviors
extends InvoiceTestSuiteWithEmbeddedDB {
    private UUID accountId;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        Account account = this.invoiceUtil.createAccount(this.callContext);
        this.accountId = account.getId();
    }

    @Test(groups={"slow"}, description="Verify invoice/account balance with a WRITTEN_OFF invoice. Verify account credit is not used against such invoice")
    public void testWrittenOffInvoiceBeforeAccountCredit() throws Exception {
        List items = this.invoiceUserApi.insertExternalCharges(this.accountId, null, (Iterable)ImmutableList.of((Object)new ExternalChargeInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.accountId, null, null, null, BigDecimal.TEN, accountCurrency)), true, this.callContext);
        Assert.assertEquals((int)items.size(), (int)1);
        UUID invoiceId = ((InvoiceItem)items.get(0)).getInvoiceId();
        Invoice invoice0 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoice0.getBalance().compareTo(BigDecimal.TEN), (int)0);
        BigDecimal accountBalance0 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance0.compareTo(BigDecimal.TEN), (int)0);
        BigDecimal accountCBA0 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA0.compareTo(BigDecimal.ZERO), (int)0);
        this.tagUserApi.addTag(invoiceId, ObjectType.INVOICE, ControlTagType.WRITTEN_OFF.getId(), this.callContext);
        Invoice invoice1 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountBalance1 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance1.compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountCBA1 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA1.compareTo(BigDecimal.ZERO), (int)0);
        this.invoiceUserApi.insertCredit(this.accountId, BigDecimal.TEN, null, accountCurrency, true, null, this.callContext);
        Invoice invoice2 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        Assert.assertEquals((int)invoice2.getInvoiceItems().size(), (int)1);
        BigDecimal accountBalance2 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance2.compareTo(new BigDecimal("-10.00")), (int)0);
        BigDecimal accountCBA2 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA2.compareTo(BigDecimal.TEN), (int)0);
    }

    @Test(groups={"slow"}, description="Verify invoice/account balance with a WRITTEN_OFF invoice. Verify behavior when WRITTEN_OFF tag is added after credit was added to invoice")
    public void testWrittenOffInvoiceWithAccountCredit() throws Exception {
        this.invoiceUserApi.insertCredit(this.accountId, BigDecimal.TEN, null, accountCurrency, true, null, this.callContext);
        BigDecimal accountBalance0 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance0.compareTo(new BigDecimal("-10.0")), (int)0);
        BigDecimal accountCBA0 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA0.compareTo(BigDecimal.TEN), (int)0);
        List items = this.invoiceUserApi.insertExternalCharges(this.accountId, null, (Iterable)ImmutableList.of((Object)new ExternalChargeInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.accountId, null, null, null, new BigDecimal("13.5"), accountCurrency)), true, this.callContext);
        Assert.assertEquals((int)items.size(), (int)1);
        BigDecimal accountBalance1 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance1.compareTo(new BigDecimal("3.5")), (int)0);
        BigDecimal accountCBA1 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA1.compareTo(BigDecimal.ZERO), (int)0);
        this.tagUserApi.addTag(((InvoiceItem)items.get(0)).getInvoiceId(), ObjectType.INVOICE, ControlTagType.WRITTEN_OFF.getId(), this.callContext);
        BigDecimal accountBalance2 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance2.compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountCBA2 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA2.compareTo(BigDecimal.ZERO), (int)0);
    }

    @Test(groups={"slow"}, description="Verify invoice/account balance with migrated invoice. Verify account credit is not consumed and that invoice/account balance does not take into account migrated invoice.")
    public void testMigratedInvoiceWithAccountCredit() throws Exception {
        this.invoiceUserApi.insertCredit(this.accountId, BigDecimal.TEN, null, accountCurrency, true, null, this.callContext);
        UUID invoiceId = this.invoiceUserApi.createMigrationInvoice(this.accountId, null, (Iterable)ImmutableList.of((Object)new FixedPriceInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.accountId, null, null, "foo", "bar", null, null, BigDecimal.ONE, accountCurrency)), this.callContext);
        Invoice invoice1 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountBalance0 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance0.compareTo(new BigDecimal("-10.0")), (int)0);
        BigDecimal accountCBA0 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA0.compareTo(BigDecimal.TEN), (int)0);
    }

    @Test(groups={"slow"}, description="Verify invoice/account balance with DRAFT invoice. Verify that invoice/account balance are ZERO in DRAFT mode but becomes visible after it hasa been COMMITTED.")
    public void testDraftInvoiceWithAccountCredit() throws Exception {
        this.invoiceUserApi.insertCredit(this.accountId, BigDecimal.TEN, null, accountCurrency, true, null, this.callContext);
        List items = this.invoiceUserApi.insertExternalCharges(this.accountId, null, (Iterable)ImmutableList.of((Object)new ExternalChargeInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.accountId, null, null, null, new BigDecimal("4.0"), accountCurrency)), false, this.callContext);
        Assert.assertEquals((int)items.size(), (int)1);
        UUID invoiceId = ((InvoiceItem)items.get(0)).getInvoiceId();
        Invoice invoice1 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)invoice1.getStatus(), (Object)InvoiceStatus.DRAFT);
        Assert.assertEquals((int)invoice1.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountBalance0 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance0.compareTo(new BigDecimal("-10.0")), (int)0);
        BigDecimal accountCBA0 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA0.compareTo(BigDecimal.TEN), (int)0);
        this.invoiceUserApi.commitInvoice(invoiceId, this.callContext);
        Invoice invoice2 = this.invoiceUserApi.getInvoice(invoiceId, (TenantContext)this.callContext);
        Assert.assertEquals((Object)invoice2.getStatus(), (Object)InvoiceStatus.COMMITTED);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        BigDecimal accountBalance1 = this.invoiceUserApi.getAccountBalance(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountBalance1.compareTo(new BigDecimal("-6.0")), (int)0);
        BigDecimal accountCBA1 = this.invoiceUserApi.getAccountCBA(this.accountId, (TenantContext)this.callContext);
        Assert.assertEquals((int)accountCBA1.compareTo(new BigDecimal("6.0")), (int)0);
    }
}

