/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.dao;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceDispatcher;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.api.user.DefaultInvoiceCreationEvent;
import org.killbill.billing.invoice.dao.InvoiceDao;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDaoHelper;
import org.killbill.billing.invoice.dao.InvoiceParentChildModelDao;
import org.killbill.billing.invoice.dao.InvoicePaymentModelDao;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.MockEntityDaoBase;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockInvoiceDao
extends MockEntityDaoBase<InvoiceModelDao, Invoice, InvoiceApiException>
implements InvoiceDao {
    private final PersistentBus eventBus;
    private final Object monitor = new Object();
    private final Map<UUID, InvoiceModelDao> invoices = new LinkedHashMap<UUID, InvoiceModelDao>();
    private final Map<UUID, InvoiceItemModelDao> items = new LinkedHashMap<UUID, InvoiceItemModelDao>();
    private final Map<UUID, InvoicePaymentModelDao> payments = new LinkedHashMap<UUID, InvoicePaymentModelDao>();
    private final BiMap<UUID, Long> accountRecordIds = HashBiMap.create();

    @Inject
    public MockInvoiceDao(PersistentBus eventBus) {
        this.eventBus = eventBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInvoice(InvoiceModelDao invoice, InvoiceDispatcher.FutureAccountNotifications callbackDateTimePerSubscriptions, InternalCallContext context) {
        Object object = this.monitor;
        synchronized (object) {
            this.storeInvoice(invoice, context);
        }
        try {
            this.eventBus.post((BusEvent)new DefaultInvoiceCreationEvent(invoice.getId(), invoice.getAccountId(), InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice), invoice.getCurrency(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()));
        }
        catch (PersistentBus.EventBusException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setFutureAccountNotificationsForEmptyInvoice(UUID accountId, InvoiceDispatcher.FutureAccountNotifications callbackDateTimePerSubscriptions, InternalCallContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoiceItemModelDao> createInvoices(List<InvoiceModelDao> invoiceModelDaos, InternalCallContext context) {
        Object object = this.monitor;
        synchronized (object) {
            LinkedList<InvoiceItemModelDao> createdItems = new LinkedList<InvoiceItemModelDao>();
            for (InvoiceModelDao invoice : invoiceModelDaos) {
                createdItems.addAll(this.storeInvoice(invoice, context));
            }
            return createdItems;
        }
    }

    private Collection<InvoiceItemModelDao> storeInvoice(InvoiceModelDao invoice, InternalCallContext context) {
        LinkedList<InvoiceItemModelDao> createdItems = new LinkedList<InvoiceItemModelDao>();
        this.invoices.put(invoice.getId(), invoice);
        for (InvoiceItemModelDao invoiceItemModelDao : invoice.getInvoiceItems()) {
            InvoiceItemModelDao oldItemOrNull = this.items.put(invoiceItemModelDao.getId(), invoiceItemModelDao);
            if (oldItemOrNull != null) continue;
            createdItems.add(invoiceItemModelDao);
        }
        this.accountRecordIds.put((Object)invoice.getAccountId(), (Object)context.getAccountRecordId());
        return createdItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvoiceModelDao getById(UUID id, InternalTenantContext context) {
        Object object = this.monitor;
        synchronized (object) {
            return this.invoices.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvoiceModelDao getByNumber(Integer number, InternalTenantContext context) {
        Object object = this.monitor;
        synchronized (object) {
            for (InvoiceModelDao invoice : this.invoices.values()) {
                if (!invoice.getInvoiceNumber().equals(number)) continue;
                return invoice;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pagination<InvoiceModelDao> getAll(InternalTenantContext context) {
        Object object = this.monitor;
        synchronized (object) {
            return new DefaultPagination(Long.valueOf(this.invoices.values().size()), this.invoices.values().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoiceModelDao> getInvoicesByAccount(InternalTenantContext context) {
        ArrayList<InvoiceModelDao> result = new ArrayList<InvoiceModelDao>();
        Object object = this.monitor;
        synchronized (object) {
            UUID accountId = (UUID)this.accountRecordIds.inverse().get((Object)context.getAccountRecordId());
            for (InvoiceModelDao invoice : this.invoices.values()) {
                if (!accountId.equals(invoice.getAccountId()) || invoice.isMigrated()) continue;
                result.add(invoice);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoiceModelDao> getInvoicesByAccount(LocalDate fromDate, InternalTenantContext context) {
        ArrayList<InvoiceModelDao> invoicesForAccount = new ArrayList<InvoiceModelDao>();
        Object object = this.monitor;
        synchronized (object) {
            UUID accountId = (UUID)this.accountRecordIds.inverse().get((Object)context.getAccountRecordId());
            for (InvoiceModelDao invoice : this.getAll(context)) {
                if (!accountId.equals(invoice.getAccountId()) || invoice.getTargetDate().isBefore((ReadablePartial)fromDate) || invoice.isMigrated()) continue;
                invoicesForAccount.add(invoice);
            }
        }
        return invoicesForAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoiceModelDao> getInvoicesBySubscription(UUID subscriptionId, InternalTenantContext context) {
        ArrayList<InvoiceModelDao> result = new ArrayList<InvoiceModelDao>();
        Object object = this.monitor;
        synchronized (object) {
            block3: for (InvoiceModelDao invoice : this.invoices.values()) {
                for (InvoiceItemModelDao item : invoice.getInvoiceItems()) {
                    if (!subscriptionId.equals(item.getSubscriptionId()) || invoice.isMigrated()) continue;
                    result.add(invoice);
                    continue block3;
                }
            }
        }
        return result;
    }

    public Pagination<InvoiceModelDao> searchInvoices(String searchKey, Long offset, Long limit, InternalTenantContext context) {
        LinkedList<InvoiceModelDao> results = new LinkedList<InvoiceModelDao>();
        int maxNbRecords = 0;
        for (InvoiceModelDao invoice : this.getAll(context)) {
            ++maxNbRecords;
            if (!invoice.getId().toString().equals(searchKey) && !invoice.getAccountId().toString().equals(searchKey) && !invoice.getInvoiceNumber().toString().equals(searchKey) && !invoice.getCurrency().toString().equals(searchKey)) continue;
            results.add(invoice);
        }
        return DefaultPagination.build((Long)offset, (Long)limit, (Integer)maxNbRecords, results);
    }

    public void test(InternalTenantContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getInvoiceIdByPaymentId(UUID paymentId, InternalTenantContext context) {
        Object object = this.monitor;
        synchronized (object) {
            for (InvoicePaymentModelDao payment : this.payments.values()) {
                if (!paymentId.equals(payment.getPaymentId())) continue;
                return payment.getInvoiceId();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoicePaymentModelDao> getInvoicePaymentsByPaymentId(UUID paymentId, InternalTenantContext context) {
        LinkedList<InvoicePaymentModelDao> result = new LinkedList<InvoicePaymentModelDao>();
        Object object = this.monitor;
        synchronized (object) {
            for (InvoicePaymentModelDao payment : this.payments.values()) {
                if (!paymentId.equals(payment.getPaymentId())) continue;
                result.add(payment);
            }
        }
        return result;
    }

    public List<InvoicePaymentModelDao> getInvoicePaymentsByAccount(InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfPaymentCompletion(InvoicePaymentModelDao invoicePayment, InternalCallContext context) {
        Object object = this.monitor;
        synchronized (object) {
            this.payments.put(invoicePayment.getId(), invoicePayment);
        }
    }

    public void consumeExstingCBAOnAccountWithUnpaidInvoices(UUID accountId, InternalCallContext context) {
    }

    public BigDecimal getAccountBalance(UUID accountId, InternalTenantContext context) {
        BigDecimal balance = BigDecimal.ZERO;
        for (InvoiceModelDao invoice : this.getAll(context)) {
            if (!accountId.equals(invoice.getAccountId())) continue;
            balance = balance.add(InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice));
        }
        return balance;
    }

    public List<InvoiceModelDao> getUnpaidInvoicesByAccountId(UUID accountId, LocalDate upToDate, InternalTenantContext context) {
        ArrayList<InvoiceModelDao> unpaidInvoices = new ArrayList<InvoiceModelDao>();
        for (InvoiceModelDao invoice : this.getAll(context)) {
            if (!accountId.equals(invoice.getAccountId()) || InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice).compareTo(BigDecimal.ZERO) <= 0 || invoice.isMigrated()) continue;
            unpaidInvoices.add(invoice);
        }
        return unpaidInvoices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvoiceModelDao> getAllInvoicesByAccount(InternalTenantContext context) {
        ArrayList<InvoiceModelDao> result = new ArrayList<InvoiceModelDao>();
        Object object = this.monitor;
        synchronized (object) {
            UUID accountId = (UUID)this.accountRecordIds.inverse().get((Object)context.getAccountRecordId());
            for (InvoiceModelDao invoice : this.invoices.values()) {
                if (!accountId.equals(invoice.getAccountId())) continue;
                result.add(invoice);
            }
        }
        return result;
    }

    public InvoicePaymentModelDao postChargeback(UUID invoicePaymentId, String chargebackTransactionExternalKey, BigDecimal amount, Currency currency, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public InvoicePaymentModelDao postChargebackReversal(UUID paymentId, String chargebackTransactionExternalKey, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public InvoiceItemModelDao doCBAComplexity(InvoiceModelDao invoice, InternalCallContext context) throws InvoiceApiException {
        return null;
    }

    public Map<UUID, BigDecimal> computeItemAdjustments(String invoiceId, Map<UUID, BigDecimal> invoiceItemIdsWithNullAmounts, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getRemainingAmountPaid(UUID invoicePaymentId, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public UUID getAccountIdFromInvoicePaymentId(UUID invoicePaymentId, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public List<InvoicePaymentModelDao> getChargebacksByAccountId(UUID accountId, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public List<InvoicePaymentModelDao> getChargebacksByPaymentId(UUID paymentId, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public InvoicePaymentModelDao getChargebackById(UUID chargebackId, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public InvoiceItemModelDao getExternalChargeById(UUID externalChargeId, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public InvoiceItemModelDao getCreditById(UUID creditId, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getAccountCBA(UUID accountId, InternalTenantContext context) {
        return null;
    }

    public InvoicePaymentModelDao createRefund(UUID paymentId, BigDecimal amount, boolean isInvoiceAdjusted, Map<UUID, BigDecimal> invoiceItemIdsWithAmounts, String transactionExternalKey, InternalCallContext context) throws InvoiceApiException {
        return null;
    }

    public void deleteCBA(UUID accountId, UUID invoiceId, UUID invoiceItemId, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfPaymentInit(InvoicePaymentModelDao invoicePayment, InternalCallContext context) {
        Object object = this.monitor;
        synchronized (object) {
            this.payments.put(invoicePayment.getId(), invoicePayment);
        }
    }

    public void changeInvoiceStatus(UUID invoiceId, InvoiceStatus newState, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public void createParentChildInvoiceRelation(InvoiceParentChildModelDao invoiceRelation, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public InvoiceModelDao getParentDraftInvoice(UUID parentAccountId, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public List<InvoiceParentChildModelDao> getChildInvoicesByParentInvoiceId(UUID parentInvoiceId, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public void updateInvoiceItemAmount(UUID invoiceItemId, BigDecimal amount, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public void transferChildCreditToParent(Account childAccount, InternalCallContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }

    public List<InvoiceItemModelDao> getInvoiceItemsByParentInvoice(UUID parentInvoiceId, InternalTenantContext context) throws InvoiceApiException {
        throw new UnsupportedOperationException();
    }
}

