/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.dao;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.dao.InvoicePaymentModelDao;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultInvoiceDaoUnit
extends InvoiceTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testComputePositiveRefundAmount() throws Exception {
        ImmutableMap noItemAdjustment = ImmutableMap.of();
        this.verifyComputedRefundAmount(null, null, (Map<UUID, BigDecimal>)noItemAdjustment, BigDecimal.ZERO);
        this.verifyComputedRefundAmount(null, BigDecimal.ZERO, (Map<UUID, BigDecimal>)noItemAdjustment, BigDecimal.ZERO);
        this.verifyComputedRefundAmount(BigDecimal.TEN, null, (Map<UUID, BigDecimal>)noItemAdjustment, BigDecimal.TEN);
        this.verifyComputedRefundAmount(BigDecimal.TEN, BigDecimal.ONE, (Map<UUID, BigDecimal>)noItemAdjustment, BigDecimal.ONE);
        try {
            this.verifyComputedRefundAmount(BigDecimal.ONE, BigDecimal.TEN, (Map<UUID, BigDecimal>)noItemAdjustment, BigDecimal.TEN);
            Assert.fail((String)"Shouldn't have been able to compute a refund amount");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.REFUND_AMOUNT_TOO_HIGH.getCode());
        }
        ImmutableMap itemAdjustments = ImmutableMap.of((Object)UUID.randomUUID(), (Object)BigDecimal.ONE, (Object)UUID.randomUUID(), (Object)BigDecimal.TEN, (Object)UUID.randomUUID(), (Object)BigDecimal.ZERO);
        this.verifyComputedRefundAmount(new BigDecimal("100"), new BigDecimal("11"), (Map<UUID, BigDecimal>)itemAdjustments, new BigDecimal("11"));
        try {
            this.verifyComputedRefundAmount(new BigDecimal("100"), BigDecimal.TEN, (Map<UUID, BigDecimal>)itemAdjustments, BigDecimal.TEN);
            Assert.fail((String)"Shouldn't have been able to compute a refund amount");
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.REFUND_AMOUNT_DONT_MATCH_ITEMS_TO_ADJUST.getCode());
        }
    }

    private void verifyComputedRefundAmount(BigDecimal paymentAmount, BigDecimal requestedAmount, Map<UUID, BigDecimal> invoiceItemIdsWithAmounts, BigDecimal expectedRefundAmount) throws InvoiceApiException {
        InvoicePaymentModelDao invoicePayment = (InvoicePaymentModelDao)Mockito.mock(InvoicePaymentModelDao.class);
        Mockito.when((Object)invoicePayment.getAmount()).thenReturn((Object)paymentAmount);
        BigDecimal actualRefundAmount = this.invoiceDaoHelper.computePositiveRefundAmount(invoicePayment, requestedAmount, invoiceItemIdsWithAmounts);
        Assert.assertEquals((Object)actualRefundAmount, (Object)expectedRefundAmount);
    }
}

