/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.MockBillingEventSet;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDaoHelper;
import org.killbill.billing.invoice.dao.InvoiceParentChildModelDao;
import org.killbill.billing.invoice.dao.InvoicePaymentModelDao;
import org.killbill.billing.invoice.generator.InvoiceWithMetadata;
import org.killbill.billing.invoice.model.CreditAdjInvoiceItem;
import org.killbill.billing.invoice.model.CreditBalanceAdjInvoiceItem;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.DefaultInvoicePayment;
import org.killbill.billing.invoice.model.ExternalChargeInvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.ItemAdjInvoiceItem;
import org.killbill.billing.invoice.model.ParentInvoiceItem;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.invoice.model.RepairAdjInvoiceItem;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.util.currency.KillBillMoney;
import org.mockito.Mockito;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceDao
extends InvoiceTestSuiteWithEmbeddedDB {
    private Account account;
    private InternalCallContext context;

    @BeforeMethod(groups={"slow"})
    public void setUp() throws Exception {
        this.account = this.invoiceUtil.createAccount(this.callContext);
        this.context = this.internalCallContextFactory.createInternalCallContext(this.account.getId(), this.callContext);
    }

    @Test(groups={"slow"})
    public void testSimple() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        InvoiceModelDao retrievedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        this.invoiceUtil.checkInvoicesEqual(retrievedInvoice, (Invoice)invoice);
        this.invoiceUtil.checkInvoicesEqual(this.invoiceDao.getByNumber(retrievedInvoice.getInvoiceNumber(), (InternalTenantContext)this.context), (Invoice)invoice);
    }

    @Test(groups={"slow"})
    public void testCreationAndRetrievalByAccount() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        LocalDate invoiceDate = invoice.getInvoiceDate();
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        List invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertNotNull((Object)invoices);
        Assert.assertEquals((int)invoices.size(), (int)1);
        InvoiceModelDao thisInvoice = (InvoiceModelDao)invoices.get(0);
        Assert.assertEquals((Object)invoice.getAccountId(), (Object)accountId);
        Assert.assertTrue((thisInvoice.getInvoiceDate().compareTo((ReadablePartial)invoiceDate) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)thisInvoice.getCurrency(), (Object)Currency.USD);
        Assert.assertEquals((int)thisInvoice.getInvoiceItems().size(), (int)0);
        Assert.assertTrue((InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)thisInvoice).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"slow"})
    public void testInvoicePayment() throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        UUID invoiceId = invoice.getId();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2010, 1, 1);
        LocalDate endDate = new LocalDate(2010, 4, 1);
        RecurringInvoiceItem invoiceItem = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test plan", "test phase", startDate, endDate, new BigDecimal("21.00"), new BigDecimal("7.00"), Currency.USD);
        invoice.addInvoiceItem((InvoiceItem)invoiceItem);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        InvoiceModelDao savedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoiceId, (InternalTenantContext)this.context);
        Assert.assertNotNull((Object)savedInvoice);
        Assert.assertEquals((int)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)savedInvoice).compareTo(new BigDecimal("21.00")), (int)0);
        Assert.assertEquals((int)savedInvoice.getInvoiceItems().size(), (int)1);
        BigDecimal paymentAmount = new BigDecimal("11.00");
        UUID paymentId = UUID.randomUUID();
        DefaultInvoicePayment defaultInvoicePayment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoiceId, this.clock.getUTCNow().plusDays(12), paymentAmount, Currency.USD, Currency.USD, "cookie", Boolean.valueOf(true));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment), this.context);
        InvoiceModelDao retrievedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoiceId, (InternalTenantContext)this.context);
        Assert.assertNotNull((Object)retrievedInvoice);
        Assert.assertEquals((int)retrievedInvoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((int)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)retrievedInvoice).compareTo(new BigDecimal("10.00")), (int)0);
    }

    @Test(groups={"slow"})
    public void testRetrievalForNonExistentInvoiceOrInvoiceItem() throws InvoiceApiException {
        try {
            this.invoiceDao.getById(UUID.randomUUID(), (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (TransactionFailedException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvoiceApiException));
            Assert.assertEquals((int)((InvoiceApiException)e.getCause()).getCode(), (int)ErrorCode.INVOICE_NOT_FOUND.getCode());
        }
        try {
            this.invoiceDao.getByNumber(null, (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_INVALID_NUMBER.getCode());
        }
        try {
            this.invoiceDao.getByNumber(Integer.valueOf(Integer.MIN_VALUE), (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_NUMBER_NOT_FOUND.getCode());
        }
        try {
            this.invoiceDao.getChargebackById(UUID.randomUUID(), (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CHARGE_BACK_DOES_NOT_EXIST.getCode());
        }
        try {
            this.invoiceDao.getExternalChargeById(UUID.randomUUID(), (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_ITEM_NOT_FOUND.getCode());
        }
        try {
            this.invoiceDao.getCreditById(UUID.randomUUID(), (InternalTenantContext)this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_ITEM_NOT_FOUND.getCode());
        }
    }

    @Test(groups={"slow"})
    public void testCreateRefundOnNonExistingPayment() throws Exception {
        try {
            this.invoiceDao.createRefund(UUID.randomUUID(), BigDecimal.TEN, false, (Map)ImmutableMap.of(), null, this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_PAYMENT_BY_ATTEMPT_NOT_FOUND.getCode());
        }
    }

    @Test(groups={"slow"})
    public void testGetInvoicesBySubscriptionForRecurringItems() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        BigDecimal rate1 = new BigDecimal("17.0");
        UUID subscriptionId2 = UUID.randomUUID();
        BigDecimal rate2 = new BigDecimal("42.0");
        UUID subscriptionId3 = UUID.randomUUID();
        BigDecimal rate3 = new BigDecimal("3.0");
        UUID subscriptionId4 = UUID.randomUUID();
        BigDecimal rate4 = new BigDecimal("12.0");
        LocalDate targetDate = new LocalDate(2011, 5, 23);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        UUID invoiceId1 = invoice1.getId();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId1, "test plan", "test A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId2, "test plan", "test B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        RecurringInvoiceItem item3 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId3, "test plan", "test C", startDate, endDate, rate3, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item3, this.context);
        RecurringInvoiceItem item4 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId4, "test plan", "test D", startDate, endDate, rate4, rate4, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item4, this.context);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        UUID invoiceId2 = invoice2.getId();
        startDate = endDate;
        endDate = startDate.plusMonths(1);
        RecurringInvoiceItem item5 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId1, "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item5, this.context);
        RecurringInvoiceItem item6 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId2, "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item6, this.context);
        RecurringInvoiceItem item7 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId3, "test plan", "test phase C", startDate, endDate, rate3, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item7, this.context);
        List items1 = this.invoiceDao.getInvoicesBySubscription(subscriptionId1, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items1.size(), (int)2);
        List items2 = this.invoiceDao.getInvoicesBySubscription(subscriptionId2, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items2.size(), (int)2);
        List items3 = this.invoiceDao.getInvoicesBySubscription(subscriptionId3, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items3.size(), (int)2);
        List items4 = this.invoiceDao.getInvoicesBySubscription(subscriptionId4, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items4.size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testGetInvoicesBySubscriptionForFixedItems() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        BigDecimal rate1 = new BigDecimal("17.0");
        UUID subscriptionId2 = UUID.randomUUID();
        BigDecimal rate2 = new BigDecimal("42.0");
        UUID subscriptionId3 = UUID.randomUUID();
        BigDecimal rate3 = new BigDecimal("3.0");
        UUID subscriptionId4 = UUID.randomUUID();
        BigDecimal rate4 = new BigDecimal("12.0");
        LocalDate targetDate = new LocalDate(2011, 5, 23);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        UUID invoiceId1 = invoice1.getId();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        FixedPriceInvoiceItem item1 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId1, "test plan", "test A", startDate, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        FixedPriceInvoiceItem item2 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId2, "test plan", "test B", startDate, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        FixedPriceInvoiceItem item3 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId3, "test plan", "test C", startDate, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item3, this.context);
        FixedPriceInvoiceItem item4 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId4, "test plan", "test D", startDate, rate4, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item4, this.context);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        UUID invoiceId2 = invoice2.getId();
        startDate = endDate;
        FixedPriceInvoiceItem item5 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId1, "test plan", "test phase A", startDate, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item5, this.context);
        FixedPriceInvoiceItem item6 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId2, "test plan", "test phase B", startDate, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item6, this.context);
        FixedPriceInvoiceItem item7 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId3, "test plan", "test phase C", startDate, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item7, this.context);
        List items1 = this.invoiceDao.getInvoicesBySubscription(subscriptionId1, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items1.size(), (int)2);
        List items2 = this.invoiceDao.getInvoicesBySubscription(subscriptionId2, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items2.size(), (int)2);
        List items3 = this.invoiceDao.getInvoicesBySubscription(subscriptionId3, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items3.size(), (int)2);
        List items4 = this.invoiceDao.getInvoicesBySubscription(subscriptionId4, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items4.size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testGetInvoicesBySubscriptionForRecurringAndFixedItems() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        BigDecimal rate1 = new BigDecimal("17.0");
        UUID subscriptionId2 = UUID.randomUUID();
        BigDecimal rate2 = new BigDecimal("42.0");
        UUID subscriptionId3 = UUID.randomUUID();
        BigDecimal rate3 = new BigDecimal("3.0");
        UUID subscriptionId4 = UUID.randomUUID();
        BigDecimal rate4 = new BigDecimal("12.0");
        LocalDate targetDate = new LocalDate(2011, 5, 23);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        UUID invoiceId1 = invoice1.getId();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        RecurringInvoiceItem recurringItem1 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId1, "test plan", "test A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem1, this.context);
        RecurringInvoiceItem recurringItem2 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId2, "test plan", "test B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem2, this.context);
        RecurringInvoiceItem recurringItem3 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId3, "test plan", "test C", startDate, endDate, rate3, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem3, this.context);
        RecurringInvoiceItem recurringItem4 = new RecurringInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId4, "test plan", "test D", startDate, endDate, rate4, rate4, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem4, this.context);
        FixedPriceInvoiceItem fixedItem1 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId1, "test plan", "test A", startDate, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem1, this.context);
        FixedPriceInvoiceItem fixedItem2 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId2, "test plan", "test B", startDate, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem2, this.context);
        FixedPriceInvoiceItem fixedItem3 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId3, "test plan", "test C", startDate, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem3, this.context);
        FixedPriceInvoiceItem fixedItem4 = new FixedPriceInvoiceItem(invoiceId1, accountId, bundleId, subscriptionId4, "test plan", "test D", startDate, rate4, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem4, this.context);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        UUID invoiceId2 = invoice2.getId();
        startDate = endDate;
        endDate = startDate.plusMonths(1);
        RecurringInvoiceItem recurringItem5 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId1, "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem5, this.context);
        RecurringInvoiceItem recurringItem6 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId2, "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem6, this.context);
        RecurringInvoiceItem recurringItem7 = new RecurringInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId3, "test plan", "test phase C", startDate, endDate, rate3, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)recurringItem7, this.context);
        FixedPriceInvoiceItem fixedItem5 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId1, "test plan", "test phase A", startDate, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem5, this.context);
        FixedPriceInvoiceItem fixedItem6 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId2, "test plan", "test phase B", startDate, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem6, this.context);
        FixedPriceInvoiceItem fixedItem7 = new FixedPriceInvoiceItem(invoiceId2, accountId, bundleId, subscriptionId3, "test plan", "test phase C", startDate, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem7, this.context);
        List items1 = this.invoiceDao.getInvoicesBySubscription(subscriptionId1, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items1.size(), (int)4);
        List items2 = this.invoiceDao.getInvoicesBySubscription(subscriptionId2, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items2.size(), (int)4);
        List items3 = this.invoiceDao.getInvoicesBySubscription(subscriptionId3, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items3.size(), (int)4);
        List items4 = this.invoiceDao.getInvoicesBySubscription(subscriptionId4, (InternalTenantContext)this.context);
        Assert.assertEquals((int)items4.size(), (int)2);
    }

    @Test(groups={"slow"})
    public void testGetInvoicesForAccountAfterDate() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate targetDate2 = new LocalDate(2011, 12, 6);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate2, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        List invoices = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 1, 1), (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)2);
        invoices = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 10, 6), (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)2);
        invoices = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 10, 11), (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        invoices = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 12, 6), (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        invoices = this.invoiceDao.getInvoicesByAccount(new LocalDate(2012, 1, 1), (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountBalance() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("17.0");
        BigDecimal rate2 = new BigDecimal("42.0");
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        BigDecimal payment1 = new BigDecimal("48.0");
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice1.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(rate1.add(rate2).subtract(payment1)), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithCredit() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("17.0");
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        CreditAdjInvoiceItem creditItem = new CreditAdjInvoiceItem(invoice1.getId(), accountId, new LocalDate(), null, rate1.negate(), Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditItem, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(BigDecimal.ZERO), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithNoPayments() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("17.0");
        BigDecimal rate2 = new BigDecimal("42.0");
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(rate1.add(rate2)), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithNoInvoiceItems() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        BigDecimal payment1 = new BigDecimal("48.0");
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice1.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(BigDecimal.ZERO.subtract(payment1)), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithRefundNoAdj() throws InvoiceApiException, EntityPersistenceException {
        this.testAccountBalanceWithRefundInternal(false);
    }

    private void testAccountBalanceWithRefundInternal(boolean withAdjustment) throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("20.0");
        BigDecimal refund1 = new BigDecimal("7.00");
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("20.00")), (int)0);
        UUID paymentId = UUID.randomUUID();
        BigDecimal payment1 = rate1;
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice1.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("0.00")), (int)0);
        this.invoiceDao.createRefund(paymentId, refund1, withAdjustment, (Map)ImmutableMap.of(), UUID.randomUUID().toString(), this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        if (withAdjustment) {
            Assert.assertEquals((int)balance.compareTo(BigDecimal.ZERO), (int)0);
        } else {
            Assert.assertEquals((int)balance.compareTo(new BigDecimal("7.00")), (int)0);
        }
    }

    @Test(groups={"slow"})
    public void testFullRefundWithRepairAndInvoiceItemAdjustment() throws InvoiceApiException, EntityPersistenceException {
        BigDecimal refundAmount = new BigDecimal("20.00");
        this.testRefundWithRepairAndInvoiceItemAdjustmentInternal(refundAmount);
    }

    @Test(groups={"slow"})
    public void testPartialRefundWithRepairAndInvoiceItemAdjustment() throws InvoiceApiException, EntityPersistenceException {
        BigDecimal refundAmount = new BigDecimal("7.00");
        this.testRefundWithRepairAndInvoiceItemAdjustmentInternal(refundAmount);
    }

    private void testRefundWithRepairAndInvoiceItemAdjustmentInternal(BigDecimal refundAmount) throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal amount = new BigDecimal("20.0");
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, amount, amount, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        BigDecimal accountBalance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)accountBalance.compareTo(new BigDecimal("20.00")), (int)0);
        UUID paymentId = UUID.randomUUID();
        BigDecimal payment1 = amount;
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        accountBalance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)accountBalance.compareTo(new BigDecimal("0.00")), (int)0);
        RepairAdjInvoiceItem repairItem = new RepairAdjInvoiceItem(invoice.getId(), accountId, startDate, endDate, amount.negate(), Currency.USD, item2.getId());
        this.invoiceUtil.createInvoiceItem((InvoiceItem)repairItem, this.context);
        CreditBalanceAdjInvoiceItem cbaItem = new CreditBalanceAdjInvoiceItem(invoice.getId(), accountId, startDate, amount, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)cbaItem, this.context);
        HashMap<UUID, Object> itemAdjustment = new HashMap<UUID, Object>();
        itemAdjustment.put(item2.getId(), null);
        this.invoiceDao.createRefund(paymentId, refundAmount, true, itemAdjustment, UUID.randomUUID().toString(), this.context);
        accountBalance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        boolean partialRefund = refundAmount.compareTo(amount) < 0;
        BigDecimal cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        InvoiceModelDao savedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        BigDecimal expectedCba = accountBalance.compareTo(BigDecimal.ZERO) < 0 ? accountBalance.negate() : BigDecimal.ZERO;
        Assert.assertEquals((int)cba.compareTo(expectedCba), (int)0);
        BigDecimal balanceAfterRefund = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        BigDecimal cbaAfterRefund = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        if (partialRefund) {
            Assert.assertEquals((int)accountBalance.compareTo(new BigDecimal("-13.0")), (int)0);
            Assert.assertEquals((int)savedInvoice.getInvoiceItems().size(), (int)4);
            Assert.assertEquals((int)balanceAfterRefund.compareTo(new BigDecimal("-13.0")), (int)0);
            Assert.assertEquals((int)cbaAfterRefund.compareTo(expectedCba), (int)0);
        } else {
            Assert.assertEquals((int)accountBalance.compareTo(new BigDecimal("0.0")), (int)0);
            Assert.assertEquals((int)savedInvoice.getInvoiceItems().size(), (int)4);
            Assert.assertEquals((int)balanceAfterRefund.compareTo(BigDecimal.ZERO), (int)0);
            Assert.assertEquals((int)cbaAfterRefund.compareTo(expectedCba), (int)0);
        }
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithSmallRefundAndCBANoAdj() throws InvoiceApiException, EntityPersistenceException {
        BigDecimal refundAmount = new BigDecimal("7.00");
        BigDecimal expectedBalance = new BigDecimal("-3.00");
        this.testAccountBalanceWithRefundAndCBAInternal(false, refundAmount, expectedBalance);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithSmallRefundAndCBAWithAdj() throws InvoiceApiException, EntityPersistenceException {
        BigDecimal refundAmount = new BigDecimal("7.00");
        BigDecimal expectedBalance = new BigDecimal("-10.00");
        this.testAccountBalanceWithRefundAndCBAInternal(true, refundAmount, expectedBalance);
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithLargeRefundAndCBANoAdj() throws InvoiceApiException, EntityPersistenceException {
        BigDecimal refundAmount = new BigDecimal("20.00");
        BigDecimal expectedBalance = new BigDecimal("10.00");
        this.testAccountBalanceWithRefundAndCBAInternal(false, refundAmount, expectedBalance);
    }

    private void testAccountBalanceWithRefundAndCBAInternal(boolean withAdjustment, BigDecimal refundAmount, BigDecimal expectedFinalBalance) throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal amount1 = new BigDecimal("5.0");
        BigDecimal rate1 = new BigDecimal("20.0");
        BigDecimal rate2 = new BigDecimal("10.0");
        FixedPriceInvoiceItem item1 = new FixedPriceInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, amount1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("5.00")), (int)0);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("25.00")), (int)0);
        UUID paymentId = UUID.randomUUID();
        BigDecimal payment1 = amount1.add(rate1);
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice1.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("0.00")), (int)0);
        RepairAdjInvoiceItem item2Repair = new RepairAdjInvoiceItem(invoice1.getId(), accountId, startDate, endDate, rate1.negate(), Currency.USD, item2.getId());
        RecurringInvoiceItem item2Replace = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2Repair, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2Replace, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("-10.00")), (int)0);
        CreditBalanceAdjInvoiceItem cbaItem = new CreditBalanceAdjInvoiceItem(invoice1.getId(), accountId, new LocalDate(), balance.negate(), Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)cbaItem, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("-10.00")), (int)0);
        BigDecimal cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)cba.compareTo(new BigDecimal("10.00")), (int)0);
        HashMap<UUID, BigDecimal> invoiceItemIdsWithAmounts = new HashMap<UUID, BigDecimal>();
        if (withAdjustment) {
            invoiceItemIdsWithAmounts.put(item2Replace.getId(), refundAmount);
        }
        this.invoiceDao.createRefund(paymentId, refundAmount, withAdjustment, invoiceItemIdsWithAmounts, UUID.randomUUID().toString(), this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(expectedFinalBalance), (int)0);
        cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        BigDecimal expectedCba = balance.compareTo(BigDecimal.ZERO) < 0 ? balance.negate() : BigDecimal.ZERO;
        Assert.assertEquals((int)cba.compareTo(expectedCba), (int)0);
    }

    @Test(groups={"slow"})
    public void testExternalChargeWithCBA() throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        InvoiceItemModelDao credit = this.createCredit(accountId, this.clock.getUTCToday(), new BigDecimal("20.0"), true);
        String description = UUID.randomUUID().toString();
        InvoiceModelDao invoiceForExternalCharge = new InvoiceModelDao(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD, false);
        InvoiceItemModelDao externalCharge = new InvoiceItemModelDao((InvoiceItem)new ExternalChargeInvoiceItem(invoiceForExternalCharge.getId(), accountId, bundleId, description, this.clock.getUTCToday(), new BigDecimal("15.0"), Currency.USD));
        invoiceForExternalCharge.addInvoiceItem(externalCharge);
        InvoiceItemModelDao charge = (InvoiceItemModelDao)this.invoiceDao.createInvoices((List)ImmutableList.of((Object)invoiceForExternalCharge), this.context).get(0);
        InvoiceModelDao newInvoice = (InvoiceModelDao)this.invoiceDao.getById(charge.getInvoiceId(), (InternalTenantContext)this.context);
        List items = newInvoice.getInvoiceItems();
        Assert.assertEquals((int)items.size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItemModelDao)items.get(0)).getType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
        Assert.assertEquals((String)((InvoiceItemModelDao)items.get(0)).getDescription(), (String)description);
        this.invoiceDao.changeInvoiceStatus(credit.getInvoiceId(), InvoiceStatus.COMMITTED, this.context);
        newInvoice = (InvoiceModelDao)this.invoiceDao.getById(charge.getInvoiceId(), (InternalTenantContext)this.context);
        items = newInvoice.getInvoiceItems();
        Assert.assertEquals((int)items.size(), (int)2);
        for (InvoiceItemModelDao cur : items) {
            if (cur.getId().equals(charge.getId())) {
                Assert.assertEquals((Object)cur.getType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
                Assert.assertEquals((String)cur.getDescription(), (String)description);
                continue;
            }
            Assert.assertEquals((Object)cur.getType(), (Object)InvoiceItemType.CBA_ADJ);
            Assert.assertTrue((cur.getAmount().compareTo(new BigDecimal("-15.00")) == 0 ? 1 : 0) != 0);
        }
    }

    @Test(groups={"slow"})
    public void testExternalChargeOnDRAFTInvoiceWithCBA() throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        InvoiceItemModelDao credit = this.createCredit(accountId, this.clock.getUTCToday(), new BigDecimal("20.0"), false);
        String description = UUID.randomUUID().toString();
        InvoiceModelDao draftInvoiceForExternalCharge = new InvoiceModelDao(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD, false, InvoiceStatus.DRAFT);
        InvoiceItemModelDao externalCharge = new InvoiceItemModelDao((InvoiceItem)new ExternalChargeInvoiceItem(draftInvoiceForExternalCharge.getId(), accountId, bundleId, description, this.clock.getUTCToday(), new BigDecimal("15.0"), Currency.USD));
        draftInvoiceForExternalCharge.addInvoiceItem(externalCharge);
        InvoiceItemModelDao charge = (InvoiceItemModelDao)this.invoiceDao.createInvoices((List)ImmutableList.of((Object)draftInvoiceForExternalCharge), this.context).get(0);
        InvoiceModelDao newInvoice = (InvoiceModelDao)this.invoiceDao.getById(charge.getInvoiceId(), (InternalTenantContext)this.context);
        List items = newInvoice.getInvoiceItems();
        Assert.assertEquals((int)items.size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItemModelDao)items.get(0)).getType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
        Assert.assertEquals((String)((InvoiceItemModelDao)items.get(0)).getDescription(), (String)description);
        this.invoiceDao.changeInvoiceStatus(charge.getInvoiceId(), InvoiceStatus.COMMITTED, this.context);
        newInvoice = (InvoiceModelDao)this.invoiceDao.getById(charge.getInvoiceId(), (InternalTenantContext)this.context);
        items = newInvoice.getInvoiceItems();
        Assert.assertEquals((int)items.size(), (int)2);
        for (InvoiceItemModelDao cur : items) {
            if (cur.getId().equals(charge.getId())) {
                Assert.assertEquals((Object)cur.getType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
                Assert.assertEquals((String)cur.getDescription(), (String)description);
                continue;
            }
            Assert.assertEquals((Object)cur.getType(), (Object)InvoiceItemType.CBA_ADJ);
            Assert.assertTrue((cur.getAmount().compareTo(new BigDecimal("-15.00")) == 0 ? 1 : 0) != 0);
        }
    }

    @Test(groups={"slow"})
    public void testAccountBalanceWithAllSortsOfThings() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal amount1 = new BigDecimal("5.0");
        BigDecimal rate1 = new BigDecimal("20.0");
        BigDecimal rate2 = new BigDecimal("10.0");
        FixedPriceInvoiceItem item1 = new FixedPriceInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, amount1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        BigDecimal balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("5.00")), (int)0);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("25.00")), (int)0);
        BigDecimal payment1 = amount1.add(rate1);
        DefaultInvoicePayment payment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice1.getId(), new DateTime(), payment1, Currency.USD, Currency.USD, null, Boolean.valueOf(true));
        this.invoiceUtil.createPayment((InvoicePayment)payment, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("0.00")), (int)0);
        RepairAdjInvoiceItem item2Repair = new RepairAdjInvoiceItem(invoice1.getId(), accountId, startDate, endDate, rate1.negate(), Currency.USD, item2.getId());
        RecurringInvoiceItem item2Replace = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2Repair, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2Replace, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("-10.00")), (int)0);
        CreditBalanceAdjInvoiceItem cbaItem = new CreditBalanceAdjInvoiceItem(invoice1.getId(), accountId, new LocalDate(), balance.negate(), Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)cbaItem, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("-10.00")), (int)0);
        BigDecimal cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)cba.compareTo(new BigDecimal("10.00")), (int)0);
        DefaultInvoicePayment refund = new DefaultInvoicePayment(UUID.randomUUID(), InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice1.getId(), new DateTime(), rate2.negate(), Currency.USD, Currency.USD, null, payment.getId());
        this.invoiceUtil.createPayment((InvoicePayment)refund, this.context);
        CreditBalanceAdjInvoiceItem cbaItem2 = new CreditBalanceAdjInvoiceItem(invoice1.getId(), accountId, new LocalDate(), rate2.negate(), Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)cbaItem2, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(BigDecimal.ZERO), (int)0);
        cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)cba.compareTo(BigDecimal.ZERO), (int)0);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1.plusMonths(1), Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        RecurringInvoiceItem nextItem = new RecurringInvoiceItem(invoice2.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test bla", startDate.plusMonths(1), endDate.plusMonths(1), rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)nextItem, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("10.00")), (int)0);
        cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)cba.compareTo(new BigDecimal("0.00")), (int)0);
        CreditAdjInvoiceItem creditItem = new CreditAdjInvoiceItem(invoice2.getId(), accountId, new LocalDate(), null, rate2.negate(), Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditItem, this.context);
        balance = this.invoiceDao.getAccountBalance(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)balance.compareTo(new BigDecimal("0.00")), (int)0);
        cba = this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)cba.compareTo(new BigDecimal("0.00")), (int)0);
    }

    @Test(groups={"slow"})
    public void testAccountCredit() throws InvoiceApiException {
        UUID accountId = this.account.getId();
        LocalDate effectiveDate = new LocalDate(2011, 3, 1);
        BigDecimal creditAmount = new BigDecimal("5.0");
        this.createCredit(accountId, effectiveDate, creditAmount, true);
        List invoices = this.invoiceDao.getAllInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        InvoiceModelDao invoice = (InvoiceModelDao)invoices.get(0);
        Assert.assertTrue((InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        List invoiceItems = invoice.getInvoiceItems();
        Assert.assertEquals((int)invoiceItems.size(), (int)2);
        boolean foundCredit = false;
        boolean foundCBA = false;
        for (InvoiceItemModelDao cur : invoiceItems) {
            if (cur.getType() == InvoiceItemType.CREDIT_ADJ) {
                foundCredit = true;
                Assert.assertTrue((cur.getAmount().compareTo(creditAmount.negate()) == 0 ? 1 : 0) != 0);
                continue;
            }
            if (cur.getType() != InvoiceItemType.CBA_ADJ) continue;
            foundCBA = true;
            Assert.assertTrue((cur.getAmount().compareTo(creditAmount) == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)foundCredit);
        Assert.assertTrue((boolean)foundCBA);
        Assert.assertEquals((int)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).compareTo(BigDecimal.ZERO), (int)0);
        this.invoiceDao.changeInvoiceStatus(invoice.getId(), InvoiceStatus.COMMITTED, this.context);
        Assert.assertEquals((int)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).compareTo(creditAmount), (int)0);
    }

    @Test(groups={"slow"})
    public void testInvoiceCreditWithBalancePositive() throws EntityPersistenceException {
        BigDecimal creditAmount = new BigDecimal("2.0");
        BigDecimal expectedBalance = new BigDecimal("3.0");
        boolean expectCBA = false;
        this.testInvoiceCreditInternal(creditAmount, expectedBalance, false);
    }

    @Test(groups={"slow"})
    public void testInvoiceCreditWithBalanceNegative() throws EntityPersistenceException {
        BigDecimal creditAmount = new BigDecimal("7.0");
        BigDecimal expectedBalance = new BigDecimal("0.0");
        boolean expectCBA = true;
        this.testInvoiceCreditInternal(creditAmount, expectedBalance, true);
    }

    @Test(groups={"slow"})
    public void testInvoiceCreditWithBalanceZero() throws EntityPersistenceException {
        BigDecimal creditAmount = new BigDecimal("5.0");
        BigDecimal expectedBalance = new BigDecimal("0.0");
        boolean expectCBA = false;
        this.testInvoiceCreditInternal(creditAmount, expectedBalance, false);
    }

    private void testInvoiceCreditInternal(BigDecimal creditAmount, BigDecimal expectedBalance, boolean expectCBA) throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate = new LocalDate(2011, 2, 15);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        BigDecimal amount1 = new BigDecimal("5.0");
        FixedPriceInvoiceItem item1 = new FixedPriceInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, amount1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        LocalDate effectiveDate = new LocalDate(2011, 3, 1);
        this.createCredit(accountId, invoice1.getId(), effectiveDate, creditAmount, false);
        List invoices = this.invoiceDao.getAllInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        InvoiceModelDao invoice = (InvoiceModelDao)invoices.get(0);
        Assert.assertTrue((InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice).compareTo(expectedBalance) == 0 ? 1 : 0) != 0);
        List invoiceItems = invoice.getInvoiceItems();
        Assert.assertEquals((int)invoiceItems.size(), (int)(expectCBA ? 3 : 2));
        boolean foundCredit = false;
        boolean foundCBA = false;
        for (InvoiceItemModelDao cur : invoiceItems) {
            if (cur.getType() == InvoiceItemType.CREDIT_ADJ) {
                foundCredit = true;
                Assert.assertTrue((cur.getAmount().compareTo(creditAmount.negate()) == 0 ? 1 : 0) != 0);
                continue;
            }
            if (cur.getType() != InvoiceItemType.CBA_ADJ) continue;
            foundCBA = true;
        }
        Assert.assertEquals((boolean)foundCBA, (boolean)expectCBA);
        Assert.assertTrue((boolean)foundCredit);
    }

    @Test(groups={"slow"})
    public void testGetUnpaidInvoicesByAccountId() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("17.0");
        BigDecimal rate2 = new BigDecimal("42.0");
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        LocalDate upToDate = new LocalDate(2011, 1, 1);
        List invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        upToDate = new LocalDate(2012, 1, 1);
        invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        LocalDate targetDate2 = new LocalDate(2011, 7, 1);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate2, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        LocalDate startDate2 = new LocalDate(2011, 6, 1);
        LocalDate endDate2 = startDate2.plusMonths(3);
        BigDecimal rate3 = new BigDecimal("21.0");
        RecurringInvoiceItem item3 = new RecurringInvoiceItem(invoice2.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase C", startDate2, endDate2, rate3, rate3, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item3, this.context);
        upToDate = new LocalDate(2011, 1, 1);
        invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        upToDate = new LocalDate(2012, 1, 1);
        invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)2);
    }

    @Test(groups={"slow"})
    public void testGetUnpaidInvoicesByAccountIdWithDraftInvoice() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate1 = new LocalDate(2011, 10, 6);
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate1, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        LocalDate startDate = new LocalDate(2011, 3, 1);
        LocalDate endDate = startDate.plusMonths(1);
        BigDecimal rate1 = new BigDecimal("17.0");
        BigDecimal rate2 = new BigDecimal("42.0");
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase A", startDate, endDate, rate1, rate1, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        RecurringInvoiceItem item2 = new RecurringInvoiceItem(invoice1.getId(), accountId, bundleId, UUID.randomUUID(), "test plan", "test phase B", startDate, endDate, rate2, rate2, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item2, this.context);
        LocalDate upToDate = new LocalDate(2011, 1, 1);
        List invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        upToDate = new LocalDate(2012, 1, 1);
        invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        List allInvoicesByAccount = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 1, 1), (InternalTenantContext)this.context);
        Assert.assertEquals((int)allInvoicesByAccount.size(), (int)1);
        this.createCredit(accountId, new LocalDate(2011, 12, 31), BigDecimal.TEN, true);
        allInvoicesByAccount = this.invoiceDao.getInvoicesByAccount(new LocalDate(2011, 1, 1), (InternalTenantContext)this.context);
        Assert.assertEquals((int)allInvoicesByAccount.size(), (int)2);
        Assert.assertEquals((Object)((InvoiceModelDao)allInvoicesByAccount.get(0)).getStatus(), (Object)InvoiceStatus.COMMITTED);
        Assert.assertEquals((Object)((InvoiceModelDao)allInvoicesByAccount.get(1)).getStatus(), (Object)InvoiceStatus.DRAFT);
        upToDate = new LocalDate(2012, 1, 1);
        invoices = this.invoiceDao.getUnpaidInvoicesByAccountId(accountId, upToDate, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testInvoiceGenerationForImmediateChanges() throws InvoiceApiException, CatalogApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        LocalDate targetDate = new LocalDate(2011, 2, 16);
        Currency currency = Currency.USD;
        DefaultPrice price1 = new DefaultPrice(TestInvoiceHelper.TEN, Currency.USD);
        MockInternationalPrice recurringPrice = new MockInternationalPrice(new DefaultPrice[]{price1});
        MockPlanPhase phase1 = new MockPlanPhase(recurringPrice, null, BillingPeriod.MONTHLY, PhaseType.TRIAL);
        MockPlan plan1 = new MockPlan(phase1);
        SubscriptionBase subscription = this.getZombieSubscription();
        DateTime effectiveDate1 = new DateTime(2011, 2, 1, 0, 0, 0);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate1, (Plan)plan1, (PlanPhase)phase1, null, recurringPrice.getPrice(currency), currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "testEvent1", 1L, SubscriptionBaseTransitionType.CREATE);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(event1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, targetDate, Currency.USD, this.context);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertEquals((Object)invoice1.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.TEN, (Currency)invoice1.getCurrency()));
        invoiceList.add(invoice1);
        DefaultPrice price2 = new DefaultPrice(TestInvoiceHelper.TWENTY, Currency.USD);
        MockInternationalPrice recurringPrice2 = new MockInternationalPrice(new DefaultPrice[]{price2});
        MockPlanPhase phase2 = new MockPlanPhase(recurringPrice, null, BillingPeriod.MONTHLY, PhaseType.TRIAL);
        MockPlan plan2 = new MockPlan(phase2);
        DateTime effectiveDate2 = new DateTime(2011, 2, 15, 0, 0, 0);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate2, (Plan)plan2, (PlanPhase)phase2, null, recurringPrice2.getPrice(currency), currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "testEvent2", 2L, SubscriptionBaseTransitionType.CREATE);
        events.add(event2);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, targetDate, Currency.USD, this.context);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertEquals((Object)invoice2.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.FIVE, (Currency)invoice2.getCurrency()));
        invoiceList.add(invoice2);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        InvoiceModelDao savedInvoice1 = (InvoiceModelDao)this.invoiceDao.getById(invoice1.getId(), (InternalTenantContext)this.context);
        Assert.assertEquals((Object)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)savedInvoice1), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.TEN, (Currency)savedInvoice1.getCurrency()));
        InvoiceModelDao savedInvoice2 = (InvoiceModelDao)this.invoiceDao.getById(invoice2.getId(), (InternalTenantContext)this.context);
        Assert.assertEquals((Object)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)savedInvoice2), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.FIVE, (Currency)savedInvoice2.getCurrency()));
    }

    @Test(groups={"slow"})
    public void testInvoiceForFreeTrial() throws InvoiceApiException, CatalogApiException {
        Currency currency = Currency.USD;
        DefaultPrice price = new DefaultPrice(BigDecimal.ZERO, Currency.USD);
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{price});
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice);
        MockPlan plan = new MockPlan(phase);
        SubscriptionBase subscription = this.getZombieSubscription();
        DateTime effectiveDate = this.invoiceUtil.buildDate(2011, 1, 1).toDateTimeAtStartOfDay();
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate, (Plan)plan, (PlanPhase)phase, fixedPrice.getPrice(currency), null, currency, BillingPeriod.MONTHLY, 15, BillingMode.IN_ADVANCE, "testEvent", 1L, SubscriptionBaseTransitionType.CREATE);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 15);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, this.context);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
    }

    private SubscriptionBase getZombieSubscription(UUID subscriptionId) {
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)subscription.getBundleId()).thenReturn((Object)UUID.randomUUID());
        return subscription;
    }

    private SubscriptionBase getZombieSubscription() {
        return this.getZombieSubscription(UUID.randomUUID());
    }

    @Test(groups={"slow"})
    public void testInvoiceForFreeTrialWithRecurringDiscount() throws InvoiceApiException, CatalogApiException {
        Currency currency = Currency.USD;
        DefaultPrice zeroPrice = new DefaultPrice(BigDecimal.ZERO, Currency.USD);
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{zeroPrice});
        MockPlanPhase phase1 = new MockPlanPhase(null, fixedPrice);
        BigDecimal cheapAmount = new BigDecimal("24.95");
        DefaultPrice cheapPrice = new DefaultPrice(cheapAmount, Currency.USD);
        MockInternationalPrice recurringPrice = new MockInternationalPrice(new DefaultPrice[]{cheapPrice});
        MockPlanPhase phase2 = new MockPlanPhase(recurringPrice, null);
        MockPlan plan = new MockPlan();
        SubscriptionBase subscription = this.getZombieSubscription();
        DateTime effectiveDate1 = this.invoiceUtil.buildDate(2011, 1, 1).toDateTimeAtStartOfDay();
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate1, (Plan)plan, (PlanPhase)phase1, fixedPrice.getPrice(currency), null, currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "testEvent1", 1L, SubscriptionBaseTransitionType.CREATE);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(event1);
        UUID accountId = this.account.getId();
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, new LocalDate((Object)effectiveDate1), Currency.USD, this.context);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(TestInvoiceHelper.ZERO), (int)0);
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        invoiceList.add(invoice1);
        DateTime effectiveDate2 = effectiveDate1.plusDays(30);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate2, (Plan)plan, (PlanPhase)phase2, null, recurringPrice.getPrice(currency), currency, BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "testEvent2", 2L, SubscriptionBaseTransitionType.PHASE);
        events.add(event2);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, new LocalDate((Object)effectiveDate2), Currency.USD, this.context);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)1);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(cheapAmount), (int)0);
        invoiceList.add(invoice2);
        DateTime effectiveDate3 = effectiveDate2.plusMonths(1);
        InvoiceWithMetadata invoiceWithMetadata3 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, new LocalDate((Object)effectiveDate3), Currency.USD, this.context);
        DefaultInvoice invoice3 = invoiceWithMetadata3.getInvoice();
        Assert.assertNotNull((Object)invoice3);
        Assert.assertEquals((int)invoice3.getNumberOfItems(), (int)1);
        Assert.assertEquals((int)invoice3.getBalance().compareTo(cheapAmount), (int)0);
    }

    @Test(groups={"slow"})
    public void testInvoiceForEmptyEventSet() throws InvoiceApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, new LocalDate(), Currency.USD, this.context);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNull((Object)invoice);
    }

    @Test(groups={"slow"})
    public void testMixedModeInvoicePersistence() throws InvoiceApiException, CatalogApiException, EntityPersistenceException {
        Currency currency = Currency.USD;
        DefaultPrice zeroPrice = new DefaultPrice(BigDecimal.ZERO, Currency.USD);
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{zeroPrice});
        MockPlanPhase phase1 = new MockPlanPhase(null, fixedPrice);
        BigDecimal cheapAmount = new BigDecimal("24.95");
        DefaultPrice cheapPrice = new DefaultPrice(cheapAmount, Currency.USD);
        MockInternationalPrice recurringPrice = new MockInternationalPrice(new DefaultPrice[]{cheapPrice});
        MockPlanPhase phase2 = new MockPlanPhase(recurringPrice, null);
        MockPlan plan = new MockPlan();
        SubscriptionBase subscription = this.getZombieSubscription();
        DateTime effectiveDate1 = this.invoiceUtil.buildDate(2011, 1, 1).toDateTimeAtStartOfDay();
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate1, (Plan)plan, (PlanPhase)phase1, fixedPrice.getPrice(currency), null, currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "testEvent1", 1L, SubscriptionBaseTransitionType.CREATE);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(event1);
        DateTime effectiveDate2 = effectiveDate1.plusDays(30);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(null, subscription, effectiveDate2, (Plan)plan, (PlanPhase)phase2, null, recurringPrice.getPrice(currency), currency, BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "testEvent2", 2L, SubscriptionBaseTransitionType.CHANGE);
        events.add(event2);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, new LocalDate((Object)effectiveDate2), Currency.USD, this.context);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        Assert.assertEquals((int)invoice.getBalance().compareTo(cheapAmount), (int)0);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        InvoiceModelDao savedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        Assert.assertNotNull((Object)savedInvoice);
        Assert.assertEquals((int)savedInvoice.getInvoiceItems().size(), (int)2);
        Assert.assertEquals((int)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)savedInvoice).compareTo(cheapAmount), (int)0);
    }

    @Test(groups={"slow"})
    public void testRefundedInvoiceWithInvoiceItemAdjustmentWithRepair() throws InvoiceApiException, EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2010, 1, 1);
        this.clock.setDay(startDate);
        LocalDate recuringStartDate = this.clock.getUTCNow().plusDays(30).toLocalDate();
        LocalDate recuringEndDate = recuringStartDate.plusMonths(1);
        LocalDate targetDate = recuringStartDate.plusDays(1);
        DefaultInvoice invoice = new DefaultInvoice(accountId, targetDate, targetDate, Currency.USD);
        UUID invoiceId = invoice.getId();
        RecurringInvoiceItem invoiceItem = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test-plan", "test-phase-rec", recuringStartDate, recuringEndDate, new BigDecimal("239.00"), new BigDecimal("239.00"), Currency.USD);
        invoice.addInvoiceItem((InvoiceItem)invoiceItem);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        this.clock.addDays(1);
        BigDecimal paymentAmount = new BigDecimal("239.00");
        UUID paymentId = UUID.randomUUID();
        DefaultInvoicePayment defaultInvoicePayment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoiceId, this.clock.getUTCNow(), paymentAmount, Currency.USD, Currency.USD, "cookie", Boolean.valueOf(true));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment), this.context);
        HashMap<UUID, BigDecimal> invoiceItemMap = new HashMap<UUID, BigDecimal>();
        invoiceItemMap.put(invoiceItem.getId(), new BigDecimal("239.00"));
        this.invoiceDao.createRefund(paymentId, paymentAmount, true, invoiceItemMap, UUID.randomUUID().toString(), this.context);
        InvoiceModelDao savedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoiceId, (InternalTenantContext)this.context);
        Assert.assertNotNull((Object)savedInvoice);
        Assert.assertEquals((int)savedInvoice.getInvoiceItems().size(), (int)2);
        ArrayList<DefaultInvoice> invoices = new ArrayList<DefaultInvoice>();
        invoices.add(new DefaultInvoice(savedInvoice));
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase subscription = this.getZombieSubscription(subscriptionId);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)"plan");
        PlanPhase phase1 = (PlanPhase)Mockito.mock(PlanPhase.class);
        Mockito.when((Object)phase1.getName()).thenReturn((Object)"plan-phase1");
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, recuringStartDate.toDateTimeAtStartOfDay(), plan, phase1, null, TestInvoiceHelper.TEN, Currency.USD, BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "new-event", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        InvoiceWithMetadata newInvoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoices, targetDate, Currency.USD, this.context);
        DefaultInvoice newInvoice = newInvoiceWithMetadata.getInvoice();
        this.invoiceUtil.createInvoice((Invoice)newInvoice, this.context);
        DefaultInvoice firstInvoice = new DefaultInvoice((InvoiceModelDao)this.invoiceDao.getById(invoiceId, (InternalTenantContext)this.context));
        Assert.assertNotNull((Object)firstInvoice);
        Assert.assertEquals((int)firstInvoice.getInvoiceItems().size(), (int)2);
    }

    @Test(groups={"slow"})
    public void testInvoiceNumber() throws InvoiceApiException, EntityPersistenceException {
        Currency currency = Currency.USD;
        DateTime targetDate1 = this.clock.getUTCNow().plusMonths(1);
        DateTime targetDate2 = this.clock.getUTCNow().plusMonths(2);
        SubscriptionBase subscription = this.getZombieSubscription();
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)"plan");
        PlanPhase phase1 = (PlanPhase)Mockito.mock(PlanPhase.class);
        Mockito.when((Object)phase1.getName()).thenReturn((Object)"plan-phase1");
        PlanPhase phase2 = (PlanPhase)Mockito.mock(PlanPhase.class);
        Mockito.when((Object)phase2.getName()).thenReturn((Object)"plan-phase2");
        MockBillingEventSet events = new MockBillingEventSet();
        ArrayList<DefaultInvoice> invoices = new ArrayList<DefaultInvoice>();
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, targetDate1, plan, phase1, null, TestInvoiceHelper.TEN, currency, BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "testEvent1", 1L, SubscriptionBaseTransitionType.CHANGE);
        events.add(event1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoices, new LocalDate((Object)targetDate1), Currency.USD, this.context);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        invoices.add(invoice1);
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        invoice1 = new DefaultInvoice((InvoiceModelDao)this.invoiceDao.getById(invoice1.getId(), (InternalTenantContext)this.context));
        Assert.assertNotNull((Object)invoice1.getInvoiceNumber());
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(null, subscription, targetDate1, plan, phase2, null, TestInvoiceHelper.TWENTY, currency, BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "testEvent2", 2L, SubscriptionBaseTransitionType.CHANGE);
        events.add(event2);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoices, new LocalDate((Object)targetDate2), Currency.USD, this.context);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        invoice2 = new DefaultInvoice((InvoiceModelDao)this.invoiceDao.getById(invoice2.getId(), (InternalTenantContext)this.context));
        Assert.assertNotNull((Object)invoice2.getInvoiceNumber());
    }

    @Test(groups={"slow"})
    public void testDeleteCBANotConsumed() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem1 = new FixedPriceInvoiceItem(invoice1.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), BigDecimal.TEN, Currency.USD);
        RepairAdjInvoiceItem repairAdjInvoiceItem = new RepairAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getEndDate(), fixedItem1.getAmount().negate(), fixedItem1.getCurrency(), fixedItem1.getId());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem1 = new CreditBalanceAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getAmount(), fixedItem1.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)repairAdjInvoiceItem, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem1, this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)10.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 10.0, 10.0, (InternalTenantContext)this.context);
        this.invoiceDao.deleteCBA(accountId, invoice1.getId(), creditBalanceAdjInvoiceItem1.getId(), this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)0.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 0.0, 0.0, (InternalTenantContext)this.context);
    }

    @Test(groups={"slow"})
    public void testRefundWithCBAPartiallyConsumed() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem1 = new FixedPriceInvoiceItem(invoice1.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), BigDecimal.TEN, Currency.USD);
        RepairAdjInvoiceItem repairAdjInvoiceItem = new RepairAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getEndDate(), fixedItem1.getAmount().negate(), fixedItem1.getCurrency(), fixedItem1.getId());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem1 = new CreditBalanceAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getAmount(), fixedItem1.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)repairAdjInvoiceItem, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem1, this.context);
        UUID paymentId = UUID.randomUUID();
        DefaultInvoicePayment defaultInvoicePayment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice1.getId(), this.clock.getUTCNow().plusDays(12), new BigDecimal("10.0"), Currency.USD, Currency.USD, "cookie", Boolean.valueOf(true));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment), this.context);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem2 = new FixedPriceInvoiceItem(invoice2.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), new BigDecimal("5"), Currency.USD);
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem2 = new CreditBalanceAdjInvoiceItem(fixedItem2.getInvoiceId(), fixedItem2.getAccountId(), fixedItem2.getStartDate(), fixedItem2.getAmount().negate(), fixedItem2.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem2, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem2, this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)5.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 0.0, 10.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice2.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
        this.invoiceDao.createRefund(paymentId, new BigDecimal("10.0"), false, (Map)ImmutableMap.of(), UUID.randomUUID().toString(), this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)0.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 5.0, 5.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice2.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
    }

    @Test(groups={"slow"})
    public void testRefundCBAFullyConsumedTwice() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem1 = new FixedPriceInvoiceItem(invoice1.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), BigDecimal.TEN, Currency.USD);
        RepairAdjInvoiceItem repairAdjInvoiceItem = new RepairAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getEndDate(), fixedItem1.getAmount().negate(), fixedItem1.getCurrency(), fixedItem1.getId());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem1 = new CreditBalanceAdjInvoiceItem(fixedItem1.getInvoiceId(), fixedItem1.getAccountId(), fixedItem1.getStartDate(), fixedItem1.getAmount(), fixedItem1.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)repairAdjInvoiceItem, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem1, this.context);
        BigDecimal paymentAmount = new BigDecimal("10.00");
        UUID paymentId = UUID.randomUUID();
        DefaultInvoicePayment defaultInvoicePayment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice1.getId(), this.clock.getUTCNow().plusDays(12), paymentAmount, Currency.USD, Currency.USD, "cookie", Boolean.valueOf(true));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment), this.context);
        DefaultInvoice invoice2 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem2 = new FixedPriceInvoiceItem(invoice2.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), new BigDecimal("5"), Currency.USD);
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem2 = new CreditBalanceAdjInvoiceItem(fixedItem2.getInvoiceId(), fixedItem2.getAccountId(), fixedItem2.getStartDate(), fixedItem2.getAmount().negate(), fixedItem2.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice2, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem2, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem2, this.context);
        DefaultInvoice invoice3 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        FixedPriceInvoiceItem fixedItem3 = new FixedPriceInvoiceItem(invoice3.getId(), invoice1.getAccountId(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), this.clock.getUTCToday(), new BigDecimal("5"), Currency.USD);
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem3 = new CreditBalanceAdjInvoiceItem(fixedItem3.getInvoiceId(), fixedItem3.getAccountId(), fixedItem3.getStartDate(), fixedItem3.getAmount().negate(), fixedItem3.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice3, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedItem3, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem3, this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)0.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 0.0, 10.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice2.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice3.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
        this.invoiceDao.createRefund(paymentId, paymentAmount, false, (Map)ImmutableMap.of(), UUID.randomUUID().toString(), this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)0.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 10.0, 10.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice2.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
        this.invoiceUtil.verifyInvoice(invoice3.getId(), 0.0, -5.0, (InternalTenantContext)this.context);
    }

    @Test(groups={"slow"})
    public void testCantDeleteCBAIfInvoiceBalanceBecomesNegative() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice1 = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        RepairAdjInvoiceItem repairAdjInvoiceItem = new RepairAdjInvoiceItem(invoice1.getId(), invoice1.getAccountId(), invoice1.getInvoiceDate(), invoice1.getInvoiceDate(), BigDecimal.TEN.negate(), invoice1.getCurrency(), UUID.randomUUID());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem1 = new CreditBalanceAdjInvoiceItem(invoice1.getId(), invoice1.getAccountId(), invoice1.getInvoiceDate(), repairAdjInvoiceItem.getAmount().negate(), invoice1.getCurrency());
        this.invoiceUtil.createInvoice((Invoice)invoice1, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)repairAdjInvoiceItem, this.context);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem1, this.context);
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)10.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 0.0, 10.0, (InternalTenantContext)this.context);
        try {
            this.invoiceDao.deleteCBA(accountId, invoice1.getId(), creditBalanceAdjInvoiceItem1.getId(), this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.INVOICE_WOULD_BE_NEGATIVE.getCode());
        }
        Assert.assertEquals((Object)this.invoiceDao.getAccountCBA(accountId, (InternalTenantContext)this.context).doubleValue(), (Object)10.0);
        this.invoiceUtil.verifyInvoice(invoice1.getId(), 0.0, 10.0, (InternalTenantContext)this.context);
    }

    @Test(groups={"slow"})
    public void testWithFailedPaymentAttempt() throws Exception {
        UUID accountId = this.account.getId();
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId = UUID.randomUUID();
        RecurringInvoiceItem item1 = new RecurringInvoiceItem(invoice.getId(), accountId, bundleId, subscriptionId, "test plan", "test ZOO", this.clock.getUTCNow().plusMonths(-1).toLocalDate(), this.clock.getUTCNow().toLocalDate(), BigDecimal.TEN, BigDecimal.TEN, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item1, this.context);
        InvoiceModelDao retrievedInvoice = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        Assert.assertEquals((int)retrievedInvoice.getInvoicePayments().size(), (int)0);
        UUID paymentId = UUID.randomUUID();
        DefaultInvoicePayment defaultInvoicePayment = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice.getId(), this.clock.getUTCNow().plusDays(12), BigDecimal.TEN, Currency.USD, Currency.USD, "cookie", Boolean.valueOf(false));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment), this.context);
        InvoiceModelDao retrievedInvoice1 = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        Assert.assertEquals((int)retrievedInvoice1.getInvoicePayments().size(), (int)1);
        Assert.assertEquals((Object)((InvoicePaymentModelDao)retrievedInvoice1.getInvoicePayments().get(0)).getSuccess(), (Object)Boolean.FALSE);
        DefaultInvoicePayment defaultInvoicePayment2 = new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, paymentId, invoice.getId(), this.clock.getUTCNow().plusDays(12), BigDecimal.TEN, Currency.USD, Currency.USD, "cookie", Boolean.valueOf(true));
        this.invoiceDao.notifyOfPaymentCompletion(new InvoicePaymentModelDao((InvoicePayment)defaultInvoicePayment2), this.context);
        InvoiceModelDao retrievedInvoice2 = (InvoiceModelDao)this.invoiceDao.getById(invoice.getId(), (InternalTenantContext)this.context);
        Assert.assertEquals((int)retrievedInvoice2.getInvoicePayments().size(), (int)1);
        Assert.assertEquals((Object)((InvoicePaymentModelDao)retrievedInvoice2.getInvoicePayments().get(0)).getSuccess(), (Object)Boolean.TRUE);
    }

    private InvoiceItemModelDao createCredit(UUID accountId, LocalDate effectiveDate, BigDecimal creditAmount, boolean draft) {
        return this.createCredit(accountId, null, effectiveDate, creditAmount, draft);
    }

    private InvoiceItemModelDao createCredit(UUID accountId, @Nullable UUID invoiceId, LocalDate effectiveDate, BigDecimal creditAmount, boolean draft) {
        InvoiceModelDao invoiceModelDao = invoiceId == null ? new InvoiceModelDao(accountId, effectiveDate, effectiveDate, Currency.USD, false, draft ? InvoiceStatus.DRAFT : InvoiceStatus.COMMITTED) : (InvoiceModelDao)this.invoiceDao.getById(invoiceId, (InternalTenantContext)this.context);
        CreditAdjInvoiceItem invoiceItem = new CreditAdjInvoiceItem(UUID.randomUUID(), this.context.getCreatedDate(), invoiceModelDao.getId(), accountId, effectiveDate, null, creditAmount.negate(), invoiceModelDao.getCurrency());
        invoiceModelDao.addInvoiceItem(new InvoiceItemModelDao((InvoiceItem)invoiceItem));
        return (InvoiceItemModelDao)this.invoiceDao.createInvoices((List)ImmutableList.of((Object)invoiceModelDao), this.context).get(0);
    }

    @Test(groups={"slow"})
    public void testCreateParentChildInvoiceRelation() throws InvoiceApiException {
        UUID parentInvoiceId = UUID.randomUUID();
        UUID childInvoiceId = UUID.randomUUID();
        UUID childAccountId = UUID.randomUUID();
        InvoiceParentChildModelDao invoiceRelation = new InvoiceParentChildModelDao(parentInvoiceId, childInvoiceId, childAccountId);
        this.invoiceDao.createParentChildInvoiceRelation(invoiceRelation, this.context);
        List relations = this.invoiceDao.getChildInvoicesByParentInvoiceId(parentInvoiceId, this.context);
        Assert.assertEquals((int)relations.size(), (int)1);
        InvoiceParentChildModelDao parentChildRelation = (InvoiceParentChildModelDao)relations.get(0);
        Assert.assertEquals((Object)parentChildRelation.getChildAccountId(), (Object)childAccountId);
        Assert.assertEquals((Object)parentChildRelation.getChildInvoiceId(), (Object)childInvoiceId);
        Assert.assertEquals((Object)parentChildRelation.getParentInvoiceId(), (Object)parentInvoiceId);
    }

    @Test(groups={"slow"})
    public void testCreateParentInvoice() throws InvoiceApiException {
        UUID parentAccountId = UUID.randomUUID();
        UUID childAccountId = UUID.randomUUID();
        DateTime today = this.clock.getNow(this.account.getTimeZone());
        InvoiceModelDao parentInvoice = new InvoiceModelDao(parentAccountId, today.toLocalDate(), this.account.getCurrency(), InvoiceStatus.DRAFT, true);
        ParentInvoiceItem parentInvoiceItem = new ParentInvoiceItem(UUID.randomUUID(), today, parentInvoice.getId(), parentAccountId, childAccountId, BigDecimal.TEN, this.account.getCurrency(), "");
        parentInvoice.addInvoiceItem(new InvoiceItemModelDao((InvoiceItem)parentInvoiceItem));
        this.invoiceDao.createInvoices((List)ImmutableList.of((Object)parentInvoice), this.context);
        InvoiceModelDao parentDraftInvoice = this.invoiceDao.getParentDraftInvoice(parentAccountId, this.context);
        Assert.assertNotNull((Object)parentDraftInvoice);
        Assert.assertEquals((Object)parentDraftInvoice.getStatus(), (Object)InvoiceStatus.DRAFT);
        Assert.assertEquals((int)parentDraftInvoice.getInvoiceItems().size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testRetrieveInvoiceItemsByParentInvoice() throws InvoiceApiException, EntityPersistenceException {
        UUID childAccountId = this.account.getId();
        DefaultInvoice childInvoice = new DefaultInvoice(childAccountId, this.clock.getUTCToday(), this.clock.getUTCToday(), Currency.USD);
        UUID invoiceId = childInvoice.getId();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2010, 1, 1);
        LocalDate endDate = new LocalDate(2010, 4, 1);
        RecurringInvoiceItem invoiceItem = new RecurringInvoiceItem(invoiceId, childAccountId, bundleId, subscriptionId, "test plan", "test phase", startDate, endDate, new BigDecimal("21.00"), new BigDecimal("7.00"), Currency.USD);
        ItemAdjInvoiceItem invoiceAdj = new ItemAdjInvoiceItem((InvoiceItem)invoiceItem, startDate, new BigDecimal("-5.00"), Currency.USD);
        childInvoice.addInvoiceItem((InvoiceItem)invoiceItem);
        childInvoice.addInvoiceItem((InvoiceItem)invoiceAdj);
        this.invoiceUtil.createInvoice((Invoice)childInvoice, this.context);
        UUID parentInvoiceId = UUID.randomUUID();
        InvoiceParentChildModelDao invoiceRelation = new InvoiceParentChildModelDao(parentInvoiceId, childInvoice.getId(), childAccountId);
        this.invoiceDao.createParentChildInvoiceRelation(invoiceRelation, this.context);
        List invoiceItems = this.invoiceDao.getInvoiceItemsByParentInvoice(parentInvoiceId, (InternalTenantContext)this.context);
        Assert.assertEquals((int)invoiceItems.size(), (int)2);
        Assert.assertEquals((Object)((InvoiceItemModelDao)invoiceItems.get(0)).getType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItemModelDao)invoiceItems.get(1)).getType(), (Object)InvoiceItemType.ITEM_ADJ);
    }
}

