/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.dao;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.model.CreditBalanceAdjInvoiceItem;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.ExternalChargeInvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.InvoiceItemFactory;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceItemDao
extends InvoiceTestSuiteWithEmbeddedDB {
    private Account account;
    private InternalCallContext context;

    @BeforeMethod(groups={"slow"})
    public void setUp() throws Exception {
        this.account = this.invoiceUtil.createAccount(this.callContext);
        this.context = this.internalCallContextFactory.createInternalCallContext(this.account.getId(), this.callContext);
    }

    @Test(groups={"slow"})
    public void testInvoiceItemCreation() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID invoiceId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2011, 10, 1);
        LocalDate endDate = new LocalDate(2011, 11, 1);
        BigDecimal rate = new BigDecimal("20.00");
        RecurringInvoiceItem item = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test plan", "test phase", startDate, endDate, rate, rate, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item, this.context);
        InvoiceItemModelDao thisItem = this.invoiceUtil.getInvoiceItemById(item.getId(), this.context);
        Assert.assertNotNull((Object)thisItem);
        Assert.assertEquals((Object)thisItem.getId(), (Object)item.getId());
        Assert.assertEquals((Object)thisItem.getInvoiceId(), (Object)item.getInvoiceId());
        Assert.assertEquals((Object)thisItem.getSubscriptionId(), (Object)item.getSubscriptionId());
        Assert.assertTrue((thisItem.getStartDate().compareTo((ReadablePartial)item.getStartDate()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((thisItem.getEndDate().compareTo((ReadablePartial)item.getEndDate()) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)thisItem.getAmount().compareTo(item.getRate()), (int)0);
        Assert.assertEquals((int)thisItem.getRate().compareTo(item.getRate()), (int)0);
        Assert.assertEquals((Object)thisItem.getCurrency(), (Object)item.getCurrency());
    }

    @Test(groups={"slow"})
    public void testGetInvoiceItemsBySubscriptionId() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        BigDecimal rate = new BigDecimal("20.00");
        for (int i = 0; i < 3; ++i) {
            UUID invoiceId = UUID.randomUUID();
            RecurringInvoiceItem item = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test plan", "test phase", startDate.plusMonths(i), startDate.plusMonths(i + 1), rate, rate, Currency.USD);
            this.invoiceUtil.createInvoiceItem((InvoiceItem)item, this.context);
        }
        List<InvoiceItemModelDao> items = this.invoiceUtil.getInvoiceItemBySubscriptionId(subscriptionId, this.context);
        Assert.assertEquals((int)items.size(), (int)3);
    }

    @Test(groups={"slow"})
    public void testGetInvoiceItemsByInvoiceId() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID invoiceId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        BigDecimal rate = new BigDecimal("20.00");
        for (int i = 0; i < 5; ++i) {
            UUID subscriptionId = UUID.randomUUID();
            BigDecimal amount = rate.multiply(new BigDecimal(i + 1));
            RecurringInvoiceItem item = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test plan", "test phase", startDate, startDate.plusMonths(1), amount, amount, Currency.USD);
            this.invoiceUtil.createInvoiceItem((InvoiceItem)item, this.context);
        }
        List<InvoiceItemModelDao> items = this.invoiceUtil.getInvoiceItemByInvoiceId(invoiceId, this.context);
        Assert.assertEquals((int)items.size(), (int)5);
    }

    @Test(groups={"slow"})
    public void testGetInvoiceItemsByAccountId() throws EntityPersistenceException {
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        LocalDate targetDate = new LocalDate(2011, 5, 23);
        DefaultInvoice invoice = new DefaultInvoice(accountId, this.clock.getUTCToday(), targetDate, Currency.USD);
        this.invoiceUtil.createInvoice((Invoice)invoice, this.context);
        UUID invoiceId = invoice.getId();
        LocalDate startDate = new LocalDate(2011, 3, 1);
        BigDecimal rate = new BigDecimal("20.00");
        UUID subscriptionId = UUID.randomUUID();
        RecurringInvoiceItem item = new RecurringInvoiceItem(invoiceId, accountId, bundleId, subscriptionId, "test plan", "test phase", startDate, startDate.plusMonths(1), rate, rate, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)item, this.context);
        List<InvoiceItemModelDao> items = this.invoiceUtil.getInvoiceItemByAccountId(this.context);
        Assert.assertEquals((int)items.size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testCreditBalanceInvoiceSqlDao() throws EntityPersistenceException {
        UUID invoiceId = UUID.randomUUID();
        UUID accountId = this.account.getId();
        LocalDate creditDate = new LocalDate(2012, 4, 1);
        CreditBalanceAdjInvoiceItem creditInvoiceItem = new CreditBalanceAdjInvoiceItem(invoiceId, accountId, creditDate, TestInvoiceHelper.TEN, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)creditInvoiceItem, this.context);
        InvoiceItemModelDao savedItem = this.invoiceUtil.getInvoiceItemById(creditInvoiceItem.getId(), this.context);
        this.assertSameInvoiceItem((InvoiceItem)creditInvoiceItem, savedItem);
    }

    @Test(groups={"slow"})
    public void testFixedPriceInvoiceSqlDao() throws EntityPersistenceException {
        UUID invoiceId = UUID.randomUUID();
        UUID accountId = this.account.getId();
        LocalDate startDate = new LocalDate(2012, 4, 1);
        FixedPriceInvoiceItem fixedPriceInvoiceItem = new FixedPriceInvoiceItem(invoiceId, accountId, UUID.randomUUID(), UUID.randomUUID(), "test plan", "test phase", startDate, TestInvoiceHelper.TEN, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)fixedPriceInvoiceItem, this.context);
        InvoiceItemModelDao savedItem = this.invoiceUtil.getInvoiceItemById(fixedPriceInvoiceItem.getId(), this.context);
        this.assertSameInvoiceItem((InvoiceItem)fixedPriceInvoiceItem, savedItem);
    }

    @Test(groups={"slow"})
    public void testExternalChargeInvoiceSqlDao() throws Exception {
        UUID invoiceId = UUID.randomUUID();
        UUID accountId = this.account.getId();
        UUID bundleId = UUID.randomUUID();
        String description = UUID.randomUUID().toString();
        LocalDate startDate = new LocalDate(2012, 4, 1);
        ExternalChargeInvoiceItem externalChargeInvoiceItem = new ExternalChargeInvoiceItem(invoiceId, accountId, bundleId, description, startDate, TestInvoiceHelper.TEN, Currency.USD);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)externalChargeInvoiceItem, this.context);
        InvoiceItemModelDao savedItem = this.invoiceUtil.getInvoiceItemById(externalChargeInvoiceItem.getId(), this.context);
        this.assertSameInvoiceItem((InvoiceItem)externalChargeInvoiceItem, savedItem);
    }

    @Test(groups={"slow"})
    public void testExternalChargeForVariousCurrenciesInvoiceSqlDao() throws Exception {
        this.createAndVerifyExternalCharge(new BigDecimal("10"), Currency.VND);
        this.createAndVerifyExternalCharge(new BigDecimal("10"), Currency.USD);
        this.createAndVerifyExternalCharge(new BigDecimal("10.1"), Currency.USD);
        this.createAndVerifyExternalCharge(new BigDecimal("10.01"), Currency.USD);
        this.createAndVerifyExternalCharge(new BigDecimal("10"), Currency.BHD);
        this.createAndVerifyExternalCharge(new BigDecimal("10.1"), Currency.BHD);
        this.createAndVerifyExternalCharge(new BigDecimal("10.01"), Currency.BHD);
        this.createAndVerifyExternalCharge(new BigDecimal("10.001"), Currency.BHD);
        this.createAndVerifyExternalCharge(new BigDecimal("10"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.1"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.01"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.0001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.00001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.000001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.0000001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.00000001"), Currency.BTC);
        this.createAndVerifyExternalCharge(new BigDecimal("10.2"), Currency.MGA);
    }

    private void createAndVerifyExternalCharge(BigDecimal amount, Currency currency) throws EntityPersistenceException {
        ExternalChargeInvoiceItem externalChargeInvoiceItem = new ExternalChargeInvoiceItem(UUID.randomUUID(), this.account.getId(), UUID.randomUUID(), UUID.randomUUID().toString(), new LocalDate(2012, 4, 1), amount, currency);
        this.invoiceUtil.createInvoiceItem((InvoiceItem)externalChargeInvoiceItem, this.context);
        InvoiceItemModelDao savedItem = this.invoiceUtil.getInvoiceItemById(externalChargeInvoiceItem.getId(), this.context);
        this.assertSameInvoiceItem((InvoiceItem)externalChargeInvoiceItem, savedItem);
        Assert.assertEquals((int)externalChargeInvoiceItem.getAmount().compareTo(amount), (int)0);
    }

    private void assertSameInvoiceItem(InvoiceItem initialItem, InvoiceItemModelDao fromDao) {
        InvoiceItem newItem = InvoiceItemFactory.fromModelDao((InvoiceItemModelDao)fromDao);
        Assert.assertEquals((Object)newItem.getId(), (Object)initialItem.getId());
        Assert.assertTrue((boolean)newItem.matches((Object)initialItem));
    }
}

