/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.MockBillingEventSet;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.generator.InvoiceWithMetadata;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.DefaultInvoicePayment;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.ItemAdjInvoiceItem;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.invoice.model.RepairAdjInvoiceItem;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.util.currency.KillBillMoney;
import org.killbill.clock.DefaultClock;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultInvoiceGenerator
extends InvoiceTestSuiteNoDB {
    private Account account;
    private static final Logger log = LoggerFactory.getLogger(TestDefaultInvoiceGenerator.class);
    private Long totalOrdering = 1L;

    @Override
    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        super.beforeClass();
        DefaultClock clock = new DefaultClock();
        this.account = new MockAccountBuilder().name(UUID.randomUUID().toString().substring(1, 8)).firstNameLength(6).email(UUID.randomUUID().toString().substring(1, 8)).phone(UUID.randomUUID().toString().substring(1, 8)).migrated(false).isNotifiedForInvoices(true).externalKey(UUID.randomUUID().toString().substring(1, 8)).billingCycleDayLocal(31).currency(Currency.USD).paymentMethodId(UUID.randomUUID()).timeZone(DateTimeZone.UTC).build();
    }

    @Test(groups={"fast"})
    public void testWithNullEventSetAndNullInvoiceSet() throws InvoiceApiException {
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, null, null, this.clock.getUTCToday(), Currency.USD, (InternalCallContext)this.internalCallContext);
        Assert.assertNull((Object)invoiceWithMetadata.getInvoice());
    }

    @Test(groups={"fast"})
    public void testWithEmptyEventSet() throws InvoiceApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, this.clock.getUTCToday(), Currency.USD, (InternalCallContext)this.internalCallContext);
        Assert.assertNull((Object)invoiceWithMetadata.getInvoice());
    }

    @Test(groups={"fast"})
    public void testWithSingleMonthlyEvent() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 9, 1);
        MockPlan plan = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.TEN;
        MockPlanPhase phase = this.createMockMonthlyPlanPhase(rate1);
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 1);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 10, 3);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.TWENTY, (Currency)invoice.getCurrency()));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)sub.getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 9, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 10, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 10, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 11, 1));
    }

    @Test(groups={"fast"})
    public void testWithSingleThirtyDaysEvent() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 9, 1);
        MockPlan plan = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.TEN;
        MockPlanPhase phase = this.createMockThirtyDaysPlanPhase(rate1);
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 1);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 10, 3);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.TWENTY, (Currency)invoice.getCurrency()));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)sub.getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 9, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 10, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 10, 1));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 10, 31));
    }

    @Test(groups={"fast"})
    public void testSimpleWithTimeZone() throws InvoiceApiException, CatalogApiException {
        SubscriptionBase sub = this.createSubscription();
        MockPlan plan = new MockPlan();
        BigDecimal rate = TestInvoiceHelper.TEN;
        MockPlanPhase phase = this.createMockMonthlyPlanPhase(rate);
        int bcdLocal = 16;
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 7, 16);
        MockBillingEventSet events = new MockBillingEventSet();
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 16);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 8, 16);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)this.invoiceUtil.buildDate(2012, 7, 16));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)this.invoiceUtil.buildDate(2012, 8, 16));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)this.invoiceUtil.buildDate(2012, 8, 16));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)this.invoiceUtil.buildDate(2012, 9, 16));
    }

    @Test(groups={"fast"})
    public void testSimpleWithSingleDiscountEvent() throws Exception {
        UUID accountId = UUID.randomUUID();
        SubscriptionBase sub = this.createSubscription();
        MockPlan plan = new MockPlan("Plan with a single discount phase");
        MockPlanPhase phaseEvergreen = this.createMockMonthlyPlanPhase(TestInvoiceHelper.EIGHT, PhaseType.DISCOUNT);
        int bcdLocal = 16;
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 7, 16);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phaseEvergreen, 16));
        LocalDate targetDate = startDate;
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)this.invoiceUtil.buildDate(2012, 7, 16));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)this.invoiceUtil.buildDate(2012, 8, 16));
    }

    @Test(groups={"fast"})
    public void testWithSingleMonthlyEventWithLeadingProRation() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 9, 1);
        MockPlan plan = new MockPlan();
        BigDecimal rate = TestInvoiceHelper.TEN;
        MockPlanPhase phase = this.createMockMonthlyPlanPhase(rate);
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 15);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 10, 3);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        BigDecimal expectedNumberOfBillingCycles = TestInvoiceHelper.ONE.add(TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        BigDecimal expectedAmount = KillBillMoney.of((BigDecimal)expectedNumberOfBillingCycles.multiply(rate), (Currency)invoice.getCurrency());
        Assert.assertEquals((Object)invoice.getBalance(), (Object)expectedAmount);
    }

    @Test(groups={"fast"})
    public void testTwoMonthlySubscriptionsWithAlignedBillingDates() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan1 = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.FIVE;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(rate1);
        MockPlan plan2 = new MockPlan();
        BigDecimal rate2 = TestInvoiceHelper.TEN;
        MockPlanPhase phase2 = this.createMockMonthlyPlanPhase(rate2);
        SubscriptionBase sub = this.createSubscription();
        BillingEvent event1 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 9, 1), (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        BillingEvent event2 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 10, 1), (Plan)plan2, (PlanPhase)phase2, 1);
        events.add(event2);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 10, 3);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)2);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)rate1.add(rate2), (Currency)invoice.getCurrency()));
    }

    @Test(groups={"fast"})
    public void testOnePlan_TwoMonthlyPhases_ChangeImmediate() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan1 = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.FIVE;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(rate1);
        SubscriptionBase sub = this.createSubscription();
        BillingEvent event1 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 9, 1), (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        BigDecimal rate2 = TestInvoiceHelper.TEN;
        MockPlanPhase phase2 = this.createMockMonthlyPlanPhase(rate2);
        BillingEvent event2 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 10, 15), (Plan)plan1, (PlanPhase)phase2, 15);
        events.add(event2);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 12, 3);
        UUID accountId = UUID.randomUUID();
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)4);
        BigDecimal numberOfCyclesEvent1 = TestInvoiceHelper.ONE.add(TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        BigDecimal numberOfCyclesEvent2 = TestInvoiceHelper.TWO;
        BigDecimal expectedValue = numberOfCyclesEvent1.multiply(rate1);
        expectedValue = expectedValue.add(numberOfCyclesEvent2.multiply(rate2));
        expectedValue = KillBillMoney.of((BigDecimal)expectedValue, (Currency)invoice.getCurrency());
        Assert.assertEquals((Object)invoice.getBalance(), (Object)expectedValue);
    }

    @Test(groups={"fast"})
    public void testOnePlan_ThreeMonthlyPhases_ChangeEOT() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan1 = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.FIVE;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(rate1);
        SubscriptionBase sub = this.createSubscription();
        BillingEvent event1 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 9, 1), (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        BigDecimal rate2 = TestInvoiceHelper.TEN;
        MockPlanPhase phase2 = this.createMockMonthlyPlanPhase(rate2);
        BillingEvent event2 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 10, 1), (Plan)plan1, (PlanPhase)phase2, 1);
        events.add(event2);
        BigDecimal rate3 = TestInvoiceHelper.THIRTY;
        MockPlanPhase phase3 = this.createMockMonthlyPlanPhase(rate3);
        BillingEvent event3 = this.createBillingEvent(sub.getId(), sub.getBundleId(), this.invoiceUtil.buildDate(2011, 11, 1), (Plan)plan1, (PlanPhase)phase3, 1);
        events.add(event3);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 12, 3);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)4);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)rate1.add(rate2).add(TestInvoiceHelper.TWO.multiply(rate3)), (Currency)invoice.getCurrency()));
    }

    @Test(groups={"fast"})
    public void testSingleEventWithExistingInvoice() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 9, 1);
        MockPlan plan1 = new MockPlan();
        BigDecimal rate = TestInvoiceHelper.FIVE;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(rate);
        BillingEvent event1 = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 12, 1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        ArrayList<DefaultInvoice> existingInvoices = new ArrayList<DefaultInvoice>();
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        existingInvoices.add(invoice1);
        targetDate = this.invoiceUtil.buildDate(2011, 12, 3);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, existingInvoices, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNull((Object)invoice2);
    }

    @Test(groups={"fast"})
    public void testMultiplePlansWithUtterChaos() throws InvoiceApiException, CatalogApiException {
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        UUID subscriptionId2 = UUID.randomUUID();
        UUID subscriptionId3 = UUID.randomUUID();
        UUID subscriptionId4 = UUID.randomUUID();
        UUID subscriptionId5 = UUID.randomUUID();
        MockPlan plan1 = new MockPlan("Change from trial to discount with immediate cancellation");
        MockPlanPhase plan1Phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.EIGHT, PhaseType.TRIAL);
        MockPlanPhase plan1Phase2 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWELVE, PhaseType.DISCOUNT);
        MockPlanPhase plan1Phase3 = this.createMockMonthlyPlanPhase();
        LocalDate plan1StartDate = this.invoiceUtil.buildDate(2011, 1, 5);
        LocalDate plan1PhaseChangeDate = this.invoiceUtil.buildDate(2011, 4, 5);
        LocalDate plan1CancelDate = this.invoiceUtil.buildDate(2011, 4, 29);
        MockPlan plan2 = new MockPlan("Change phase from trial to discount to evergreen");
        MockPlanPhase plan2Phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWENTY, PhaseType.TRIAL);
        MockPlanPhase plan2Phase2 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.THIRTY, PhaseType.DISCOUNT);
        MockPlanPhase plan2Phase3 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.FORTY, PhaseType.EVERGREEN);
        LocalDate plan2StartDate = this.invoiceUtil.buildDate(2011, 3, 10);
        LocalDate plan2PhaseChangeToDiscountDate = this.invoiceUtil.buildDate(2011, 6, 10);
        LocalDate plan2PhaseChangeToEvergreenDate = this.invoiceUtil.buildDate(2011, 9, 10);
        MockPlan plan3 = new MockPlan("Upgrade with immediate change, BCD = 31");
        MockPlanPhase plan3Phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TEN, PhaseType.EVERGREEN);
        MockPlanPhase plan3Phase2 = this.createMockAnnualPlanPhase(TestInvoiceHelper.ONE_HUNDRED, PhaseType.EVERGREEN);
        LocalDate plan3StartDate = this.invoiceUtil.buildDate(2011, 5, 20);
        LocalDate plan3UpgradeToAnnualDate = this.invoiceUtil.buildDate(2011, 7, 31);
        MockPlan plan4a = new MockPlan("Plan change effective EOT; plan 1");
        MockPlan plan4b = new MockPlan("Plan change effective EOT; plan 2");
        MockPlanPhase plan4aPhase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.FIFTEEN);
        MockPlanPhase plan4bPhase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWENTY_FOUR);
        LocalDate plan4StartDate = this.invoiceUtil.buildDate(2011, 6, 7);
        LocalDate plan4ChangeOfPlanDate = this.invoiceUtil.buildDate(2011, 8, 7);
        MockPlan plan5 = new MockPlan("Add-on");
        MockPlanPhase plan5Phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWENTY);
        MockPlanPhase plan5Phase2 = this.createMockMonthlyPlanPhase();
        LocalDate plan5StartDate = this.invoiceUtil.buildDate(2011, 6, 21);
        LocalDate plan5CancelDate = this.invoiceUtil.buildDate(2011, 10, 7);
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1StartDate, (Plan)plan1, (PlanPhase)plan1Phase1, 5));
        BigDecimal expectedAmount = TestInvoiceHelper.EIGHT;
        this.testInvoiceGeneration(accountId, events, invoices, plan1StartDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.EIGHT;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 2, 5), 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.EIGHT;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 3, 5), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId2, bundleId, plan2StartDate, (Plan)plan2, (PlanPhase)plan2Phase1, 10));
        expectedAmount = TestInvoiceHelper.TWENTY;
        this.testInvoiceGeneration(accountId, events, invoices, plan2StartDate, 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan1, (PlanPhase)plan1Phase2, 5));
        expectedAmount = TestInvoiceHelper.TWELVE;
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.TWENTY;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 4, 10), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1CancelDate, (Plan)plan1, (PlanPhase)plan1Phase3, 5));
        expectedAmount = new BigDecimal("-2.40");
        this.testInvoiceGeneration(accountId, events, invoices, plan1CancelDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.TWENTY;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 5, 10), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId3, bundleId, plan3StartDate, (Plan)plan3, (PlanPhase)plan3Phase1, 20));
        expectedAmount = TestInvoiceHelper.TEN;
        this.testInvoiceGeneration(accountId, events, invoices, plan3StartDate, 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId4, bundleId, plan4StartDate, (Plan)plan4a, (PlanPhase)plan4aPhase1, 7));
        expectedAmount = TestInvoiceHelper.FIFTEEN;
        this.testInvoiceGeneration(accountId, events, invoices, plan4StartDate, 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId2, bundleId, plan2PhaseChangeToDiscountDate, (Plan)plan2, (PlanPhase)plan2Phase2, 10));
        expectedAmount = TestInvoiceHelper.THIRTY;
        this.testInvoiceGeneration(accountId, events, invoices, plan2PhaseChangeToDiscountDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.TEN;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 6, 20), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId5, bundleId, plan5StartDate, (Plan)plan5, (PlanPhase)plan5Phase1, 10));
        expectedAmount = TestInvoiceHelper.TWENTY.multiply(TestInvoiceHelper.NINETEEN).divide(TestInvoiceHelper.THIRTY, 4);
        this.testInvoiceGeneration(accountId, events, invoices, plan5StartDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.FIFTEEN;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 7, 7), 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.THIRTY.add(TestInvoiceHelper.TWENTY);
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 7, 10), 2, expectedAmount);
        expectedAmount = TestInvoiceHelper.TEN;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 7, 20), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId3, bundleId, plan3UpgradeToAnnualDate, (Plan)plan3, (PlanPhase)plan3Phase2, 31));
        this.testInvoiceGeneration(accountId, events, invoices, plan3UpgradeToAnnualDate, 2, new BigDecimal("93.55"));
        events.add(this.createBillingEvent(subscriptionId4, bundleId, plan4ChangeOfPlanDate, (Plan)plan4b, (PlanPhase)plan4bPhase1, 7));
        expectedAmount = TestInvoiceHelper.TWENTY_FOUR;
        this.testInvoiceGeneration(accountId, events, invoices, plan4ChangeOfPlanDate, 1, expectedAmount);
        expectedAmount = TestInvoiceHelper.THIRTY.add(TestInvoiceHelper.TWENTY);
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 8, 10), 2, expectedAmount);
        expectedAmount = TestInvoiceHelper.TWENTY_FOUR;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 9, 7), 1, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId2, bundleId, plan2PhaseChangeToEvergreenDate, (Plan)plan2, (PlanPhase)plan2Phase3, 10));
        expectedAmount = TestInvoiceHelper.FORTY.add(TestInvoiceHelper.TWENTY);
        this.testInvoiceGeneration(accountId, events, invoices, plan2PhaseChangeToEvergreenDate, 2, expectedAmount);
        events.add(this.createBillingEvent(subscriptionId5, bundleId, plan5CancelDate, (Plan)plan5, (PlanPhase)plan5Phase2, 10));
        this.testInvoiceGeneration(accountId, events, invoices, plan5CancelDate, 2, new BigDecimal("22.00"));
        expectedAmount = TestInvoiceHelper.FORTY;
        this.testInvoiceGeneration(accountId, events, invoices, this.invoiceUtil.buildDate(2011, 10, 10), 1, expectedAmount);
    }

    @Test(groups={"fast"})
    public void testZeroDollarEvents() throws InvoiceApiException, CatalogApiException {
        MockPlan plan = new MockPlan();
        MockPlanPhase planPhase = this.createMockMonthlyPlanPhase(TestInvoiceHelper.ZERO);
        MockBillingEventSet events = new MockBillingEventSet();
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 1);
        events.add(this.createBillingEvent(UUID.randomUUID(), UUID.randomUUID(), targetDate, (Plan)plan, (PlanPhase)planPhase, 1));
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(BigDecimal.ZERO), (int)0);
    }

    @Test(groups={"fast"})
    public void testEndDateIsCorrect() throws InvoiceApiException, CatalogApiException {
        MockPlan plan = new MockPlan();
        MockPlanPhase planPhase = this.createMockMonthlyPlanPhase(TestInvoiceHelper.ONE);
        MockBillingEventSet events = new MockBillingEventSet();
        LocalDate startDate = this.clock.getUTCToday().minusDays(1);
        LocalDate targetDate = startDate.plusDays(1);
        events.add(this.createBillingEvent(UUID.randomUUID(), UUID.randomUUID(), startDate, (Plan)plan, (PlanPhase)planPhase, startDate.getDayOfMonth()));
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        RecurringInvoiceItem item = (RecurringInvoiceItem)invoice.getInvoiceItems().get(0);
        Assert.assertEquals((Object)item.getEndDate(), (Object)startDate.plusMonths(1));
    }

    @Test(groups={"fast"})
    public void testFixedPriceLifeCycle() throws InvoiceApiException {
        SubscriptionBase subscription = this.createSubscription();
        MockPlan plan = new MockPlan("plan 1");
        MockInternationalPrice zeroPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.ZERO, Currency.USD)});
        MockInternationalPrice cheapPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.ONE, Currency.USD)});
        MockPlanPhase phase1 = new MockPlanPhase(null, zeroPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        MockPlanPhase phase2 = new MockPlanPhase(cheapPrice, null, BillingPeriod.MONTHLY, PhaseType.DISCOUNT);
        DateTime changeDate = new DateTime((Object)"2012-04-1");
        MockBillingEventSet events = new MockBillingEventSet();
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(null, subscription, new DateTime((Object)"2012-01-1"), (Plan)plan, (PlanPhase)phase1, TestInvoiceHelper.ZERO, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Test Event 1", 1L, SubscriptionBaseTransitionType.CREATE);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(null, subscription, changeDate, (Plan)plan, (PlanPhase)phase2, TestInvoiceHelper.ZERO, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Test Event 2", 2L, SubscriptionBaseTransitionType.PHASE);
        events.add(event2);
        events.add(event1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, new LocalDate((Object)"2012-02-01"), Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        invoiceList.add(invoice1);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, new LocalDate((Object)"2012-04-05"), Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)1);
        FixedPriceInvoiceItem item = (FixedPriceInvoiceItem)invoice2.getInvoiceItems().get(0);
        Assert.assertEquals((Object)item.getStartDate(), (Object)changeDate.toLocalDate());
    }

    @Test(groups={"fast"})
    public void testMixedModeLifeCycle() throws InvoiceApiException, CatalogApiException {
        MockPlan plan1 = new MockPlan();
        BigDecimal monthlyRate = TestInvoiceHelper.FIVE;
        BigDecimal fixedCost = TestInvoiceHelper.TEN;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(monthlyRate, fixedCost, PhaseType.TRIAL);
        MockBillingEventSet events = new MockBillingEventSet();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2011, 1, 1);
        BillingEvent event1 = this.createBillingEvent(subscriptionId, bundleId, startDate, (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, startDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)2);
        Assert.assertEquals((Object)invoice1.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.FIFTEEN, (Currency)invoice1.getCurrency()));
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        invoiceList.add(invoice1);
        LocalDate currentDate = startDate.plusMonths(1);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, currentDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)invoice2.getBalance(), (Object)KillBillMoney.of((BigDecimal)TestInvoiceHelper.FIVE, (Currency)invoice2.getCurrency()));
    }

    @Test(groups={"fast"})
    public void testFixedModePlanChange() throws InvoiceApiException, CatalogApiException {
        MockPlan plan1 = new MockPlan();
        BigDecimal fixedCost1 = TestInvoiceHelper.TEN;
        BigDecimal fixedCost2 = TestInvoiceHelper.TWENTY;
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(null, fixedCost1, PhaseType.TRIAL);
        MockPlanPhase phase2 = this.createMockMonthlyPlanPhase(null, fixedCost2, PhaseType.EVERGREEN);
        MockBillingEventSet events = new MockBillingEventSet();
        UUID subscriptionId = UUID.randomUUID();
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2011, 1, 1);
        BillingEvent event1 = this.createBillingEvent(subscriptionId, bundleId, startDate, (Plan)plan1, (PlanPhase)phase1, 1);
        events.add(event1);
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, startDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)invoice1.getBalance(), (Object)KillBillMoney.of((BigDecimal)fixedCost1, (Currency)invoice1.getCurrency()));
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        invoiceList.add(invoice1);
        LocalDate phaseChangeDate = startDate.plusMonths(1);
        BillingEvent event2 = this.createBillingEvent(subscriptionId, bundleId, phaseChangeDate, (Plan)plan1, (PlanPhase)phase2, 1);
        events.add(event2);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, phaseChangeDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)invoice2.getBalance(), (Object)KillBillMoney.of((BigDecimal)fixedCost2, (Currency)invoice2.getCurrency()));
    }

    @Test(groups={"fast"})
    public void testInvoiceGenerationFailureScenario() throws InvoiceApiException, CatalogApiException {
        MockBillingEventSet events = new MockBillingEventSet();
        UUID subscriptionId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        int BILL_CYCLE_DAY = 15;
        MockPlan plan1 = new MockPlan();
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(null, TestInvoiceHelper.ZERO, PhaseType.TRIAL);
        BigDecimal DISCOUNT_PRICE = new BigDecimal("9.95");
        MockPlanPhase phase2 = this.createMockMonthlyPlanPhase(DISCOUNT_PRICE, null, PhaseType.DISCOUNT);
        MockPlanPhase phase3 = this.createMockMonthlyPlanPhase(new BigDecimal("19.95"), null, PhaseType.EVERGREEN);
        LocalDate creationDate = new LocalDate(2012, 3, 6);
        events.add(this.createBillingEvent(subscriptionId, bundleId, creationDate, (Plan)plan1, (PlanPhase)phase1, 15));
        LocalDate trialPhaseEndDate = creationDate.plusDays(30);
        events.add(this.createBillingEvent(subscriptionId, bundleId, trialPhaseEndDate, (Plan)plan1, (PlanPhase)phase2, 15));
        LocalDate discountPhaseEndDate = trialPhaseEndDate.plusMonths(6);
        events.add(this.createBillingEvent(subscriptionId, bundleId, discountPhaseEndDate, (Plan)plan1, (PlanPhase)phase3, 15));
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, creationDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(TestInvoiceHelper.ZERO), (int)0);
        ArrayList<DefaultInvoice> invoiceList = new ArrayList<DefaultInvoice>();
        invoiceList.add(invoice1);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, trialPhaseEndDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice2.getInvoiceItems().get(0)).getStartDate(), (Object)trialPhaseEndDate);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(new BigDecimal("3.21")), (int)0);
        invoiceList.add(invoice2);
        LocalDate targetDate = new LocalDate(trialPhaseEndDate.getYear(), trialPhaseEndDate.getMonthOfYear(), 15);
        InvoiceWithMetadata invoiceWithMetadata3 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice3 = invoiceWithMetadata3.getInvoice();
        Assert.assertNotNull((Object)invoice3);
        Assert.assertEquals((int)invoice3.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice3.getInvoiceItems().get(0)).getStartDate(), (Object)targetDate);
        Assert.assertEquals((int)invoice3.getBalance().compareTo(DISCOUNT_PRICE), (int)0);
        invoiceList.add(invoice3);
        targetDate = targetDate.plusMonths(6);
        InvoiceWithMetadata invoiceWithMetadata4 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoiceList, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice4 = invoiceWithMetadata4.getInvoice();
        Assert.assertNotNull((Object)invoice4);
        Assert.assertEquals((int)invoice4.getNumberOfItems(), (int)7);
    }

    @Test(groups={"fast"}, expectedExceptions={InvoiceApiException.class})
    public void testTargetDateRestrictionFailure() throws InvoiceApiException, CatalogApiException {
        LocalDate targetDate = this.clock.getUTCToday().plusMonths(60);
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan1 = new MockPlan();
        MockPlanPhase phase1 = this.createMockMonthlyPlanPhase(null, TestInvoiceHelper.ZERO, PhaseType.TRIAL);
        events.add(this.createBillingEvent(UUID.randomUUID(), UUID.randomUUID(), this.clock.getUTCToday(), (Plan)plan1, (PlanPhase)phase1, 1));
        this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
    }

    @Test(groups={"fast"})
    public void testWithFullRepairInvoiceGeneration() throws CatalogApiException, InvoiceApiException {
        LocalDate april25 = new LocalDate(2012, 4, 25);
        SubscriptionBase baseSubscription = this.createSubscription();
        MockPlan basePlan = new MockPlan("base Plan");
        MockInternationalPrice price5 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.FIVE, Currency.USD)});
        MockInternationalPrice price10 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.TEN, Currency.USD)});
        MockInternationalPrice price20 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.TWENTY, Currency.USD)});
        MockPlanPhase basePlanEvergreen = new MockPlanPhase(price10, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(this.createBillingEvent(baseSubscription.getId(), baseSubscription.getBundleId(), april25, (Plan)basePlan, (PlanPhase)basePlanEvergreen, 25));
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, april25, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(TestInvoiceHelper.TEN), (int)0);
        ArrayList<DefaultInvoice> invoices = new ArrayList<DefaultInvoice>();
        invoices.add(invoice1);
        LocalDate april28 = new LocalDate(2012, 4, 28);
        SubscriptionBase addOnSubscription1 = this.createSubscription();
        MockPlan addOn1Plan = new MockPlan("add on 1");
        MockPlanPhase addOn1PlanPhaseEvergreen = new MockPlanPhase(price5, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        events.add(this.createBillingEvent(addOnSubscription1.getId(), baseSubscription.getBundleId(), april28, (Plan)addOn1Plan, (PlanPhase)addOn1PlanPhaseEvergreen, 25));
        SubscriptionBase addOnSubscription2 = this.createSubscription();
        MockPlan addOn2Plan = new MockPlan("add on 2");
        MockPlanPhase addOn2PlanPhaseEvergreen = new MockPlanPhase(price20, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        events.add(this.createBillingEvent(addOnSubscription2.getId(), baseSubscription.getBundleId(), april28, (Plan)addOn2Plan, (PlanPhase)addOn2PlanPhaseEvergreen, 25));
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoices, april28, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        invoices.add(invoice2);
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)2);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(KillBillMoney.of((BigDecimal)TestInvoiceHelper.TWENTY_FIVE.multiply(new BigDecimal("0.9")), (Currency)invoice2.getCurrency())), (int)0);
        MockBillingEventSet newEvents = new MockBillingEventSet();
        MockPlan basePlan2 = new MockPlan("base plan 2");
        MockInternationalPrice price13 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.THIRTEEN, Currency.USD)});
        MockPlanPhase basePlan2Phase = new MockPlanPhase(price13, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        newEvents.add(this.createBillingEvent(baseSubscription.getId(), baseSubscription.getBundleId(), april25, (Plan)basePlan2, (PlanPhase)basePlan2Phase, 25));
        newEvents.add(this.createBillingEvent(addOnSubscription1.getId(), baseSubscription.getBundleId(), april28, (Plan)addOn1Plan, (PlanPhase)addOn1PlanPhaseEvergreen, 25));
        LocalDate may1 = new LocalDate(2012, 5, 1);
        InvoiceWithMetadata invoiceWithMetadata3 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)newEvents, invoices, may1, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice3 = invoiceWithMetadata3.getInvoice();
        Assert.assertNotNull((Object)invoice3);
        Assert.assertEquals((int)invoice3.getNumberOfItems(), (int)3);
        Assert.assertEquals((int)invoice3.getBalance().compareTo(TestInvoiceHelper.FIFTEEN.negate()), (int)0);
    }

    @Test(groups={"fast"})
    public void testRepairForPaidInvoice() throws CatalogApiException, InvoiceApiException {
        LocalDate april25 = new LocalDate(2012, 4, 25);
        SubscriptionBase originalSubscription = this.createSubscription();
        MockPlan originalPlan = new MockPlan("original plan");
        MockInternationalPrice price10 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.TEN, Currency.USD)});
        MockPlanPhase originalPlanEvergreen = new MockPlanPhase(price10, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        MockBillingEventSet events = new MockBillingEventSet();
        events.add(this.createBillingEvent(originalSubscription.getId(), originalSubscription.getBundleId(), april25, (Plan)originalPlan, (PlanPhase)originalPlanEvergreen, 25));
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, april25, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        this.printDetailInvoice((Invoice)invoice1);
        Assert.assertEquals((int)invoice1.getNumberOfItems(), (int)1);
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        invoices.add((Invoice)invoice1);
        invoice1.addPayment((InvoicePayment)new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice1.getId(), april25.toDateTimeAtCurrentTime(), TestInvoiceHelper.TEN, Currency.USD, Currency.USD, null, Boolean.valueOf(true)));
        Assert.assertEquals((int)invoice1.getBalance().compareTo(TestInvoiceHelper.ZERO), (int)0);
        events.clear();
        SubscriptionBase newSubscription = this.createSubscription();
        MockPlan newPlan = new MockPlan("new plan");
        MockInternationalPrice price5 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(TestInvoiceHelper.FIVE, Currency.USD)});
        MockPlanPhase newPlanEvergreen = new MockPlanPhase(price5, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        events.add(this.createBillingEvent(newSubscription.getId(), originalSubscription.getBundleId(), april25, (Plan)newPlan, (PlanPhase)newPlanEvergreen, 25));
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, invoices, april25, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        this.printDetailInvoice((Invoice)invoice2);
        Assert.assertEquals((int)invoice2.getNumberOfItems(), (int)2);
        invoices.add((Invoice)invoice2);
        this.distributeItems(invoices);
        Assert.assertEquals((int)invoice1.getBalance().compareTo(BigDecimal.ZERO), (int)0);
        Assert.assertEquals((int)invoice2.getBalance().compareTo(new BigDecimal("-5.0")), (int)0);
    }

    @Test(groups={"fast"})
    public void testRegressionFor170() throws EntityPersistenceException, InvoiceApiException, CatalogApiException {
        UUID accountId = this.account.getId();
        Currency currency = Currency.USD;
        SubscriptionBase subscription = this.createSubscription();
        MockInternationalPrice recurringPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(new BigDecimal("2.9500"), Currency.USD)});
        MockPlanPhase phase = new MockPlanPhase(recurringPrice, null);
        MockPlan plan = new MockPlan(phase);
        LocalDate targetDate = new LocalDate(2013, 10, 30);
        DefaultInvoice existingInvoice = new DefaultInvoice(UUID.randomUUID(), accountId, null, this.clock.getUTCToday(), targetDate, currency, false, InvoiceStatus.COMMITTED);
        LocalDate startDate = new LocalDate(2013, 6, 15);
        LocalDate endDate = new LocalDate(2013, 7, 15);
        RecurringInvoiceItem recurringInvoiceItem = new RecurringInvoiceItem(existingInvoice.getId(), accountId, subscription.getBundleId(), subscription.getId(), plan.getName(), phase.getName(), startDate, endDate, recurringPrice.getPrice(currency), recurringPrice.getPrice(currency), Currency.USD);
        existingInvoice.addInvoiceItem((InvoiceItem)recurringInvoiceItem);
        LocalDate repairStartDate = new LocalDate(2013, 6, 21);
        LocalDate repairEndDate = new LocalDate(2013, 6, 26);
        BigDecimal repairAmount = new BigDecimal("0.4900").negate();
        RepairAdjInvoiceItem repairItem = new RepairAdjInvoiceItem(existingInvoice.getId(), accountId, repairStartDate, repairEndDate, repairAmount, currency, recurringInvoiceItem.getId());
        existingInvoice.addInvoiceItem((InvoiceItem)repairItem);
        MockBillingEventSet events = new MockBillingEventSet();
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(null, subscription, new DateTime((Object)"2013-06-15", DateTimeZone.UTC), (Plan)plan, (PlanPhase)phase, null, recurringPrice.getPrice(currency), currency, BillingPeriod.MONTHLY, 15, BillingMode.IN_ADVANCE, "testEvent", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        existingInvoices.add(existingInvoice);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, existingInvoices, targetDate, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)7);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2013, 6, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2013, 7, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2013, 6, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2013, 6, 21));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(2)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(2)).getStartDate(), (Object)new LocalDate(2013, 6, 26));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(2)).getEndDate(), (Object)new LocalDate(2013, 7, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(3)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(3)).getStartDate(), (Object)new LocalDate(2013, 7, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(3)).getEndDate(), (Object)new LocalDate(2013, 8, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(4)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(4)).getStartDate(), (Object)new LocalDate(2013, 8, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(4)).getEndDate(), (Object)new LocalDate(2013, 9, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(5)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(5)).getStartDate(), (Object)new LocalDate(2013, 9, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(5)).getEndDate(), (Object)new LocalDate(2013, 10, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(6)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(6)).getStartDate(), (Object)new LocalDate(2013, 10, 15));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(6)).getEndDate(), (Object)new LocalDate(2013, 11, 15));
        existingInvoices.add(invoice);
        InvoiceWithMetadata newInvoiceWithMetdata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, existingInvoices, targetDate, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice newInvoice = newInvoiceWithMetdata.getInvoice();
        Assert.assertNull((Object)newInvoice);
    }

    @Test(groups={"fast"})
    public void testAutoInvoiceOffAccount() throws Exception {
        MockBillingEventSet events = new MockBillingEventSet();
        events.setAccountInvoiceOff(true);
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 9, 1);
        MockPlan plan = new MockPlan();
        BigDecimal rate1 = TestInvoiceHelper.TEN;
        MockPlanPhase phase = this.createMockMonthlyPlanPhase(rate1);
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 1);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 10, 3);
        UUID accountId = UUID.randomUUID();
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        Assert.assertNull((Object)invoiceWithMetadata.getInvoice());
    }

    @Test(groups={"fast"})
    public void testAutoInvoiceOffWithCredits() throws CatalogApiException, InvoiceApiException {
        Currency currency = Currency.USD;
        ArrayList<DefaultInvoice> invoices = new ArrayList<DefaultInvoice>();
        MockBillingEventSet eventSet = new MockBillingEventSet();
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        LocalDate startDate = new LocalDate(2012, 1, 1);
        UUID subscriptionId1 = UUID.randomUUID();
        MockPlan plan1 = new MockPlan();
        MockPlanPhase plan1phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.FIFTEEN, null, PhaseType.DISCOUNT);
        BillingEvent subscription1creation = this.createBillingEvent(subscriptionId1, bundleId, startDate, (Plan)plan1, (PlanPhase)plan1phase1, 1);
        eventSet.add(subscription1creation);
        UUID subscriptionId2 = UUID.randomUUID();
        MockPlan plan2 = new MockPlan();
        MockPlanPhase plan2phase1 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWELVE, null, PhaseType.EVERGREEN);
        eventSet.add(this.createBillingEvent(subscriptionId2, bundleId, startDate, (Plan)plan2, (PlanPhase)plan2phase1, 1));
        InvoiceWithMetadata invoiceWithMetadata1 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)eventSet, invoices, startDate, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice1 = invoiceWithMetadata1.getInvoice();
        Assert.assertNotNull((Object)invoice1);
        Assert.assertTrue((invoice1.getBalance().compareTo(TestInvoiceHelper.FIFTEEN.add(TestInvoiceHelper.TWELVE)) == 0 ? 1 : 0) != 0);
        invoices.add(invoice1);
        eventSet.remove(subscription1creation);
        eventSet.addSubscriptionWithAutoInvoiceOff(subscriptionId1);
        LocalDate targetDate2 = startDate.plusMonths(1);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)eventSet, invoices, targetDate2, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNotNull((Object)invoice2);
        Assert.assertTrue((invoice2.getBalance().compareTo(TestInvoiceHelper.TWELVE) == 0 ? 1 : 0) != 0);
        invoices.add(invoice2);
        LocalDate targetDate3 = targetDate2.plusMonths(1);
        eventSet.clearSubscriptionsWithAutoInvoiceOff();
        eventSet.add(subscription1creation);
        InvoiceWithMetadata invoiceWithMetadata3 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)eventSet, invoices, targetDate3, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice3 = invoiceWithMetadata3.getInvoice();
        Assert.assertNotNull((Object)invoice3);
        Assert.assertTrue((invoice3.getBalance().compareTo(TestInvoiceHelper.FIFTEEN.multiply(TestInvoiceHelper.TWO).add(TestInvoiceHelper.TWELVE)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/654")
    public void testCancelEOTWithFullItemAdjustment() throws CatalogApiException, InvoiceApiException {
        BigDecimal rate = new BigDecimal("39.95");
        MockBillingEventSet events = new MockBillingEventSet();
        SubscriptionBase sub = this.createSubscription();
        LocalDate startDate = this.invoiceUtil.buildDate(2016, 10, 9);
        LocalDate endDate = this.invoiceUtil.buildDate(2016, 11, 9);
        MockPlan plan = new MockPlan();
        MockPlanPhase phase = this.createMockMonthlyPlanPhase(rate);
        BillingEvent event = this.createBillingEvent(sub.getId(), sub.getBundleId(), startDate, (Plan)plan, (PlanPhase)phase, 9);
        events.add(event);
        LocalDate targetDate = this.invoiceUtil.buildDate(2016, 10, 9);
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, null, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)1);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)rate, (Currency)invoice.getCurrency()));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)sub.getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)startDate);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)endDate);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, sub, endDate.toDateTimeAtStartOfDay(), null, (PlanPhase)phase, TestInvoiceHelper.ZERO, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 9, BillingMode.IN_ADVANCE, "Cancel", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        ItemAdjInvoiceItem itemAdj = new ItemAdjInvoiceItem((InvoiceItem)invoice.getInvoiceItems().get(0), new LocalDate(2016, 10, 12), rate.negate(), Currency.USD);
        invoice.addInvoiceItem((InvoiceItem)itemAdj);
        ArrayList<DefaultInvoice> existingInvoices = new ArrayList<DefaultInvoice>();
        existingInvoices.add(invoice);
        InvoiceWithMetadata invoiceWithMetadata2 = this.generator.generateInvoice((ImmutableAccountData)this.account, (BillingEventSet)events, existingInvoices, targetDate, Currency.USD, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice2 = invoiceWithMetadata2.getInvoice();
        Assert.assertNull((Object)invoice2);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testMultipleDailyChangesDoNotTriggerBounds() throws InvoiceApiException, CatalogApiException {
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        MockBillingEventSet events = new MockBillingEventSet();
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        MockPlan plan1 = new MockPlan("plan1");
        MockPlanPhase plan1Phase1 = this.createMockMonthlyPlanPhase(null, TestInvoiceHelper.EIGHT, PhaseType.TRIAL);
        MockPlanPhase plan1Phase2 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWELVE, PhaseType.DISCOUNT);
        LocalDate plan1StartDate = this.invoiceUtil.buildDate(2011, 1, 5);
        LocalDate plan1PhaseChangeDate = this.invoiceUtil.buildDate(2011, 4, 5);
        MockPlan plan2 = new MockPlan("plan2");
        MockPlanPhase plan2Phase1 = this.createMockMonthlyPlanPhase(null, TestInvoiceHelper.TWENTY, PhaseType.TRIAL);
        MockPlanPhase plan2Phase2 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.THIRTY, PhaseType.DISCOUNT);
        MockPlanPhase plan2Phase3 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.FORTY, PhaseType.EVERGREEN);
        MockPlanPhase plan2Phase4 = this.createMockMonthlyPlanPhase();
        LocalDate plan2PhaseChangeToEvergreenDate = this.invoiceUtil.buildDate(2011, 6, 5);
        LocalDate plan2CancelDate = this.invoiceUtil.buildDate(2011, 6, 5);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1StartDate, (Plan)plan1, (PlanPhase)plan1Phase1, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1StartDate, 1, TestInvoiceHelper.EIGHT);
        Invoice invoice = (Invoice)invoices.get(0);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 1, 5));
        Assert.assertNull((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate());
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.EIGHT), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1StartDate, (Plan)plan2, (PlanPhase)plan2Phase1, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1StartDate, 1, TestInvoiceHelper.TWENTY);
        Assert.assertEquals(invoices.get(0), (Object)invoice);
        invoice = (Invoice)invoices.get(1);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 1, 5));
        Assert.assertNull((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate());
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.TWENTY), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1StartDate, (Plan)plan1, (PlanPhase)plan1Phase1, 5));
        this.testNullInvoiceGeneration(events, invoices, plan1StartDate);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan1, (PlanPhase)plan1Phase2, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 1, TestInvoiceHelper.TWELVE);
        Assert.assertEquals(invoices.get(1), (Object)invoice);
        invoice = (Invoice)invoices.get(2);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.TWELVE), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan2, (PlanPhase)plan2Phase2, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 2, new BigDecimal("18"));
        Assert.assertEquals(invoices.get(2), (Object)invoice);
        invoice = (Invoice)invoices.get(3);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.THIRTY), (int)0);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getLinkedItemId(), (Object)((InvoiceItem)((Invoice)invoices.get(2)).getInvoiceItems().get(0)).getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(1)).getAmount().compareTo(TestInvoiceHelper.TWELVE.negate()), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan1, (PlanPhase)plan1Phase2, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 2, new BigDecimal("-18"));
        Assert.assertEquals(invoices.get(3), (Object)invoice);
        invoice = (Invoice)invoices.get(4);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.TWELVE), (int)0);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getLinkedItemId(), (Object)((InvoiceItem)((Invoice)invoices.get(3)).getInvoiceItems().get(0)).getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(1)).getAmount().compareTo(TestInvoiceHelper.THIRTY.negate()), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan2, (PlanPhase)plan2Phase2, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 2, new BigDecimal("18"));
        Assert.assertEquals(invoices.get(4), (Object)invoice);
        invoice = (Invoice)invoices.get(5);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.THIRTY), (int)0);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getLinkedItemId(), (Object)((InvoiceItem)((Invoice)invoices.get(4)).getInvoiceItems().get(0)).getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 4, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(1)).getAmount().compareTo(TestInvoiceHelper.TWELVE.negate()), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan2PhaseChangeToEvergreenDate, (Plan)plan2, (PlanPhase)plan2Phase3, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan2PhaseChangeToEvergreenDate, 2, new BigDecimal("70"));
        Assert.assertEquals(invoices.get(5), (Object)invoice);
        invoice = (Invoice)invoices.get(6);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 5, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 6, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.THIRTY), (int)0);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getStartDate(), (Object)new LocalDate(2011, 6, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(1)).getEndDate(), (Object)new LocalDate(2011, 7, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(1)).getAmount().compareTo(TestInvoiceHelper.FORTY), (int)0);
        events.add(this.createBillingEvent(subscriptionId1, bundleId, plan2CancelDate, (Plan)plan2, (PlanPhase)plan2Phase4, 5));
        this.testInvoiceGeneration(accountId, events, invoices, plan2PhaseChangeToEvergreenDate, 1, TestInvoiceHelper.FORTY.negate());
        Assert.assertEquals(invoices.get(6), (Object)invoice);
        invoice = (Invoice)invoices.get(7);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getLinkedItemId(), (Object)((InvoiceItem)((Invoice)invoices.get(6)).getInvoiceItems().get(1)).getId());
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 6, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 7, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.FORTY.negate()), (int)0);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testBuggyBillingEventsDoNotImpactInvoicing() throws InvoiceApiException, CatalogApiException {
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId1 = UUID.randomUUID();
        MockBillingEventSet events = new MockBillingEventSet();
        ArrayList<Invoice> invoices = new ArrayList<Invoice>();
        MockPlan plan1 = new MockPlan("plan1");
        MockPlanPhase plan1Phase1 = this.createMockMonthlyPlanPhase(null, TestInvoiceHelper.EIGHT, PhaseType.TRIAL);
        MockPlanPhase plan1Phase2 = this.createMockMonthlyPlanPhase(TestInvoiceHelper.TWELVE, PhaseType.EVERGREEN);
        LocalDate plan1StartDate = this.invoiceUtil.buildDate(2011, 1, 5);
        LocalDate plan1PhaseChangeDate = this.invoiceUtil.buildDate(2011, 2, 5);
        for (int i = 0; i < 10; ++i) {
            events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1StartDate, (Plan)plan1, (PlanPhase)plan1Phase1, 5));
            events.add(this.createBillingEvent(subscriptionId1, bundleId, plan1PhaseChangeDate, (Plan)plan1, (PlanPhase)plan1Phase2, 5));
        }
        Assert.assertEquals((int)events.size(), (int)20);
        this.testInvoiceGeneration(accountId, events, invoices, plan1StartDate, 1, TestInvoiceHelper.EIGHT);
        Invoice invoice = (Invoice)invoices.get(0);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 1, 5));
        Assert.assertNull((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate());
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.EIGHT), (int)0);
        this.testInvoiceGeneration(accountId, events, invoices, plan1PhaseChangeDate, 1, TestInvoiceHelper.TWELVE);
        invoice = (Invoice)invoices.get(1);
        Assert.assertEquals((int)invoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getSubscriptionId(), (Object)subscriptionId1);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getStartDate(), (Object)new LocalDate(2011, 2, 5));
        Assert.assertEquals((Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getEndDate(), (Object)new LocalDate(2011, 3, 5));
        Assert.assertEquals((int)((InvoiceItem)invoice.getInvoiceItems().get(0)).getAmount().compareTo(TestInvoiceHelper.TWELVE), (int)0);
    }

    private MockPlanPhase createMockThirtyDaysPlanPhase(@Nullable BigDecimal recurringRate) {
        return new MockPlanPhase(new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), null, BillingPeriod.THIRTY_DAYS);
    }

    private MockPlanPhase createMockMonthlyPlanPhase() {
        return new MockPlanPhase(null, null, BillingPeriod.MONTHLY);
    }

    private MockPlanPhase createMockMonthlyPlanPhase(@Nullable BigDecimal recurringRate) {
        return new MockPlanPhase(new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), null, BillingPeriod.MONTHLY);
    }

    private MockPlanPhase createMockMonthlyPlanPhase(BigDecimal recurringRate, PhaseType phaseType) {
        return new MockPlanPhase(new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), null, BillingPeriod.MONTHLY, phaseType);
    }

    private MockPlanPhase createMockMonthlyPlanPhase(@Nullable BigDecimal recurringRate, @Nullable BigDecimal fixedCost, PhaseType phaseType) {
        MockInternationalPrice recurringPrice = recurringRate == null ? null : new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)});
        MockInternationalPrice fixedPrice = fixedCost == null ? null : new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedCost, Currency.USD)});
        return new MockPlanPhase(recurringPrice, fixedPrice, BillingPeriod.MONTHLY, phaseType);
    }

    private MockPlanPhase createMockAnnualPlanPhase(BigDecimal recurringRate, PhaseType phaseType) {
        return new MockPlanPhase(new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(recurringRate, Currency.USD)}), null, BillingPeriod.ANNUAL, phaseType);
    }

    private SubscriptionBase createSubscription() {
        return this.createSubscription(UUID.randomUUID(), UUID.randomUUID());
    }

    private SubscriptionBase createSubscription(UUID subscriptionId, UUID bundleId) {
        SubscriptionBase sub = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)sub.getId()).thenReturn((Object)subscriptionId);
        Mockito.when((Object)sub.getBundleId()).thenReturn((Object)bundleId);
        return sub;
    }

    private BillingEvent createBillingEvent(UUID subscriptionId, UUID bundleId, LocalDate startDate, Plan plan, PlanPhase planPhase, int billCycleDayLocal) throws CatalogApiException {
        SubscriptionBase sub = this.createSubscription(subscriptionId, bundleId);
        Currency currency = Currency.USD;
        Long l = this.totalOrdering;
        Long l2 = this.totalOrdering = Long.valueOf(this.totalOrdering + 1L);
        return this.invoiceUtil.createMockBillingEvent(null, sub, startDate.toDateTimeAtStartOfDay(), plan, planPhase, planPhase.getFixed().getPrice() == null ? null : planPhase.getFixed().getPrice().getPrice(currency), planPhase.getRecurring().getRecurringPrice() == null ? null : planPhase.getRecurring().getRecurringPrice().getPrice(currency), currency, planPhase.getRecurring().getBillingPeriod(), billCycleDayLocal, BillingMode.IN_ADVANCE, "Test", l, SubscriptionBaseTransitionType.CREATE);
    }

    private void testInvoiceGeneration(UUID accountId, BillingEventSet events, List<Invoice> existingInvoices, LocalDate targetDate, int expectedNumberOfItems, BigDecimal expectedAmount) throws InvoiceApiException {
        Currency currency = Currency.USD;
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, events, existingInvoices, targetDate, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals((int)invoice.getNumberOfItems(), (int)expectedNumberOfItems);
        existingInvoices.add((Invoice)invoice);
        this.distributeItems(existingInvoices);
        Assert.assertEquals((Object)invoice.getBalance(), (Object)KillBillMoney.of((BigDecimal)expectedAmount, (Currency)invoice.getCurrency()));
    }

    private void testNullInvoiceGeneration(BillingEventSet events, List<Invoice> existingInvoices, LocalDate targetDate) throws InvoiceApiException {
        Currency currency = Currency.USD;
        InvoiceWithMetadata invoiceWithMetadata = this.generator.generateInvoice((ImmutableAccountData)this.account, events, existingInvoices, targetDate, currency, (InternalCallContext)this.internalCallContext);
        DefaultInvoice invoice = invoiceWithMetadata.getInvoice();
        Assert.assertNull((Object)invoice);
    }

    private void distributeItems(List<Invoice> invoices) {
        HashMap<UUID, Invoice> invoiceMap = new HashMap<UUID, Invoice>();
        for (Invoice invoice : invoices) {
            invoiceMap.put(invoice.getId(), invoice);
        }
        for (Invoice invoice : invoices) {
            Iterator itemIterator = invoice.getInvoiceItems().iterator();
            UUID invoiceId = invoice.getId();
            while (itemIterator.hasNext()) {
                InvoiceItem item = (InvoiceItem)itemIterator.next();
                if (item.getInvoiceId().equals(invoiceId)) continue;
                Invoice thisInvoice = (Invoice)invoiceMap.get(item.getInvoiceId());
                if (thisInvoice == null) {
                    throw new NullPointerException();
                }
                thisInvoice.addInvoiceItem(item);
                itemIterator.remove();
            }
        }
    }

    private void printDetailInvoice(Invoice invoice) {
        log.info("--------------------  START DETAIL ----------------------");
        log.info("Invoice " + invoice.getId() + ": BALANCE = " + invoice.getBalance() + ", CBA = " + invoice.getCreditedAmount() + ", CHARGE_AMOUNT = " + invoice.getChargedAmount() + ", ADJ_AMOUNT = " + invoice.getCreditedAmount());
        for (InvoiceItem cur : invoice.getInvoiceItems()) {
            log.info(cur.toString());
        }
        log.info("--------------------  END DETAIL ----------------------");
    }
}

