/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.MockBillingEventSet;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.ItemAdjInvoiceItem;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.invoice.model.RepairAdjInvoiceItem;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingEventSet;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestFixedAndRecurringInvoiceItemGenerator
extends InvoiceTestSuiteNoDB {
    private Account account;
    private SubscriptionBase subscription;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        super.beforeMethod();
        try {
            this.account = this.invoiceUtil.createAccount(this.callContext);
            this.subscription = this.invoiceUtil.createSubscription();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"fast"})
    public void testIsSameDayAndSameSubscriptionWithNullPrevEvent() {
        MockPlan plan = new MockPlan("my-plan");
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        InvoiceItem prevInvoiceItem = null;
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-02-01"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        Assert.assertFalse((boolean)this.fixedAndRecurringInvoiceItemGenerator.isSameDayAndSameSubscription(prevInvoiceItem, event, (InternalCallContext)this.internalCallContext));
    }

    @Test(groups={"fast"})
    public void testIsSameDayAndSameSubscriptionWithDifferentSubscriptionId() {
        MockPlan plan = new MockPlan("my-plan");
        LocalDate invoiceItemDate = new LocalDate((Object)"2016-01-08");
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        UUID invoiceId = UUID.randomUUID();
        FixedPriceInvoiceItem prevInvoiceItem = new FixedPriceInvoiceItem(invoiceId, this.account.getId(), UUID.randomUUID(), UUID.randomUUID(), plan.getName(), phase.getName(), invoiceItemDate, fixedPriceAmount, Currency.USD);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        Assert.assertFalse((boolean)this.fixedAndRecurringInvoiceItemGenerator.isSameDayAndSameSubscription((InvoiceItem)prevInvoiceItem, event, (InternalCallContext)this.internalCallContext));
    }

    @Test(groups={"fast"})
    public void testIsSameDayAndSameSubscriptionWithDifferentDate() {
        MockPlan plan = new MockPlan("my-plan");
        LocalDate invoiceItemDate = new LocalDate((Object)"2016-01-08");
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        UUID invoiceId = UUID.randomUUID();
        FixedPriceInvoiceItem prevInvoiceItem = new FixedPriceInvoiceItem(invoiceId, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), plan.getName(), phase.getName(), invoiceItemDate, fixedPriceAmount, Currency.USD);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-02-01"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        Assert.assertFalse((boolean)this.fixedAndRecurringInvoiceItemGenerator.isSameDayAndSameSubscription((InvoiceItem)prevInvoiceItem, event, (InternalCallContext)this.internalCallContext));
    }

    @Test(groups={"fast"})
    public void testIsSameDayAndSameSubscriptionWithSameDateAndSubscriptionId() {
        MockPlan plan = new MockPlan("my-plan");
        LocalDate invoiceItemDate = new LocalDate((Object)"2016-01-08");
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        UUID invoiceId = UUID.randomUUID();
        FixedPriceInvoiceItem prevInvoiceItem = new FixedPriceInvoiceItem(invoiceId, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), plan.getName(), phase.getName(), invoiceItemDate, fixedPriceAmount, Currency.USD);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        Assert.assertTrue((boolean)this.fixedAndRecurringInvoiceItemGenerator.isSameDayAndSameSubscription((InvoiceItem)prevInvoiceItem, event, (InternalCallContext)this.internalCallContext));
    }

    @Test(groups={"fast"})
    public void testProcessFixedBillingEventsWithCancellationOnSameDay() throws InvoiceApiException {
        LocalDate targetDate = new LocalDate((Object)"2016-01-08");
        UUID invoiceId = UUID.randomUUID();
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan, (PlanPhase)phase, null, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        ArrayList proposedItems = new ArrayList();
        this.fixedAndRecurringInvoiceItemGenerator.processFixedBillingEvents(invoiceId, this.account.getId(), (BillingEventSet)events, targetDate, Currency.USD, proposedItems, (InternalCallContext)this.internalCallContext);
        Assert.assertTrue((boolean)proposedItems.isEmpty());
    }

    @Test(groups={"fast"})
    public void testProcessFixedBillingEventsWithCancellationOnNextDay() throws InvoiceApiException {
        LocalDate targetDate = new LocalDate((Object)"2016-01-08");
        UUID invoiceId = UUID.randomUUID();
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal fixedPriceAmount = BigDecimal.TEN;
        MockInternationalPrice fixedPrice = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount, Currency.USD)});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase phase = new MockPlanPhase(null, fixedPrice, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan, (PlanPhase)phase, fixedPriceAmount, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-09"), (Plan)plan, (PlanPhase)phase, null, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        ArrayList proposedItems = new ArrayList();
        this.fixedAndRecurringInvoiceItemGenerator.processFixedBillingEvents(invoiceId, this.account.getId(), (BillingEventSet)events, targetDate, Currency.USD, proposedItems, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)proposedItems.size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)proposedItems.get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((int)((InvoiceItem)proposedItems.get(0)).getAmount().compareTo(fixedPriceAmount), (int)0);
    }

    @Test(groups={"fast"})
    public void testProcessFixedBillingEventsWithMultipleChangeOnSameDay() throws InvoiceApiException {
        LocalDate targetDate = new LocalDate((Object)"2016-01-08");
        UUID invoiceId = UUID.randomUUID();
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal fixedPriceAmount1 = BigDecimal.TEN;
        MockInternationalPrice fixedPrice1 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount1, Currency.USD)});
        MockPlan plan1 = new MockPlan("my-plan1");
        MockPlanPhase planPhase1 = new MockPlanPhase(null, fixedPrice1, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan1, (PlanPhase)planPhase1, fixedPriceAmount1, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BigDecimal fixedPriceAmount2 = null;
        MockInternationalPrice fixedPrice2 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount2, Currency.USD)});
        MockPlan plan2 = new MockPlan("my-plan2");
        MockPlanPhase planPhase2 = new MockPlanPhase(null, fixedPrice2, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan2, (PlanPhase)planPhase2, fixedPriceAmount2, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CHANGE);
        events.add(event2);
        BigDecimal fixedPriceAmount3 = BigDecimal.ONE;
        MockInternationalPrice fixedPrice3 = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(fixedPriceAmount3, Currency.USD)});
        MockPlan plan3 = new MockPlan("my-plan3");
        MockPlanPhase planPhase3 = new MockPlanPhase(null, fixedPrice3, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event3 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2016-01-08"), (Plan)plan3, (PlanPhase)planPhase3, fixedPriceAmount3, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 3L, SubscriptionBaseTransitionType.CHANGE);
        events.add(event3);
        ArrayList proposedItems = new ArrayList();
        this.fixedAndRecurringInvoiceItemGenerator.processFixedBillingEvents(invoiceId, this.account.getId(), (BillingEventSet)events, targetDate, Currency.USD, proposedItems, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)proposedItems.size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)proposedItems.get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((int)((InvoiceItem)proposedItems.get(0)).getAmount().compareTo(fixedPriceAmount3), (int)0);
    }

    @Test(groups={"fast"})
    public void testSafetyBoundsTooManyInvoiceItemsForGivenSubscriptionAndInvoiceDate() throws InvoiceApiException {
        DefaultInvoice invoice;
        int i;
        int threshold = 15;
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), planPhase.getRecurring().getBillingPeriod(), 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        for (i = 0; i < 15; ++i) {
            invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate.plusMonths(i), this.account.getCurrency());
            invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.plusMonths(i).toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate.plusMonths(i), startDate.plusMonths(1 + i), amount, amount, this.account.getCurrency()));
            existingInvoices.add(invoice);
        }
        Assert.assertEquals((int)this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate.plusMonths(15), this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext).size(), (int)1);
        for (i = 15; i < 30; ++i) {
            invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate.plusMonths(i), this.account.getCurrency());
            invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate.plusMonths(i), startDate.plusMonths(1 + i), amount, amount, this.account.getCurrency()));
            existingInvoices.add(invoice);
        }
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate.plusMonths(30), this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testTooManyFixedInvoiceItemsForGivenSubscriptionAndStartDate() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(null, price, BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, amount, null, this.account.getCurrency(), BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        for (int i = 0; i < 20; ++i) {
            DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
            invoice.addInvoiceItem((InvoiceItem)new FixedPriceInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), "Buggy fixed item", startDate, amount, this.account.getCurrency()));
            existingInvoices.add(invoice);
        }
        List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)generatedItems.size(), (int)0);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testSubscriptionAlreadyDoubleBilledForServicePeriod() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        for (int i = 0; i < 20; ++i) {
            DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate.plusMonths(i), this.account.getCurrency());
            invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.plusMonths(i).toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
            existingInvoices.add(invoice);
        }
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Double billing detected"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingItems() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusDays(29), amount, amount, this.account.getCurrency()));
        existingInvoices.add(invoice);
        List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)generatedItems.size(), (int)2);
        Assert.assertTrue((boolean)(generatedItems.get(0) instanceof RecurringInvoiceItem));
        Assert.assertEquals((Object)((InvoiceItem)generatedItems.get(0)).getStartDate(), (Object)new LocalDate((Object)"2016-01-01"));
        Assert.assertEquals((Object)((InvoiceItem)generatedItems.get(0)).getEndDate(), (Object)new LocalDate((Object)"2016-02-01"));
        Assert.assertEquals((int)((InvoiceItem)generatedItems.get(0)).getAmount().compareTo(amount), (int)0);
        Assert.assertTrue((boolean)(generatedItems.get(1) instanceof RepairAdjInvoiceItem));
        Assert.assertEquals((int)((InvoiceItem)generatedItems.get(1)).getAmount().compareTo(amount.negate()), (int)0);
        Assert.assertEquals((Object)((InvoiceItem)generatedItems.get(1)).getLinkedItemId(), (Object)((InvoiceItem)invoice.getInvoiceItems().get(0)).getId());
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingExistingItems() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusDays(29), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Double billing detected"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingItemsWithRepair() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusDays(29), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusDays(29), BigDecimal.ONE.negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        existingInvoices.add(invoice);
        List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)generatedItems.size(), (int)1);
        Assert.assertTrue((boolean)(generatedItems.get(0) instanceof RecurringInvoiceItem));
        Assert.assertEquals((Object)((InvoiceItem)generatedItems.get(0)).getStartDate(), (Object)new LocalDate((Object)"2016-01-01"));
        Assert.assertEquals((Object)((InvoiceItem)generatedItems.get(0)).getEndDate(), (Object)new LocalDate((Object)"2016-02-01"));
        Assert.assertEquals((int)((InvoiceItem)generatedItems.get(0)).getAmount().compareTo(amount), (int)0);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingItemsWithTooManyRepairs() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusDays(29), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusDays(29), BigDecimal.ONE.negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusDays(29), BigDecimal.ONE.negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Too many repairs"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingItemsWithInvalidRepair() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), startDate, startDate.plusDays(29), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusDays(30), BigDecimal.ONE.negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Invalid cancelledItem"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testInvalidRepair() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusMonths(1), BigDecimal.ONE.negate(), this.account.getCurrency(), UUID.randomUUID()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Missing cancelledItem"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testInvalidAdjustment() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new ItemAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, "Dangling adjustment", BigDecimal.ONE.negate(), this.account.getCurrency(), UUID.randomUUID()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Missing subscription id"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testItemFullyRepairedAndFullyAdjusted() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), "my-plan", "my-plan-monthly", startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate, startDate.plusMonths(1), BigDecimal.ONE.negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        invoice.addInvoiceItem((InvoiceItem)new ItemAdjInvoiceItem((InvoiceItem)invoice.getInvoiceItems().get(0), startDate, amount.negate(), this.account.getCurrency()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Too many repairs"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testItemPartiallyRepairedAndPartiallyAdjusted() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.plusDays(1).toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), plan.getName(), planPhase.getName(), startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate.plusDays(1), startDate.plusMonths(1), new BigDecimal("9.68").negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        invoice.addInvoiceItem((InvoiceItem)new ItemAdjInvoiceItem((InvoiceItem)invoice.getInvoiceItems().get(0), startDate, new BigDecimal("0.32").negate(), this.account.getCurrency()));
        existingInvoices.add(invoice);
        List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
        Assert.assertTrue((boolean)generatedItems.isEmpty());
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testItemPartiallyRepairedAndPartiallyAdjustedV2() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.plusDays(1).toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), plan.getName(), planPhase.getName(), startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new ItemAdjInvoiceItem((InvoiceItem)invoice.getInvoiceItems().get(0), startDate, BigDecimal.ONE.negate(), this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate.plusDays(1), startDate.plusMonths(1), new BigDecimal("9").negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        existingInvoices.add(invoice);
        List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
        Assert.assertTrue((boolean)generatedItems.isEmpty());
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testItemPartiallyRepairedAndInvalidAdjustment() throws InvoiceApiException {
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        MockBillingEventSet events = new MockBillingEventSet();
        BigDecimal amount = BigDecimal.TEN;
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(amount, this.account.getCurrency())});
        MockPlan plan = new MockPlan("my-plan");
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event1 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, amount, this.account.getCurrency(), BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        events.add(event1);
        BillingEvent event2 = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, startDate.plusDays(1).toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, null, Currency.USD, BillingPeriod.NO_BILLING_PERIOD, 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 2L, SubscriptionBaseTransitionType.CANCEL);
        events.add(event2);
        LinkedList<DefaultInvoice> existingInvoices = new LinkedList<DefaultInvoice>();
        DefaultInvoice invoice = new DefaultInvoice(this.account.getId(), this.clock.getUTCToday(), startDate, this.account.getCurrency());
        invoice.addInvoiceItem((InvoiceItem)new RecurringInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), plan.getName(), planPhase.getName(), startDate, startDate.plusMonths(1), amount, amount, this.account.getCurrency()));
        invoice.addInvoiceItem((InvoiceItem)new RepairAdjInvoiceItem(UUID.randomUUID(), startDate.toDateTimeAtStartOfDay(), invoice.getId(), this.account.getId(), startDate.plusDays(1), startDate.plusMonths(1), new BigDecimal("9.68").negate(), this.account.getCurrency(), ((InvoiceItem)invoice.getInvoiceItems().get(0)).getId()));
        invoice.addInvoiceItem((InvoiceItem)new ItemAdjInvoiceItem((InvoiceItem)invoice.getInvoiceItems().get(0), startDate, new BigDecimal("9.68").negate(), this.account.getCurrency()));
        existingInvoices.add(invoice);
        try {
            List generatedItems = this.fixedAndRecurringInvoiceItemGenerator.generateItems((ImmutableAccountData)this.account, UUID.randomUUID(), (BillingEventSet)events, existingInvoices, startDate, this.account.getCurrency(), new HashMap(), (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().endsWith("overly repaired"));
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testTooManyFixedInvoiceItemsForGivenSubscriptionAndStartDatePostMerge() throws InvoiceApiException {
        LinkedListMultimap createdItemsPerDayPerSubscription = LinkedListMultimap.create();
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        LinkedList<FixedPriceInvoiceItem> resultingItems = new LinkedList<FixedPriceInvoiceItem>();
        FixedPriceInvoiceItem fixedPriceInvoiceItem = new FixedPriceInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), "planName", "phaseName", "description", startDate, BigDecimal.ONE, this.account.getCurrency());
        resultingItems.add(fixedPriceInvoiceItem);
        resultingItems.add(fixedPriceInvoiceItem);
        try {
            this.fixedAndRecurringInvoiceItemGenerator.safetyBounds(resultingItems, (Multimap)createdItemsPerDayPerSubscription, (InternalTenantContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
        }
        resultingItems.clear();
        for (int i = 0; i < 2; ++i) {
            resultingItems.add(new FixedPriceInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), "planName", "phaseName", "description", startDate, BigDecimal.ONE.add(new BigDecimal(i)), this.account.getCurrency()));
        }
        try {
            this.fixedAndRecurringInvoiceItemGenerator.safetyBounds(resultingItems, (Multimap)createdItemsPerDayPerSubscription, (InternalTenantContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testTooManyRecurringInvoiceItemsForGivenSubscriptionAndServicePeriodPostMerge() throws InvoiceApiException {
        LinkedListMultimap createdItemsPerDayPerSubscription = LinkedListMultimap.create();
        LocalDate startDate = new LocalDate((Object)"2016-01-01");
        LinkedList<RecurringInvoiceItem> resultingItems = new LinkedList<RecurringInvoiceItem>();
        RecurringInvoiceItem recurringInvoiceItem = new RecurringInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), "planName", "phaseName", startDate, startDate.plusMonths(1), BigDecimal.ONE, BigDecimal.ONE, this.account.getCurrency());
        resultingItems.add(recurringInvoiceItem);
        resultingItems.add(recurringInvoiceItem);
        try {
            this.fixedAndRecurringInvoiceItemGenerator.safetyBounds(resultingItems, (Multimap)createdItemsPerDayPerSubscription, (InternalTenantContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
        }
        resultingItems.clear();
        for (int i = 0; i < 2; ++i) {
            resultingItems.add(new RecurringInvoiceItem(UUID.randomUUID(), this.clock.getUTCNow(), null, this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), "planName", "phaseName", startDate, startDate.plusMonths(1), BigDecimal.TEN, BigDecimal.ONE, this.account.getCurrency()));
        }
        try {
            this.fixedAndRecurringInvoiceItemGenerator.safetyBounds(resultingItems, (Multimap)createdItemsPerDayPerSubscription, (InternalTenantContext)this.internalCallContext);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
        }
    }
}

