/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.generator.BillingIntervalDetail;
import org.killbill.billing.invoice.generator.InvoiceDateUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInAdvanceBillingIntervalDetail
extends InvoiceTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCalculateFirstBillingCycleDate1() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-01-16");
        LocalDate to = null;
        LocalDate targetDate = new LocalDate();
        int bcd = 17;
        BillingIntervalDetail annualBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 17, BillingPeriod.ANNUAL, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)annualBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-17"));
        BillingIntervalDetail monthlyBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 17, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)monthlyBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-17"));
        BillingIntervalDetail thirtyDaysBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 17, BillingPeriod.THIRTY_DAYS, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)thirtyDaysBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-16"));
    }

    @Test(groups={"fast"})
    public void testCalculateFirstBillingCycleDate2() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-02-16");
        LocalDate to = null;
        LocalDate targetDate = new LocalDate();
        int bcd = 30;
        BillingIntervalDetail annualBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.ANNUAL, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)annualBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-29"));
        BillingIntervalDetail monthlyBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)monthlyBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-29"));
        BillingIntervalDetail thirtyDaysBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.THIRTY_DAYS, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)thirtyDaysBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-16"));
    }

    @Test(groups={"fast"})
    public void testCalculateFirstBillingCycleDate3() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-01-31");
        LocalDate to = null;
        LocalDate targetDate = new LocalDate();
        int bcd = 30;
        BillingIntervalDetail annualBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.ANNUAL, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)annualBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2013-01-30"));
        BillingIntervalDetail monthlyBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)monthlyBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-29"));
        BillingIntervalDetail thirtyDaysBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 30, BillingPeriod.THIRTY_DAYS, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)thirtyDaysBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-31"));
    }

    @Test(groups={"fast"})
    public void testCalculateFirstBillingCycleDate4() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-02-16");
        LocalDate to = null;
        LocalDate targetDate = new LocalDate();
        int bcd = 14;
        BillingIntervalDetail annualBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 14, BillingPeriod.ANNUAL, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)annualBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2013-02-14"));
        BillingIntervalDetail monthlyBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 14, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)monthlyBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-03-14"));
        BillingIntervalDetail thirtyDaysBillingIntervalDetail = new BillingIntervalDetail(from, to, targetDate, 14, BillingPeriod.THIRTY_DAYS, BillingMode.IN_ADVANCE);
        Assert.assertEquals((Object)thirtyDaysBillingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-16"));
    }

    @Test(groups={"fast"})
    public void testNextBCDShouldNotBeInThePast() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-07-16");
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(from, null, new LocalDate(), 15, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate to = billingIntervalDetail.getFirstBillingCycleDate();
        Assert.assertEquals((Object)to, (Object)new LocalDate((Object)"2012-08-15"));
    }

    @Test(groups={"fast"})
    public void testBeforeBCDWithOnOrAfter() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-03-02");
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(from, null, new LocalDate(), 3, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate to = billingIntervalDetail.getFirstBillingCycleDate();
        Assert.assertEquals((Object)to, (Object)new LocalDate((Object)"2012-03-03"));
    }

    @Test(groups={"fast"})
    public void testEqualBCDWithOnOrAfter() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-03-03");
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(from, null, new LocalDate(), 3, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate to = billingIntervalDetail.getFirstBillingCycleDate();
        Assert.assertEquals((Object)to, (Object)new LocalDate((Object)"2012-03-03"));
    }

    @Test(groups={"fast"})
    public void testAfterBCDWithOnOrAfter() throws Exception {
        LocalDate from = new LocalDate((Object)"2012-03-04");
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(from, null, new LocalDate(), 3, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate to = billingIntervalDetail.getFirstBillingCycleDate();
        Assert.assertEquals((Object)to, (Object)new LocalDate((Object)"2012-04-03"));
    }

    @Test(groups={"fast"})
    public void testEffectiveEndDate() throws Exception {
        LocalDate firstBCD = new LocalDate(2012, 7, 16);
        LocalDate targetDate = new LocalDate(2012, 8, 16);
        BillingPeriod billingPeriod = BillingPeriod.MONTHLY;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(firstBCD, null, targetDate, 16, billingPeriod, BillingMode.IN_ADVANCE);
        LocalDate effectiveEndDate = billingIntervalDetail.getEffectiveEndDate();
        Assert.assertEquals((Object)effectiveEndDate, (Object)new LocalDate(2012, 9, 16));
    }

    @Test(groups={"fast"})
    public void testLastBCD() throws Exception {
        LocalDate start = new LocalDate(2012, 7, 16);
        LocalDate endDate = new LocalDate(2012, 9, 15);
        LocalDate targetDate = new LocalDate(2012, 8, 16);
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, endDate, targetDate, 16, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate lastBCD = billingIntervalDetail.getLastBillingCycleDate();
        Assert.assertEquals((Object)lastBCD, (Object)new LocalDate(2012, 8, 16));
    }

    @Test(groups={"fast"})
    public void testLastBCDShouldNotBeBeforePreviousBCD() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-07-16");
        int bcdLocal = 15;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, start, 15, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate lastBCD = billingIntervalDetail.getLastBillingCycleDate();
        Assert.assertEquals((Object)lastBCD, (Object)new LocalDate((Object)"2012-08-15"));
    }

    @Test(groups={"fast"})
    public void testBCD31StartingWith30DayMonth() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-04-30");
        LocalDate targetDate = new LocalDate((Object)"2012-04-30");
        LocalDate end = null;
        int bcdLocal = 31;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, end, targetDate, 31, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate effectiveEndDate = billingIntervalDetail.getEffectiveEndDate();
        Assert.assertEquals((Object)effectiveEndDate, (Object)new LocalDate((Object)"2012-05-31"));
    }

    @Test(groups={"fast"}, description="See https://github.com/killbill/killbill/issues/127#issuecomment-292445089")
    public void testWithBCDLargerThanEndMonth() throws Exception {
        LocalDate startDate = new LocalDate((Object)"2017-01-31");
        LocalDate endDate = null;
        LocalDate targetDate = new LocalDate((Object)"2017-03-31");
        int BCD = 31;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(startDate, endDate, targetDate, BCD, BillingPeriod.MONTHLY, BillingMode.IN_ADVANCE);
        LocalDate firstBillingCycleDate = billingIntervalDetail.getFirstBillingCycleDate();
        LocalDate lastBillingCycleDate = billingIntervalDetail.getLastBillingCycleDate();
        int numberOfWholeBillingPeriods = InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)firstBillingCycleDate, (LocalDate)lastBillingCycleDate, (BillingPeriod)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)numberOfWholeBillingPeriods, (int)3);
    }
}

