/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.generator.BillingIntervalDetail;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInArrearBillingIntervalDetail
extends InvoiceTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testScenarioBCDBeforeStart1() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-01-16");
        int bcd = 13;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 13, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertFalse((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-13"));
        Assert.assertNull((Object)billingIntervalDetail.getEffectiveEndDate());
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-13"));
    }

    @Test(groups={"fast"})
    public void testScenarioBCDBeforeStart2() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-02-13");
        int bcd = 13;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 13, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-13"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-02-13"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-03-13"));
    }

    @Test(groups={"fast"})
    public void testScenarioBCDAEqualsStart1() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-01-19");
        int bcd = 16;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 16, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-16"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-01-16"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-16"));
    }

    @Test(groups={"fast"})
    public void testScenarioBCDAfterStart1() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-01-19");
        int bcd = 25;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 25, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertFalse((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-25"));
        Assert.assertNull((Object)billingIntervalDetail.getEffectiveEndDate());
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-25"));
    }

    @Test(groups={"fast"})
    public void testScenarioBCDAfterStart2() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate end = new LocalDate((Object)"2012-01-19");
        LocalDate targetDate = new LocalDate((Object)"2012-01-25");
        int bcd = 25;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, end, targetDate, 25, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-25"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)end);
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-25"));
    }

    @Test(groups={"fast"})
    public void testScenarioBCDAfterStart3() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-01-25");
        int bcd = 25;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 25, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-25"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-01-25"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-25"));
    }

    @Test(groups={"fast"})
    public void testScenarioEndDateBetweenPeriod1() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate end = new LocalDate((Object)"2012-01-20");
        LocalDate targetDate = new LocalDate((Object)"2012-01-25");
        int bcd = 18;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, end, targetDate, 18, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-01-20"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-18"));
    }

    @Test(groups={"fast"})
    public void testScenarioEndDateBetweenPeriod2() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-01-25");
        int bcd = 18;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 18, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-18"));
    }

    @Test(groups={"fast"})
    public void testScenarioEndDateBetweenPeriod3() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate end = new LocalDate((Object)"2012-01-28");
        LocalDate targetDate = new LocalDate((Object)"2012-01-25");
        int bcd = 18;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, end, targetDate, 18, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-18"));
    }

    @Test(groups={"fast"})
    public void testScenarioTargetDateOnNextBCD1() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate targetDate = new LocalDate((Object)"2012-02-18");
        int bcd = 18;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, null, targetDate, 18, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-02-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-03-18"));
    }

    @Test(groups={"fast"})
    public void testScenarioTargetDateOnNextBCD2() throws Exception {
        LocalDate start = new LocalDate((Object)"2012-01-16");
        LocalDate end = new LocalDate((Object)"2012-02-16");
        LocalDate targetDate = new LocalDate((Object)"2012-02-18");
        int bcd = 18;
        BillingIntervalDetail billingIntervalDetail = new BillingIntervalDetail(start, end, targetDate, 18, BillingPeriod.MONTHLY, BillingMode.IN_ARREAR);
        Assert.assertTrue((boolean)billingIntervalDetail.hasSomethingToBill());
        Assert.assertEquals((Object)billingIntervalDetail.getFirstBillingCycleDate(), (Object)new LocalDate((Object)"2012-01-18"));
        Assert.assertEquals((Object)billingIntervalDetail.getEffectiveEndDate(), (Object)new LocalDate((Object)"2012-02-16"));
        Assert.assertEquals((Object)billingIntervalDetail.getNextBillingCycleDate(), (Object)new LocalDate((Object)"2012-02-18"));
    }
}

