/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.generator.InvoiceDateUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInvoiceDateUtils
extends InvoiceTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testProRationAfterLastBillingCycleDate() throws Exception {
        LocalDate endDate = new LocalDate((Object)"2012-06-02");
        LocalDate previousBillThroughDate = new LocalDate((Object)"2012-03-02");
        BigDecimal proration = InvoiceDateUtils.calculateProRationAfterLastBillingCycleDate((LocalDate)endDate, (LocalDate)previousBillThroughDate, (BillingPeriod)BillingPeriod.MONTHLY);
        Assert.assertEquals((Object)proration, (Object)new BigDecimal("2.967741935"));
    }

    @Test(groups={"fast"})
    public void testCalculateNbOfBillingPeriods() throws Exception {
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 15), (BillingPeriod)BillingPeriod.MONTHLY), (int)1);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 16), (BillingPeriod)BillingPeriod.MONTHLY), (int)2);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 17), (BillingPeriod)BillingPeriod.MONTHLY), (int)2);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 13), (BillingPeriod)BillingPeriod.THIRTY_DAYS), (int)1);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 14), (BillingPeriod)BillingPeriod.THIRTY_DAYS), (int)2);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 9, 15), (BillingPeriod)BillingPeriod.THIRTY_DAYS), (int)2);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 7, 29), (BillingPeriod)BillingPeriod.WEEKLY), (int)1);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 7, 30), (BillingPeriod)BillingPeriod.WEEKLY), (int)2);
        Assert.assertEquals((int)InvoiceDateUtils.calculateNumberOfWholeBillingPeriods((LocalDate)new LocalDate(2012, 7, 16), (LocalDate)new LocalDate(2012, 7, 31), (BillingPeriod)BillingPeriod.WEEKLY), (int)2);
    }

    @Test(groups={"fast"})
    public void testAdvanceByNPeriods() throws Exception {
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)0), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)1), (Object)new LocalDate(2016, 5, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)2), (Object)new LocalDate(2016, 6, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)3), (Object)new LocalDate(2016, 7, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)4), (Object)new LocalDate(2016, 8, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)5), (Object)new LocalDate(2016, 9, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)6), (Object)new LocalDate(2016, 10, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)7), (Object)new LocalDate(2016, 11, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)0), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)1), (Object)new LocalDate(2016, 5, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)2), (Object)new LocalDate(2016, 6, 7));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)3), (Object)new LocalDate(2016, 7, 7));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)4), (Object)new LocalDate(2016, 8, 6));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)5), (Object)new LocalDate(2016, 9, 5));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)6), (Object)new LocalDate(2016, 10, 5));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)7), (Object)new LocalDate(2016, 11, 4));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)0), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)1), (Object)new LocalDate(2016, 4, 15));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)2), (Object)new LocalDate(2016, 4, 22));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)3), (Object)new LocalDate(2016, 4, 29));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)4), (Object)new LocalDate(2016, 5, 6));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)5), (Object)new LocalDate(2016, 5, 13));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)6), (Object)new LocalDate(2016, 5, 20));
        Assert.assertEquals((Object)InvoiceDateUtils.advanceByNPeriods((LocalDate)new LocalDate(2016, 4, 8), (BillingPeriod)BillingPeriod.WEEKLY, (int)7), (Object)new LocalDate(2016, 5, 27));
    }

    @Test(groups={"fast"})
    public void testRecedeByNPeriods() throws Exception {
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)7), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)6), (Object)new LocalDate(2016, 5, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)5), (Object)new LocalDate(2016, 6, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)4), (Object)new LocalDate(2016, 7, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)3), (Object)new LocalDate(2016, 8, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)2), (Object)new LocalDate(2016, 9, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)1), (Object)new LocalDate(2016, 10, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 8), (BillingPeriod)BillingPeriod.MONTHLY, (int)0), (Object)new LocalDate(2016, 11, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)7), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)6), (Object)new LocalDate(2016, 5, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)5), (Object)new LocalDate(2016, 6, 7));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)4), (Object)new LocalDate(2016, 7, 7));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)3), (Object)new LocalDate(2016, 8, 6));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)2), (Object)new LocalDate(2016, 9, 5));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)1), (Object)new LocalDate(2016, 10, 5));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 11, 4), (BillingPeriod)BillingPeriod.THIRTY_DAYS, (int)0), (Object)new LocalDate(2016, 11, 4));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)7), (Object)new LocalDate(2016, 4, 8));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)6), (Object)new LocalDate(2016, 4, 15));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)5), (Object)new LocalDate(2016, 4, 22));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)4), (Object)new LocalDate(2016, 4, 29));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)3), (Object)new LocalDate(2016, 5, 6));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)2), (Object)new LocalDate(2016, 5, 13));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)1), (Object)new LocalDate(2016, 5, 20));
        Assert.assertEquals((Object)InvoiceDateUtils.recedeByNPeriods((LocalDate)new LocalDate(2016, 5, 27), (BillingPeriod)BillingPeriod.WEEKLY, (int)0), (Object)new LocalDate(2016, 5, 27));
    }
}

