/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.generator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.generator.InvoiceWithMetadata;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceWithMetadata
extends InvoiceTestSuiteNoDB {
    private Account account;
    private SubscriptionBase subscription;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        super.beforeMethod();
        try {
            this.account = this.invoiceUtil.createAccount(this.callContext);
            this.subscription = this.invoiceUtil.createSubscription();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"fast"})
    public void testWith$0RecurringItem() {
        LocalDate invoiceDate = new LocalDate(2016, 11, 15);
        DefaultInvoice originalInvoice = new DefaultInvoice(this.account.getId(), invoiceDate, this.account.getCurrency());
        MockPlan plan = new MockPlan("my-plan");
        MockInternationalPrice price = new MockInternationalPrice(new DefaultPrice[]{new DefaultPrice(BigDecimal.TEN, this.account.getCurrency())});
        MockPlanPhase planPhase = new MockPlanPhase(price, null, BillingPeriod.MONTHLY, PhaseType.EVERGREEN);
        BillingEvent event = this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, invoiceDate.toDateTimeAtStartOfDay(), (Plan)plan, (PlanPhase)planPhase, null, BigDecimal.ZERO, this.account.getCurrency(), planPhase.getRecurring().getBillingPeriod(), 1, BillingMode.IN_ADVANCE, "Billing Event Desc", 1L, SubscriptionBaseTransitionType.CREATE);
        RecurringInvoiceItem invoiceItem = new RecurringInvoiceItem(UUID.randomUUID(), invoiceDate.toDateTimeAtStartOfDay(), originalInvoice.getId(), this.account.getId(), this.subscription.getBundleId(), this.subscription.getId(), event.getPlan().getName(), event.getPlanPhase().getName(), invoiceDate, invoiceDate.plusMonths(1), BigDecimal.ZERO, BigDecimal.ZERO, this.account.getCurrency());
        originalInvoice.addInvoiceItem((InvoiceItem)invoiceItem);
        HashMap<UUID, InvoiceWithMetadata.SubscriptionFutureNotificationDates> perSubscriptionFutureNotificationDates = new HashMap<UUID, InvoiceWithMetadata.SubscriptionFutureNotificationDates>();
        InvoiceWithMetadata.SubscriptionFutureNotificationDates subscriptionFutureNotificationDates = new InvoiceWithMetadata.SubscriptionFutureNotificationDates(BillingMode.IN_ADVANCE);
        subscriptionFutureNotificationDates.updateNextRecurringDateIfRequired(invoiceDate.plusMonths(1));
        perSubscriptionFutureNotificationDates.put(this.subscription.getId(), subscriptionFutureNotificationDates);
        InvoiceWithMetadata invoiceWithMetadata = new InvoiceWithMetadata(originalInvoice, perSubscriptionFutureNotificationDates);
        DefaultInvoice resultingInvoice = invoiceWithMetadata.getInvoice();
        Assert.assertNotNull((Object)resultingInvoice);
        Assert.assertEquals((int)resultingInvoice.getInvoiceItems().size(), (int)1);
        Assert.assertEquals((int)((InvoiceItem)resultingInvoice.getInvoiceItems().get(0)).getAmount().compareTo(BigDecimal.ZERO), (int)0);
        Map dateMap = invoiceWithMetadata.getPerSubscriptionFutureNotificationDates();
        InvoiceWithMetadata.SubscriptionFutureNotificationDates futureNotificationDates = (InvoiceWithMetadata.SubscriptionFutureNotificationDates)dateMap.get(this.subscription.getId());
        Assert.assertNotNull((Object)futureNotificationDates.getNextRecurringDate());
        Assert.assertEquals((int)futureNotificationDates.getNextRecurringDate().compareTo((ReadablePartial)invoiceDate.plusMonths(1)), (int)0);
    }
}

