/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.glue;

import com.google.inject.Module;
import java.math.BigDecimal;
import java.util.HashSet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.GuicyKillbillTestNoDBModule;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.currency.api.CurrencyConversion;
import org.killbill.billing.currency.api.CurrencyConversionApi;
import org.killbill.billing.currency.api.CurrencyConversionException;
import org.killbill.billing.currency.api.Rate;
import org.killbill.billing.invoice.dao.InvoiceDao;
import org.killbill.billing.invoice.dao.MockInvoiceDao;
import org.killbill.billing.invoice.glue.TestInvoiceModule;
import org.killbill.billing.mock.glue.MockAccountModule;
import org.killbill.billing.mock.glue.MockNonEntityDaoModule;
import org.killbill.billing.mock.glue.MockTagModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.mockito.Mockito;

public class TestInvoiceModuleNoDB
extends TestInvoiceModule {
    public TestInvoiceModuleNoDB(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void installInvoiceDao() {
        this.bind(InvoiceDao.class).to(MockInvoiceDao.class);
    }

    public void configure() {
        super.configure();
        this.install((Module)new GuicyKillbillTestNoDBModule(this.configSource));
        this.install((Module)new MockNonEntityDaoModule(this.configSource));
        this.install((Module)new MockTagModule(this.configSource));
        this.install((Module)new MockAccountModule(this.configSource));
        this.installCurrencyConversionApi();
    }

    private void installCurrencyConversionApi() {
        CurrencyConversionApi currencyConversionApi = (CurrencyConversionApi)Mockito.mock(CurrencyConversionApi.class);
        CurrencyConversion currencyConversion = (CurrencyConversion)Mockito.mock(CurrencyConversion.class);
        HashSet<1> rates = new HashSet<1>();
        rates.add(new Rate(){

            public Currency getBaseCurrency() {
                return Currency.USD;
            }

            public Currency getCurrency() {
                return Currency.BRL;
            }

            public BigDecimal getValue() {
                return new BigDecimal("0.4234");
            }

            public DateTime getConversionDate() {
                return new DateTime(DateTimeZone.UTC);
            }
        });
        Mockito.when((Object)currencyConversion.getRates()).thenReturn(rates);
        try {
            Mockito.when((Object)currencyConversionApi.getCurrencyConversion((Currency)Mockito.any(), (DateTime)Mockito.any())).thenReturn((Object)currencyConversion);
        }
        catch (CurrencyConversionException e) {
            throw new RuntimeException(e);
        }
        this.bind(CurrencyConversionApi.class).toInstance((Object)currencyConversionApi);
    }
}

