/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.model;

import java.math.BigDecimal;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.model.ExternalChargeInvoiceItem;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExternalChargeInvoiceItem
extends InvoiceTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testEquals() throws Exception {
        UUID id = UUID.randomUUID();
        UUID invoiceId = UUID.randomUUID();
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        String description = UUID.randomUUID().toString();
        LocalDate effectiveDate = this.clock.getUTCToday();
        BigDecimal amount = BigDecimal.TEN;
        Currency currency = Currency.GBP;
        ExternalChargeInvoiceItem item = new ExternalChargeInvoiceItem(id, invoiceId, accountId, bundleId, description, effectiveDate, amount, currency);
        Assert.assertEquals((Object)item.getAccountId(), (Object)accountId);
        Assert.assertEquals((int)item.getAmount().compareTo(amount), (int)0);
        Assert.assertEquals((Object)item.getBundleId(), (Object)bundleId);
        Assert.assertEquals((Object)item.getCurrency(), (Object)currency);
        Assert.assertEquals((Object)item.getInvoiceItemType(), (Object)InvoiceItemType.EXTERNAL_CHARGE);
        Assert.assertEquals((String)item.getDescription(), (String)description);
        Assert.assertNull((Object)item.getPlanName());
        Assert.assertNull((Object)item.getEndDate());
        Assert.assertNull((Object)item.getLinkedItemId());
        Assert.assertNull((Object)item.getPhaseName());
        Assert.assertNull((Object)item.getRate());
        Assert.assertNull((Object)item.getSubscriptionId());
        Assert.assertEquals((Object)item, (Object)item);
        ExternalChargeInvoiceItem otherItem = new ExternalChargeInvoiceItem(id, invoiceId, UUID.randomUUID(), bundleId, description, effectiveDate, amount, currency);
        Assert.assertNotEquals((Object)otherItem, (Object)item);
        ExternalChargeInvoiceItem itemBefore = new ExternalChargeInvoiceItem(id, invoiceId, accountId, bundleId, description, effectiveDate.minusDays(1), amount, currency);
        Assert.assertFalse((boolean)itemBefore.matches((Object)item));
        ExternalChargeInvoiceItem itemAfter = new ExternalChargeInvoiceItem(id, invoiceId, accountId, bundleId, description, effectiveDate.plusDays(1), amount, currency);
        Assert.assertFalse((boolean)itemAfter.matches((Object)item));
    }
}

