/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.model;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.model.RecurringInvoiceItemData;
import org.killbill.billing.invoice.model.RecurringInvoiceItemDataWithNextBillingCycleDate;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRecurringInArrear
extends InvoiceTestSuiteNoDB {
    private static final DateTimeZone TIMEZONE = DateTimeZone.forID((String)"Pacific/Pitcairn");
    private static final BillingPeriod BILLING_PERIOD = BillingPeriod.MONTHLY;

    @Test(groups={"fast"})
    public void testItemShouldNotStartInThePast() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = new LocalDate(2012, 7, 16);
        LocalDate targetDate = new LocalDate(2012, 7, 16);
        int billingCycleDayLocal = 15;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        this.verifyInvoiceItems(startDate, endDate, targetDate, 15, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithNoEndDate() throws Exception {
        LocalDate startDate = new LocalDate((Object)new DateTime((Object)"2012-07-17T02:25:33.000Z", DateTimeZone.UTC), TIMEZONE);
        LocalDate endDate = null;
        LocalDate targetDate = new LocalDate(2012, 7, 16);
        int billingCycleDayLocal = 15;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        this.verifyInvoiceItems(startDate, endDate, targetDate, 15, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDBeforeStartDay() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = new LocalDate(2012, 8, 16);
        LocalDate targetDate = new LocalDate(2012, 7, 16);
        int billingCycleDayLocal = 15;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        this.verifyInvoiceItems(startDate, endDate, targetDate, 15, BILLING_PERIOD, expectedDates);
        LocalDate targetDate2 = new LocalDate(2012, 8, 15);
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 8, 15));
        this.verifyInvoiceItems(startDate, endDate, targetDate2, 15, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDEqualsStartDay() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = new LocalDate(2012, 8, 16);
        LocalDate targetDate = new LocalDate(2012, 7, 16);
        int billingCycleDayLocal = 16;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        this.verifyInvoiceItems(startDate, endDate, targetDate, 16, BILLING_PERIOD, expectedDates);
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 8, 16));
        LocalDate targetDate2 = new LocalDate(2012, 8, 16);
        this.verifyInvoiceItems(startDate, endDate, targetDate2, 16, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDAfterStartDay() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = new LocalDate(2012, 8, 16);
        LocalDate targetDate = new LocalDate(2012, 7, 16);
        int billingCycleDayLocal = 17;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        this.verifyInvoiceItems(startDate, endDate, targetDate, 17, BILLING_PERIOD, expectedDates);
        LocalDate targetDate2 = new LocalDate(2012, 7, 17);
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 7, 17));
        this.verifyInvoiceItems(startDate, endDate, targetDate2, 17, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDBeforeStartDayWithTargetDateIn3Months() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = null;
        LocalDate targetDate = new LocalDate(2012, 10, 16);
        int billingCycleDayLocal = 15;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 8, 15));
        expectedDates.put(new LocalDate(2012, 8, 15), new LocalDate(2012, 9, 15));
        expectedDates.put(new LocalDate(2012, 9, 15), new LocalDate(2012, 10, 15));
        this.verifyInvoiceItems(startDate, endDate, targetDate, 15, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDEqualsStartDayWithTargetDateIn3Months() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = null;
        LocalDate targetDate = new LocalDate(2012, 10, 16);
        int billingCycleDayLocal = 16;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 8, 16));
        expectedDates.put(new LocalDate(2012, 8, 16), new LocalDate(2012, 9, 16));
        expectedDates.put(new LocalDate(2012, 9, 16), new LocalDate(2012, 10, 16));
        this.verifyInvoiceItems(startDate, endDate, targetDate, 16, BILLING_PERIOD, expectedDates);
    }

    @Test(groups={"fast"})
    public void testCalculateSimpleInvoiceItemWithBCDAfterStartDayWithTargetDateIn3Months() throws Exception {
        LocalDate startDate = new LocalDate(2012, 7, 16);
        LocalDate endDate = null;
        LocalDate targetDate = new LocalDate(2012, 10, 16);
        int billingCycleDayLocal = 17;
        LinkedHashMap<LocalDate, LocalDate> expectedDates = new LinkedHashMap<LocalDate, LocalDate>();
        expectedDates.put(new LocalDate(2012, 7, 16), new LocalDate(2012, 7, 17));
        expectedDates.put(new LocalDate(2012, 7, 17), new LocalDate(2012, 8, 17));
        expectedDates.put(new LocalDate(2012, 8, 17), new LocalDate(2012, 9, 17));
        this.verifyInvoiceItems(startDate, endDate, targetDate, 17, BILLING_PERIOD, expectedDates);
    }

    private void verifyInvoiceItems(LocalDate startDate, LocalDate endDate, LocalDate targetDate, int billingCycleDayLocal, BillingPeriod billingPeriod, LinkedHashMap<LocalDate, LocalDate> expectedDates) throws InvalidDateSequenceException {
        RecurringInvoiceItemDataWithNextBillingCycleDate invoiceItemsWithDates = this.fixedAndRecurringInvoiceItemGenerator.generateInvoiceItemData(startDate, endDate, targetDate, billingCycleDayLocal, billingPeriod, BillingMode.IN_ARREAR);
        List invoiceItems = invoiceItemsWithDates.getItemData();
        int i = 0;
        for (LocalDate periodStartDate : expectedDates.keySet()) {
            Assert.assertEquals((Object)((RecurringInvoiceItemData)invoiceItems.get(i)).getStartDate(), (Object)periodStartDate);
            Assert.assertEquals((Object)((RecurringInvoiceItemData)invoiceItems.get(i)).getEndDate(), (Object)expectedDates.get(periodStartDate));
            Assert.assertTrue((((RecurringInvoiceItemData)invoiceItems.get(0)).getNumberOfCycles().compareTo(BigDecimal.ONE) <= 0 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertEquals((int)invoiceItems.size(), (int)i);
    }
}

