/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.notification;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.invoice.notification.NextBillingDateNotificationKey;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNextBillingDateNotificationKey {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Test(groups={"fast"})
    public void testBasicWithUUIDKey() throws Exception {
        UUID uuidKey = UUID.randomUUID();
        DateTime targetDate = new DateTime();
        Boolean isDryRunForInvoiceNotification = Boolean.FALSE;
        NextBillingDateNotificationKey key = new NextBillingDateNotificationKey(uuidKey, null, targetDate, isDryRunForInvoiceNotification);
        String json = mapper.writeValueAsString((Object)key);
        NextBillingDateNotificationKey result = (NextBillingDateNotificationKey)mapper.readValue(json, NextBillingDateNotificationKey.class);
        Assert.assertEquals((Object)result.getUuidKey(), (Object)uuidKey);
        Assert.assertEquals((int)result.getTargetDate().compareTo((ReadableInstant)targetDate), (int)0);
        Assert.assertEquals((Object)result.isDryRunForInvoiceNotification(), (Object)isDryRunForInvoiceNotification);
    }

    @Test(groups={"fast"})
    public void testBasicWithUUIDKeys() throws Exception {
        UUID uuidKey1 = UUID.randomUUID();
        UUID uuidKey2 = UUID.randomUUID();
        DateTime targetDate = new DateTime();
        Boolean isDryRunForInvoiceNotification = Boolean.FALSE;
        NextBillingDateNotificationKey key = new NextBillingDateNotificationKey(null, (Iterable)ImmutableList.of((Object)uuidKey1, (Object)uuidKey2), targetDate, isDryRunForInvoiceNotification);
        String json = mapper.writeValueAsString((Object)key);
        NextBillingDateNotificationKey result = (NextBillingDateNotificationKey)mapper.readValue(json, NextBillingDateNotificationKey.class);
        Assert.assertNull((Object)result.getUuidKey());
        Assert.assertEquals((int)result.getTargetDate().compareTo((ReadableInstant)targetDate), (int)0);
        Assert.assertEquals((Object)result.isDryRunForInvoiceNotification(), (Object)isDryRunForInvoiceNotification);
        Assert.assertNotNull((Object)result.getUuidKeys());
        Assert.assertTrue((boolean)Iterables.contains((Iterable)result.getUuidKeys(), (Object)uuidKey1));
        Assert.assertTrue((boolean)Iterables.contains((Iterable)result.getUuidKeys(), (Object)uuidKey2));
    }

    @Test(groups={"fast"})
    public void testWithMissingFields() throws Exception {
        String json = "{\"uuidKey\":\"a38c363f-b25b-4287-8ebc-55964e116d2f\"}";
        NextBillingDateNotificationKey result = (NextBillingDateNotificationKey)mapper.readValue("{\"uuidKey\":\"a38c363f-b25b-4287-8ebc-55964e116d2f\"}", NextBillingDateNotificationKey.class);
        Assert.assertEquals((String)result.getUuidKey().toString(), (String)"a38c363f-b25b-4287-8ebc-55964e116d2f");
        Assert.assertNull((Object)result.getTargetDate());
        Assert.assertNull((Object)result.isDryRunForInvoiceNotification());
        Assert.assertNotNull((Object)result.getUuidKeys());
        Assert.assertEquals((String)((UUID)result.getUuidKeys().iterator().next()).toString(), (String)"a38c363f-b25b-4287-8ebc-55964e116d2f");
    }
}

