/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.notification;

import com.google.common.collect.ImmutableList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.notification.NextBillingDateNotificationKey;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNextBillingDateNotifier
extends InvoiceTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testInvoiceNotifier() throws Exception {
        Account account = this.invoiceUtil.createAccount(this.callContext);
        Long accountRecordId = this.nonEntityDao.retrieveAccountRecordIdFromObject(account.getId(), ObjectType.ACCOUNT, null);
        SubscriptionBase subscription = this.invoiceUtil.createSubscription();
        UUID subscriptionId = subscription.getId();
        DateTime now = this.clock.getUTCNow();
        NotificationQueue nextBillingQueue = this.notificationQueueService.getNotificationQueue("invoice-service", "next-billing-date-queue");
        nextBillingQueue.recordFutureNotification(now, (NotificationEvent)new NextBillingDateNotificationKey(null, (Iterable)ImmutableList.of((Object)subscriptionId), now, Boolean.FALSE), this.internalCallContext.getUserToken(), accountRecordId, this.internalCallContext.getTenantRecordId());
        this.clock.setDeltaFromReality(3000L);
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return TestNextBillingDateNotifier.this.testInvoiceNotificationQListener.getEventCount() == 1;
            }
        });
        Assert.assertEquals((int)this.testInvoiceNotificationQListener.getEventCount(), (int)1);
        Assert.assertEquals((Object)this.testInvoiceNotificationQListener.getLatestSubscriptionId(), (Object)subscriptionId);
    }
}

