/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceInternalApi;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.dao.InvoiceDao;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceTestUtils {
    private InvoiceTestUtils() {
    }

    public static Invoice createAndPersistInvoice(TestInvoiceHelper testInvoiceHelper, InvoiceDao invoiceDao, Clock clock, BigDecimal amount, Currency currency, InternalCallContext internalCallContext) {
        try {
            return InvoiceTestUtils.createAndPersistInvoice(testInvoiceHelper, invoiceDao, clock, (Iterable<BigDecimal>)ImmutableList.of((Object)amount), currency, internalCallContext);
        }
        catch (EntityPersistenceException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public static Invoice createAndPersistInvoice(TestInvoiceHelper testInvoiceHelper, InvoiceDao invoiceDao, Clock clock, Iterable<BigDecimal> amounts, Currency currency, InternalCallContext internalCallContext) throws EntityPersistenceException {
        UUID accountId;
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        UUID invoiceId = UUID.randomUUID();
        try {
            Account account = testInvoiceHelper.createAccount(internalCallContext.toCallContext(null));
            accountId = account.getId();
        }
        catch (AccountApiException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
        Mockito.when((Object)invoice.getId()).thenReturn((Object)invoiceId);
        Mockito.when((Object)invoice.getAccountId()).thenReturn((Object)accountId);
        Mockito.when((Object)invoice.getInvoiceDate()).thenReturn((Object)clock.getUTCToday());
        Mockito.when((Object)invoice.getTargetDate()).thenReturn((Object)clock.getUTCToday());
        Mockito.when((Object)invoice.getCurrency()).thenReturn((Object)currency);
        Mockito.when((Object)invoice.isMigrationInvoice()).thenReturn((Object)false);
        Mockito.when((Object)invoice.getStatus()).thenReturn((Object)InvoiceStatus.COMMITTED);
        ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
        ArrayList<InvoiceItemModelDao> invoiceModelItems = new ArrayList<InvoiceItemModelDao>();
        for (BigDecimal amount : amounts) {
            InvoiceItem invoiceItem = InvoiceTestUtils.createInvoiceItem(clock, invoiceId, accountId, amount, currency);
            invoiceModelItems.add(new InvoiceItemModelDao(invoiceItem));
            invoiceItems.add(invoiceItem);
        }
        Mockito.when((Object)invoice.getInvoiceItems()).thenReturn(invoiceItems);
        InvoiceModelDao invoiceModelDao = new InvoiceModelDao(invoice);
        invoiceModelDao.addInvoiceItems(invoiceModelItems);
        invoiceDao.createInvoices((List)ImmutableList.of((Object)invoiceModelDao), internalCallContext);
        return invoice;
    }

    public static InvoiceItem createInvoiceItem(Clock clock, UUID invoiceId, UUID accountId, BigDecimal amount, Currency currency) {
        return new FixedPriceInvoiceItem(invoiceId, accountId, UUID.randomUUID(), UUID.randomUUID(), "charge back test", "charge back phase", clock.getUTCToday(), amount, currency);
    }

    public static InvoicePayment createAndPersistPayment(InvoiceInternalApi invoicePaymentApi, Clock clock, UUID invoiceId, BigDecimal amount, Currency currency, InternalCallContext callContext) throws InvoiceApiException {
        InvoicePayment payment = (InvoicePayment)Mockito.mock(InvoicePayment.class);
        Mockito.when((Object)payment.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)payment.getType()).thenReturn((Object)InvoicePaymentType.ATTEMPT);
        Mockito.when((Object)payment.getInvoiceId()).thenReturn((Object)invoiceId);
        Mockito.when((Object)payment.getPaymentId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)payment.getPaymentCookieId()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)payment.getPaymentDate()).thenReturn((Object)clock.getUTCNow());
        Mockito.when((Object)payment.getAmount()).thenReturn((Object)amount);
        Mockito.when((Object)payment.getCurrency()).thenReturn((Object)currency);
        Mockito.when((Object)payment.getProcessedCurrency()).thenReturn((Object)currency);
        Mockito.when((Object)payment.isSuccess()).thenReturn((Object)true);
        invoicePaymentApi.recordPaymentAttemptCompletion(payment.getInvoiceId(), payment.getAmount(), payment.getCurrency(), payment.getProcessedCurrency(), payment.getPaymentId(), payment.getPaymentCookieId(), payment.getPaymentDate(), payment.isSuccess().booleanValue(), callContext);
        return payment;
    }
}

