/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.model.RecurringInvoiceItemData;
import org.killbill.billing.invoice.model.RecurringInvoiceItemDataWithNextBillingCycleDate;
import org.testng.Assert;

public abstract class ProRationTestBase
extends InvoiceTestSuiteNoDB {
    protected abstract BillingPeriod getBillingPeriod();

    protected abstract BillingMode getBillingMode();

    protected void testCalculateNumberOfBillingCycles(LocalDate startDate, LocalDate targetDate, int billingCycleDay, BigDecimal expectedValue) throws InvalidDateSequenceException {
        try {
            BigDecimal numberOfBillingCycles = this.calculateNumberOfBillingCycles(startDate, targetDate, billingCycleDay);
            Assert.assertEquals((int)numberOfBillingCycles.compareTo(expectedValue), (int)0, (String)("Actual: " + numberOfBillingCycles.toString() + "; expected: " + expectedValue.toString()));
        }
        catch (InvalidDateSequenceException idse) {
            throw idse;
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    protected void testCalculateNumberOfBillingCycles(LocalDate startDate, LocalDate endDate, LocalDate targetDate, int billingCycleDay, BigDecimal expectedValue) throws InvalidDateSequenceException {
        try {
            BigDecimal numberOfBillingCycles = this.calculateNumberOfBillingCycles(startDate, endDate, targetDate, billingCycleDay);
            Assert.assertEquals((int)numberOfBillingCycles.compareTo(expectedValue), (int)0, (String)("Actual: " + numberOfBillingCycles.toString() + "; expected: " + expectedValue.toString()));
        }
        catch (InvalidDateSequenceException idse) {
            throw idse;
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    protected BigDecimal calculateNumberOfBillingCycles(LocalDate startDate, LocalDate endDate, LocalDate targetDate, int billingCycleDay) throws InvalidDateSequenceException {
        RecurringInvoiceItemDataWithNextBillingCycleDate items = this.fixedAndRecurringInvoiceItemGenerator.generateInvoiceItemData(startDate, endDate, targetDate, billingCycleDay, this.getBillingPeriod(), this.getBillingMode());
        BigDecimal numberOfBillingCycles = TestInvoiceHelper.ZERO;
        for (RecurringInvoiceItemData item : items.getItemData()) {
            numberOfBillingCycles = numberOfBillingCycles.add(item.getNumberOfCycles());
        }
        return numberOfBillingCycles;
    }

    protected BigDecimal calculateNumberOfBillingCycles(LocalDate startDate, LocalDate targetDate, int billingCycleDay) throws InvalidDateSequenceException {
        RecurringInvoiceItemDataWithNextBillingCycleDate items = this.fixedAndRecurringInvoiceItemGenerator.generateInvoiceItemData(startDate, null, targetDate, billingCycleDay, this.getBillingPeriod(), this.getBillingMode());
        BigDecimal numberOfBillingCycles = TestInvoiceHelper.ZERO;
        for (RecurringInvoiceItemData item : items.getItemData()) {
            numberOfBillingCycles = numberOfBillingCycles.add(item.getNumberOfCycles());
        }
        return numberOfBillingCycles;
    }
}

