/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public abstract class GenericProRationTestBase
extends ProRationInAdvanceTestBase {
    protected abstract BigDecimal getDaysInTestPeriod();

    @Test(groups={"fast"})
    public void testSinglePlan_OnStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        this.testCalculateNumberOfBillingCycles(startDate, startDate, 15, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_LessThanOnePeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 1);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_OnePeriodLessADayAfterStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod()).plusDays(-1);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_ExactlyOnePeriodAfterStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod());
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_SlightlyMoreThanOnePeriodAfterStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod()).plusDays(1);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_CrossingYearBoundary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 12, 15);
        LocalDate oneCycleLater = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod());
        this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater.plusDays(-1), 15, TestInvoiceHelper.ONE);
        this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater, 15, TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater.plusDays(1), 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_StartingMidFebruary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod());
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_StartingMidFebruaryOfLeapYear() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 2, 15);
        LocalDate targetDate = startDate.plus((ReadablePeriod)this.getBillingPeriod().getPeriod());
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_MovingForwardThroughTime() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 31);
        BigDecimal expectedValue = TestInvoiceHelper.ONE;
        for (int i = 1; i <= 12; ++i) {
            LocalDate oneCycleLater = startDate;
            for (int j = 0; j < i; ++j) {
                oneCycleLater = oneCycleLater.plus((ReadablePeriod)this.getBillingPeriod().getPeriod());
            }
            this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater.plusDays(-1), 31, expectedValue);
            expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
            this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater, 31, expectedValue);
            this.testCalculateNumberOfBillingCycles(startDate, oneCycleLater.plusDays(1), 31, expectedValue);
        }
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateInStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateInSubscriptionPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 7);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateOnEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 15);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateAfterEndDateButInFirstBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateAtEndOfFirstBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testCancelledBeforeOnePeriod_TargetDateAfterFirstBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 5);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(this.getDaysInTestPeriod(), 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }
}

