/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance;

import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.ProRationTestBase;
import org.testng.annotations.Test;

public class TestValidationProRation
extends ProRationTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.MONTHLY;
    }

    protected BillingMode getBillingMode() {
        return BillingMode.IN_ADVANCE;
    }

    @Test(groups={"fast"}, expectedExceptions={InvalidDateSequenceException.class})
    public void testTargetStartEnd() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 30);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 3, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 15);
        this.calculateNumberOfBillingCycles(startDate, endDate, targetDate, 15);
    }

    @Test(groups={"fast"}, expectedExceptions={InvalidDateSequenceException.class})
    public void testTargetEndStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 4, 30);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 3, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 15);
        this.calculateNumberOfBillingCycles(startDate, endDate, targetDate, 15);
    }

    @Test(groups={"fast"}, expectedExceptions={InvalidDateSequenceException.class})
    public void testEndTargetStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 3, 30);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 15);
        this.calculateNumberOfBillingCycles(startDate, endDate, targetDate, 15);
    }

    @Test(groups={"fast"}, expectedExceptions={InvalidDateSequenceException.class})
    public void testEndStartTarget() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 30);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 1, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 15);
        this.calculateNumberOfBillingCycles(startDate, endDate, targetDate, 15);
    }

    @Test(groups={"fast"}, expectedExceptions={InvalidDateSequenceException.class})
    public void testTargetStart() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 4, 30);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 15);
        this.calculateNumberOfBillingCycles(startDate, targetDate, 15);
    }
}

