/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance.annual;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public class TestProRation
extends ProRationInAdvanceTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.ANNUAL;
    }

    @Test(groups={"fast"})
    public void testSinglePlan_PrecedingProRation() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 31);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 24);
        BigDecimal expectedValue = TestInvoiceHelper.THREE_HUNDRED_AND_FOURTY_NINE.divide(TestInvoiceHelper.THREE_HUNDRED_AND_SIXTY_FIVE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_PrecedingProRation_CrossingYearBoundary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 12, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 1, 13);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.THREE_HUNDRED_AND_FIFTY_FOUR.divide(TestInvoiceHelper.THREE_HUNDRED_AND_SIXTY_FIVE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 4, expectedValue);
    }

    @Test(groups={"fast"})
    public void testSinglePlanDoubleProRation() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 10);
        LocalDate endDate = this.invoiceUtil.buildDate(2012, 3, 4);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 4, 5);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.SEVEN.divide(TestInvoiceHelper.THREE_HUNDRED_AND_SIXTY_FIVE, 4)).add(TestInvoiceHelper.FORTY_SEVEN.divide(TestInvoiceHelper.THREE_HUNDRED_AND_SIXTY_SIX, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, expectedValue);
    }
}

