/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance.monthly;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public class TestLeadingProRation
extends ProRationInAdvanceTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.MONTHLY;
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_Evergreen_TargetDateOnStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 1);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_Evergreen_TargetDateInProRationPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 4);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_Evergreen_TargetDateOnFirstBillingDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.ONE);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_Evergreen_TargetDateAfterFirstBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.THREE);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateOnStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateInProRationPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 4);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateOnFirstBillingDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 2, 13);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.ONE);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateInFinalBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 10);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateOnEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 13);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }

    @Test(groups={"fast"})
    public void testLeadingProRation_WithEndDate_TargetDateAfterEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 10);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 13);
        BigDecimal expectedValue = TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.THIRTY_ONE, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 13, expectedValue);
    }
}

