/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance.monthly;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public class TestProRation
extends ProRationInAdvanceTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.MONTHLY;
    }

    @Test(groups={"fast"})
    public void testSinglePlan_WithPhaseChange() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 10);
        LocalDate phaseChangeDate = this.invoiceUtil.buildDate(2011, 2, 24);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 6);
        this.testCalculateNumberOfBillingCycles(startDate, phaseChangeDate, targetDate, 10, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(phaseChangeDate, targetDate, 10, TestInvoiceHelper.ONE_HALF);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_WithPhaseChange_BeforeBillCycleDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 3);
        LocalDate phaseChangeDate = this.invoiceUtil.buildDate(2011, 2, 17);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 1);
        this.testCalculateNumberOfBillingCycles(startDate, phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_HALF);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_WithPhaseChange_OnBillCycleDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 3);
        LocalDate phaseChangeDate = this.invoiceUtil.buildDate(2011, 2, 17);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 3);
        this.testCalculateNumberOfBillingCycles(startDate, phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_AND_A_HALF);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_WithPhaseChange_AfterBillCycleDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 3);
        LocalDate phaseChangeDate = this.invoiceUtil.buildDate(2011, 2, 17);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 4);
        this.testCalculateNumberOfBillingCycles(startDate, phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(phaseChangeDate, targetDate, 3, TestInvoiceHelper.ONE_AND_A_HALF);
    }

    @Test(groups={"fast"})
    public void testPlanChange_WithChangeOfBillCycleDayToLaterDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate planChangeDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 1);
        this.testCalculateNumberOfBillingCycles(startDate, planChangeDate, targetDate, 1, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(planChangeDate, targetDate, 15, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testPlanChange_WithChangeOfBillCycleDayToEarlierDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 20);
        LocalDate planChangeDate = this.invoiceUtil.buildDate(2011, 3, 6);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 9);
        this.testCalculateNumberOfBillingCycles(startDate, planChangeDate, targetDate, 20, TestInvoiceHelper.ONE_HALF);
        this.testCalculateNumberOfBillingCycles(planChangeDate, targetDate, 6, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_CrossingYearBoundary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 12, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 16);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_LeapYear_StartingMidFebruary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 2, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 3, 15);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_LeapYear_StartingBeforeFebruary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 1, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 2, 3);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 15, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_LeapYear_IncludingAllOfFebruary() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 1, 30);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 3, 1);
        this.testCalculateNumberOfBillingCycles(startDate, targetDate, 30, TestInvoiceHelper.TWO);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_ChangeBCDTo31() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate planChangeDate = this.invoiceUtil.buildDate(2011, 2, 14);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 1);
        BigDecimal expectedValue = TestInvoiceHelper.THIRTEEN.divide(TestInvoiceHelper.TWENTY_EIGHT, 4);
        this.testCalculateNumberOfBillingCycles(startDate, planChangeDate, targetDate, 1, expectedValue);
        expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(planChangeDate, targetDate, 31, expectedValue);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_ChangeBCD() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 1);
        LocalDate planChangeDate = this.invoiceUtil.buildDate(2011, 2, 14);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 1);
        BigDecimal expectedValue = TestInvoiceHelper.THIRTEEN.divide(TestInvoiceHelper.TWENTY_EIGHT, 4);
        this.testCalculateNumberOfBillingCycles(startDate, planChangeDate, targetDate, 1, expectedValue);
        expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.THIRTEEN.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(planChangeDate, targetDate, 27, expectedValue);
    }

    @Test(groups={"fast"})
    public void testSinglePlan_LeapYearFebruaryProRation() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2012, 2, 1);
        LocalDate endDate = this.invoiceUtil.buildDate(2012, 2, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2012, 2, 19);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.TWENTY_NINE, 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 1, expectedValue);
    }

    @Test(groups={"fast"})
    public void testPlanChange_BeforeBillingDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 7);
        LocalDate changeDate = this.invoiceUtil.buildDate(2011, 2, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 21);
        BigDecimal expectedValue = TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.TWENTY_EIGHT, 4);
        this.testCalculateNumberOfBillingCycles(startDate, changeDate, targetDate, 7, expectedValue);
        this.testCalculateNumberOfBillingCycles(changeDate, targetDate, 15, TestInvoiceHelper.THREE);
    }

    @Test(groups={"fast"})
    public void testPlanChange_OnBillingDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 7);
        LocalDate changeDate = this.invoiceUtil.buildDate(2011, 3, 7);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 21);
        this.testCalculateNumberOfBillingCycles(startDate, changeDate, targetDate, 7, TestInvoiceHelper.ONE);
        BigDecimal expectedValue = TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.TWENTY_EIGHT, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(changeDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testPlanChange_AfterBillingDay() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 2, 7);
        LocalDate changeDate = this.invoiceUtil.buildDate(2011, 3, 10);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 21);
        BigDecimal expectedValue = BigDecimal.ONE.add(TestInvoiceHelper.THREE.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, changeDate, targetDate, 7, expectedValue);
        expectedValue = TestInvoiceHelper.FIVE.divide(TestInvoiceHelper.TWENTY_EIGHT, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(changeDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testPlanChange_DoubleProRation() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 31);
        LocalDate planChangeDate = this.invoiceUtil.buildDate(2011, 3, 10);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 21);
        BigDecimal expectedValue = TestInvoiceHelper.SEVEN.divide(TestInvoiceHelper.THIRTY_ONE, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        expectedValue = expectedValue.add(TestInvoiceHelper.THREE.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, planChangeDate, targetDate, 7, expectedValue);
        expectedValue = TestInvoiceHelper.FIVE.divide(TestInvoiceHelper.TWENTY_EIGHT, 4).add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(planChangeDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testStartTargetEnd() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 12, 15);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 3, 15);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 3, 17);
        BigDecimal expectedValue = TestInvoiceHelper.THREE.add(TestInvoiceHelper.TWO.divide(TestInvoiceHelper.THIRTY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }
}

