/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance.quarterly;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public class TestDoubleProRation
extends ProRationInAdvanceTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.QUARTERLY;
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateOnStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateInFirstProRationPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 7);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateOnFirstBillingCycleDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 15);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateInFullBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 1, 22);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateOnSecondBillingCycleDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 15);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        expectedValue = expectedValue.add(TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateInSecondProRationPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 26);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        expectedValue = expectedValue.add(TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateOnEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 4, 27);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        expectedValue = expectedValue.add(TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRation_TargetDateAfterEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 5, 7);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 4, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.ONE);
        expectedValue = expectedValue.add(TestInvoiceHelper.TWELVE.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }

    @Test(groups={"fast"})
    public void testDoubleProRationWithMultiplePeriods_TargetDateInSecondFullBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2011, 1, 1);
        LocalDate targetDate = this.invoiceUtil.buildDate(2011, 6, 26);
        LocalDate endDate = this.invoiceUtil.buildDate(2011, 8, 27);
        BigDecimal expectedValue = TestInvoiceHelper.FOURTEEN.divide(TestInvoiceHelper.NINETY_TWO, 4);
        expectedValue = expectedValue.add(TestInvoiceHelper.TWO);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 15, expectedValue);
    }
}

