/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.proRations.inAdvance.quarterly;

import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.model.InvalidDateSequenceException;
import org.killbill.billing.invoice.proRations.inAdvance.ProRationInAdvanceTestBase;
import org.testng.annotations.Test;

public class TestTrailingProRation
extends ProRationInAdvanceTestBase {
    protected BillingPeriod getBillingPeriod() {
        return BillingPeriod.QUARTERLY;
    }

    @Test(groups={"fast"})
    public void testTargetDateOnStartDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        LocalDate targetDate = this.invoiceUtil.buildDate(2010, 6, 17);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testTargetDateInFirstBillingPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        LocalDate targetDate = this.invoiceUtil.buildDate(2010, 6, 20);
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, TestInvoiceHelper.ONE);
    }

    @Test(groups={"fast"})
    public void testTargetDateAtEndOfFirstBillingCycle() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        LocalDate targetDate = this.invoiceUtil.buildDate(2010, 9, 17);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, expectedValue);
    }

    @Test(groups={"fast"})
    public void testTargetDateInProRationPeriod() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        LocalDate targetDate = this.invoiceUtil.buildDate(2010, 9, 18);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, expectedValue);
    }

    @Test(groups={"fast"})
    public void testTargetDateOnEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, endDate, 17, expectedValue);
    }

    @Test(groups={"fast"})
    public void testTargetDateAfterEndDate() throws InvalidDateSequenceException {
        LocalDate startDate = this.invoiceUtil.buildDate(2010, 6, 17);
        LocalDate endDate = this.invoiceUtil.buildDate(2010, 9, 25);
        LocalDate targetDate = this.invoiceUtil.buildDate(2010, 9, 30);
        BigDecimal expectedValue = TestInvoiceHelper.ONE.add(TestInvoiceHelper.EIGHT.divide(TestInvoiceHelper.NINETY_ONE, 4));
        this.testCalculateNumberOfBillingCycles(startDate, endDate, targetDate, 17, expectedValue);
    }
}

