/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.template.formatters;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.api.InvoiceStatus;
import org.killbill.billing.invoice.api.formatters.ResourceBundleFactory;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.model.CreditAdjInvoiceItem;
import org.killbill.billing.invoice.model.CreditBalanceAdjInvoiceItem;
import org.killbill.billing.invoice.model.DefaultInvoice;
import org.killbill.billing.invoice.model.DefaultInvoicePayment;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.RepairAdjInvoiceItem;
import org.killbill.billing.invoice.template.formatters.DefaultInvoiceFormatter;
import org.killbill.billing.invoice.template.translator.DefaultInvoiceTranslator;
import org.killbill.billing.util.email.templates.MustacheTemplateEngine;
import org.killbill.billing.util.template.translation.TranslatorConfig;
import org.skife.config.ConfigurationObjectFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDefaultInvoiceFormatter
extends InvoiceTestSuiteNoDB {
    private TranslatorConfig config;
    private MustacheTemplateEngine templateEngine;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.config = (TranslatorConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(TranslatorConfig.class);
        this.templateEngine = new MustacheTemplateEngine();
    }

    @Test(groups={"fast"})
    public void testIgnoreZeroAdjustments() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), BigDecimal.TEN, Currency.USD);
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem = new CreditBalanceAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), fixedItem.getAmount(), fixedItem.getCurrency());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem2 = new CreditBalanceAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), fixedItem.getAmount().negate(), fixedItem.getCurrency());
        DefaultInvoice invoice = new DefaultInvoice(fixedItem.getInvoiceId(), fixedItem.getAccountId(), null, new LocalDate(), new LocalDate(), Currency.USD, false, InvoiceStatus.COMMITTED);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        invoice.addInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem);
        invoice.addInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem2);
        Assert.assertEquals((Object)invoice.getBalance().doubleValue(), (Object)10.0);
        Assert.assertEquals((Object)invoice.getCreditedAmount().doubleValue(), (Object)0.0);
        DefaultInvoiceFormatter formatter = new DefaultInvoiceFormatter(this.config, (Invoice)invoice, Locale.US, null, this.resourceBundleFactory, (InternalTenantContext)this.internalCallContext);
        List invoiceItems = formatter.getInvoiceItems();
        Assert.assertEquals((int)invoiceItems.size(), (int)1);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getAmount().doubleValue(), (Object)10.0);
    }

    @Test(groups={"fast"})
    public void testMergeItems() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), BigDecimal.TEN, Currency.USD);
        RepairAdjInvoiceItem repairAdjInvoiceItem = new RepairAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), fixedItem.getEndDate(), fixedItem.getAmount().negate(), fixedItem.getCurrency(), fixedItem.getId());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem = new CreditBalanceAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), fixedItem.getAmount(), fixedItem.getCurrency());
        CreditAdjInvoiceItem creditAdjInvoiceItem = new CreditAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), null, BigDecimal.ONE.negate(), fixedItem.getCurrency());
        CreditBalanceAdjInvoiceItem creditBalanceAdjInvoiceItem2 = new CreditBalanceAdjInvoiceItem(fixedItem.getInvoiceId(), fixedItem.getAccountId(), fixedItem.getStartDate(), creditAdjInvoiceItem.getAmount().negate(), fixedItem.getCurrency());
        DefaultInvoice invoice = new DefaultInvoice(fixedItem.getInvoiceId(), fixedItem.getAccountId(), null, new LocalDate(), new LocalDate(), Currency.USD, false, InvoiceStatus.COMMITTED);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        invoice.addInvoiceItem((InvoiceItem)repairAdjInvoiceItem);
        invoice.addInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem);
        invoice.addInvoiceItem((InvoiceItem)creditAdjInvoiceItem);
        invoice.addInvoiceItem((InvoiceItem)creditBalanceAdjInvoiceItem2);
        invoice.addPayment((InvoicePayment)new DefaultInvoicePayment(InvoicePaymentType.ATTEMPT, UUID.randomUUID(), invoice.getId(), this.clock.getUTCNow(), BigDecimal.TEN, Currency.USD, Currency.USD, null, Boolean.valueOf(true)));
        invoice.addPayment((InvoicePayment)new DefaultInvoicePayment(InvoicePaymentType.REFUND, UUID.randomUUID(), invoice.getId(), this.clock.getUTCNow(), BigDecimal.ONE.negate(), Currency.USD, Currency.USD, null, Boolean.valueOf(true)));
        Assert.assertEquals((Object)invoice.getBalance().doubleValue(), (Object)1.0);
        Assert.assertEquals((Object)invoice.getCreditedAmount().doubleValue(), (Object)11.0);
        Assert.assertEquals((Object)invoice.getRefundedAmount().doubleValue(), (Object)-1.0);
        DefaultInvoiceFormatter formatter = new DefaultInvoiceFormatter(this.config, (Invoice)invoice, Locale.US, null, this.resourceBundleFactory, (InternalTenantContext)this.internalCallContext);
        List invoiceItems = formatter.getInvoiceItems();
        Assert.assertEquals((int)invoiceItems.size(), (int)4);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getAmount().doubleValue(), (Object)10.0);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getInvoiceItemType(), (Object)InvoiceItemType.REPAIR_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getAmount().doubleValue(), (Object)-10.0);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getInvoiceItemType(), (Object)InvoiceItemType.CBA_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getAmount().doubleValue(), (Object)11.0);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getInvoiceItemType(), (Object)InvoiceItemType.CREDIT_ADJ);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getAmount().doubleValue(), (Object)-1.0);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountFranceAndEUR() throws Exception {
        FixedPriceInvoiceItem fixedItemEUR = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1499.95"), Currency.EUR);
        DefaultInvoice invoiceEUR = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.EUR);
        invoiceEUR.addInvoiceItem((InvoiceItem)fixedItemEUR);
        this.checkOutput((Invoice)invoiceEUR, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>1\u00a0499,95 \u20ac</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>0,00 \u20ac</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>1\u00a0499,95 \u20ac</strong></td>\n</tr>", Locale.FRANCE);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountFranceAndOMR() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1499.958"), Currency.OMR);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.OMR);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>1\u00a0499,958 \u0631.\u0639</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>0,000 \u0631.\u0639</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>1\u00a0499,958 \u0631.\u0639</strong></td>\n</tr>", Locale.FRANCE);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountFranceAndJPY() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1500.00"), Currency.JPY);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.JPY);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>1\u00a0500 \u00a5</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>0 \u00a5</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>1\u00a0500 \u00a5</strong></td>\n</tr>", Locale.FRANCE);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountUSAndBTC() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1105.28843439"), Currency.BTC);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.BTC);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>\u02431,105.28843439</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u02430.00000000</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u02431,105.28843439</strong></td>\n</tr>", Locale.US);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountUSAndEUR() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("2635.14"), Currency.EUR);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.EUR);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>\u20ac2,635.14</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u20ac0.00</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u20ac2,635.14</strong></td>\n</tr>", Locale.US);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountUSAndBRL() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("2635.14"), Currency.BRL);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.BRL);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>R$2,635.14</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>R$0.00</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>R$2,635.14</strong></td>\n</tr>", Locale.US);
    }

    @Test(groups={"fast"})
    public void testFormattedAmountUSAndGBP() throws Exception {
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1499.95"), Currency.GBP);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.GBP);
        invoice.addInvoiceItem((InvoiceItem)fixedItem);
        this.checkOutput((Invoice)invoice, "<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n</tr>", "<tr>\n    <td class=\"amount\"><strong>\u00a31,499.95</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u00a30.00</strong></td>\n</tr>\n<tr>\n    <td class=\"amount\"><strong>\u00a31,499.95</strong></td>\n</tr>", Locale.US);
    }

    @Test(groups={"fast"})
    public void testProcessedCurrencyExists() throws Exception {
        InvoiceModelDao invoiceModelDao = new InvoiceModelDao(UUID.randomUUID(), new LocalDate(), new LocalDate(), Currency.BRL, false);
        invoiceModelDao.setProcessedCurrency(Currency.USD);
        DefaultInvoice invoice = new DefaultInvoice(invoiceModelDao);
        this.checkOutput((Invoice)invoice, "{{#invoice.processedCurrency}}<tr>\n    <td class=\"processedCurrency\"><strong>{{invoice.processedCurrency}}</strong></td>\n</tr>\n{{/invoice.processedCurrency}}", "<tr>\n    <td class=\"processedCurrency\"><strong>USD</strong></td>\n</tr>\n", Locale.US);
    }

    @Test(groups={"fast"})
    public void testProcessedCurrencyDoesNotExist() throws Exception {
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), UUID.randomUUID(), new Integer(234), new LocalDate(), new LocalDate(), Currency.USD, false, InvoiceStatus.COMMITTED);
        this.checkOutput((Invoice)invoice, "{{#invoice.processedCurrency}}<tr>\n    <td class=\"processedCurrency\"><strong>{{invoice.processedCurrency}}</strong></td>\n</tr>\n{{/invoice.processedCurrency}}", "", Locale.US);
    }

    @Test(groups={"fast"})
    public void testForDisplay() throws Exception {
        FixedPriceInvoiceItem fixedItemBRL = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1499.95"), Currency.BRL);
        DefaultInvoice invoice = new DefaultInvoice(UUID.randomUUID(), UUID.randomUUID(), new Integer(234), new LocalDate(), new LocalDate(), Currency.BRL, false, InvoiceStatus.COMMITTED);
        invoice.addInvoiceItem((InvoiceItem)fixedItemBRL);
        String template = "<html>\n    <head>\n        <style type=\"text/css\">\n            #header td { width: 250px; }\n            #header .company_info { width: 450px; }\n            #header .label { text-align: right; font-weight: bold; }\n            #header .label_value { padding-left: 10px; }\n\n            #invoice_items { margin-top: 50px; }\n            #invoice_items th { border-bottom: solid 2px black; }\n            #invoice_items td { width: 250px; }\n            #invoice_items td.amount { width: 125px; }\n            #invoice_items td.network { width: 350px; }\n            #invoice_items .amount { text-align: right; }\n            #invoice_items .label { text-align: right; font-weight: bold; }\n        </style>\n    </head>\n    <body>\n        <table id=\"header\">\n            <tr>\n                <td class=\"company_info\"/>\n                <td />\n                <td><h1>{{text.invoiceTitle}}</h1></td>\n            </tr>\n            <tr>\n                <td colspan=\"3\"><img src=\"http://static.foo.com/www/0/main/gfx/front/logo.png\"/></td>\n            </tr>\n            <tr>\n                <td class=\"company_info\" />\n                <td class=\"label\">{{text.invoiceDate}}</td>\n                <td class=\"label_value\">{{invoice.formattedInvoiceDate}}</td>\n            </tr>\n            <tr>\n                <td class=\"company_info\" />\n                <td class=\"label\">{{text.invoiceNumber}}</td>\n                <td class=\"label_value\">{{invoice.invoiceNumber}}</td>\n            </tr>\n            <tr>\n                <td class=\"company_info\">{{text.companyCountry}}</td>\n                <td colspan=\"2\" />\n            </tr>\n            <tr>\n                <td class=\"company_info\">{{text.companyUrl}}</td>\n                <td colspan=\"2\" />\n            </tr>\n        </table>\n\n        <table id=\"invoice_items\">\n            <tr>\n                <th class=\"network\">{{text.invoiceItemBundleName}}</td>\n                <th>{{text.invoiceItemDescription}}</td>\n                <th>{{text.invoiceItemServicePeriod}}</td>\n                <th>{{text.invoiceItemAmount}}</td>\n            </tr>\n            {{#invoice.invoiceItems}}\n            <tr>\n                <td class=\"network\">{{description}}</td>\n                <td>{{planName}}</td>\n                <td>{{formattedStartDate}}{{#formattedEndDate}} - {{formattedEndDate}}{{/formattedEndDate}}</td>\n                <td class=\"amount\">{{formattedAmount}}</td>\n            </tr>\n            {{/invoice.invoiceItems}}\n            <tr>\n                <td colspan=\"4\" height=\"50px\"></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceAmount}}</td>\n                <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceAmountPaid}}                    {{#invoice.processedCurrency}} (*)                    {{/invoice.processedCurrency}}\n                </td>\n                <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceBalance}}</td>\n                <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n            </tr>\n        </table>\n        {{#invoice.processedCurrency}}        {{text.processedPaymentCurrency}} {{invoice.processedCurrency}}.        {{#invoice.processedPaymentRate}}\n {{text.processedPaymentRate}} {{invoice.processedPaymentRate}}.\n        {{/invoice.processedPaymentRate}}        {{/invoice.processedCurrency}}    </body>\n</html>\n";
        HashMap<String, Object> data = new HashMap<String, Object>();
        String bundlePath = "org/killbill/billing/util/template/translation/InvoiceTranslation";
        ResourceBundle bundle = this.resourceBundleFactory.createBundle(Locale.US, "org/killbill/billing/util/template/translation/InvoiceTranslation", ResourceBundleFactory.ResourceBundleType.INVOICE_TRANSLATION, (InternalTenantContext)this.internalCallContext);
        DefaultInvoiceTranslator translator = new DefaultInvoiceTranslator(bundle, null);
        data.put("text", translator);
        data.put("invoice", new DefaultInvoiceFormatter(this.config, (Invoice)invoice, Locale.US, this.currencyConversionApi, this.resourceBundleFactory, (InternalTenantContext)this.internalCallContext));
        String formattedText = this.templateEngine.executeTemplateText("<html>\n    <head>\n        <style type=\"text/css\">\n            #header td { width: 250px; }\n            #header .company_info { width: 450px; }\n            #header .label { text-align: right; font-weight: bold; }\n            #header .label_value { padding-left: 10px; }\n\n            #invoice_items { margin-top: 50px; }\n            #invoice_items th { border-bottom: solid 2px black; }\n            #invoice_items td { width: 250px; }\n            #invoice_items td.amount { width: 125px; }\n            #invoice_items td.network { width: 350px; }\n            #invoice_items .amount { text-align: right; }\n            #invoice_items .label { text-align: right; font-weight: bold; }\n        </style>\n    </head>\n    <body>\n        <table id=\"header\">\n            <tr>\n                <td class=\"company_info\"/>\n                <td />\n                <td><h1>{{text.invoiceTitle}}</h1></td>\n            </tr>\n            <tr>\n                <td colspan=\"3\"><img src=\"http://static.foo.com/www/0/main/gfx/front/logo.png\"/></td>\n            </tr>\n            <tr>\n                <td class=\"company_info\" />\n                <td class=\"label\">{{text.invoiceDate}}</td>\n                <td class=\"label_value\">{{invoice.formattedInvoiceDate}}</td>\n            </tr>\n            <tr>\n                <td class=\"company_info\" />\n                <td class=\"label\">{{text.invoiceNumber}}</td>\n                <td class=\"label_value\">{{invoice.invoiceNumber}}</td>\n            </tr>\n            <tr>\n                <td class=\"company_info\">{{text.companyCountry}}</td>\n                <td colspan=\"2\" />\n            </tr>\n            <tr>\n                <td class=\"company_info\">{{text.companyUrl}}</td>\n                <td colspan=\"2\" />\n            </tr>\n        </table>\n\n        <table id=\"invoice_items\">\n            <tr>\n                <th class=\"network\">{{text.invoiceItemBundleName}}</td>\n                <th>{{text.invoiceItemDescription}}</td>\n                <th>{{text.invoiceItemServicePeriod}}</td>\n                <th>{{text.invoiceItemAmount}}</td>\n            </tr>\n            {{#invoice.invoiceItems}}\n            <tr>\n                <td class=\"network\">{{description}}</td>\n                <td>{{planName}}</td>\n                <td>{{formattedStartDate}}{{#formattedEndDate}} - {{formattedEndDate}}{{/formattedEndDate}}</td>\n                <td class=\"amount\">{{formattedAmount}}</td>\n            </tr>\n            {{/invoice.invoiceItems}}\n            <tr>\n                <td colspan=\"4\" height=\"50px\"></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceAmount}}</td>\n                <td class=\"amount\"><strong>{{invoice.formattedChargedAmount}}</strong></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceAmountPaid}}                    {{#invoice.processedCurrency}} (*)                    {{/invoice.processedCurrency}}\n                </td>\n                <td class=\"amount\"><strong>{{invoice.formattedPaidAmount}}</strong></td>\n            </tr>\n            <tr>\n                <td colspan=\"2\" />\n                <td class=\"label\">{{text.invoiceBalance}}</td>\n                <td class=\"amount\"><strong>{{invoice.formattedBalance}}</strong></td>\n            </tr>\n        </table>\n        {{#invoice.processedCurrency}}        {{text.processedPaymentCurrency}} {{invoice.processedCurrency}}.        {{#invoice.processedPaymentRate}}\n {{text.processedPaymentRate}} {{invoice.processedPaymentRate}}.\n        {{/invoice.processedPaymentRate}}        {{/invoice.processedCurrency}}    </body>\n</html>\n", data);
        System.out.println(formattedText);
    }

    private void checkOutput(Invoice invoice, String template, String expected, Locale locale) {
        HashMap<String, DefaultInvoiceFormatter> data = new HashMap<String, DefaultInvoiceFormatter>();
        data.put("invoice", new DefaultInvoiceFormatter(this.config, invoice, locale, null, this.resourceBundleFactory, (InternalTenantContext)this.internalCallContext));
        String formattedText = this.templateEngine.executeTemplateText(template, data);
        Assert.assertEquals((String)formattedText, (String)expected);
    }
}

