/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.template.formatters;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.invoice.template.formatters.DefaultInvoiceItemFormatter;
import org.killbill.billing.util.LocaleUtils;
import org.killbill.billing.util.email.templates.MustacheTemplateEngine;
import org.killbill.billing.util.template.translation.TranslatorConfig;
import org.skife.config.ConfigurationObjectFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDefaultInvoiceItemFormatter
extends InvoiceTestSuiteNoDB {
    private TranslatorConfig config;
    private MustacheTemplateEngine templateEngine;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.config = (TranslatorConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(TranslatorConfig.class);
        this.templateEngine = new MustacheTemplateEngine();
    }

    @Test(groups={"fast"})
    public void testBasicUSD() throws Exception {
        FixedPriceInvoiceItem fixedItemUSD = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("-1114.751625346"), Currency.USD);
        this.checkOutput((InvoiceItem)fixedItemUSD, "{{#invoiceItem}}<td class=\"amount\">{{formattedAmount}}</td>{{/invoiceItem}}", "<td class=\"amount\">($1,114.75)</td>", LocaleUtils.toLocale((String)"en_US"));
    }

    @Test(groups={"fast"})
    public void testFormattedAmount() throws Exception {
        FixedPriceInvoiceItem fixedItemEUR = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("1499.95"), Currency.EUR);
        this.checkOutput((InvoiceItem)fixedItemEUR, "{{#invoiceItem}}<td class=\"amount\">{{formattedAmount}}</td>{{/invoiceItem}}", "<td class=\"amount\">1\u00a0499,95 \u20ac</td>", Locale.FRANCE);
        FixedPriceInvoiceItem fixedItemUSD = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("-1114.751625346"), Currency.USD);
        this.checkOutput((InvoiceItem)fixedItemUSD, "{{#invoiceItem}}<td class=\"amount\">{{formattedAmount}}</td>{{/invoiceItem}}", "<td class=\"amount\">($1,114.75)</td>");
        FixedPriceInvoiceItem fixedItemGBP = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), new LocalDate(), new BigDecimal("8.07"), Currency.GBP);
        this.checkOutput((InvoiceItem)fixedItemGBP, "{{#invoiceItem}}<td class=\"amount\">{{formattedAmount}}</td>{{/invoiceItem}}", "<td class=\"amount\">8,07 GBP</td>", Locale.FRANCE);
    }

    @Test(groups={"fast"})
    public void testNullEndDate() throws Exception {
        LocalDate startDate = new LocalDate(2012, 12, 1);
        FixedPriceInvoiceItem fixedItem = new FixedPriceInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), startDate, BigDecimal.TEN, Currency.USD);
        this.checkOutput((InvoiceItem)fixedItem, "{{#invoiceItem}}<td>{{formattedStartDate}}{{#formattedEndDate}} - {{formattedEndDate}}{{/formattedEndDate}}</td>{{/invoiceItem}}", "<td>Dec 1, 2012</td>");
    }

    @Test(groups={"fast"})
    public void testNonNullEndDate() throws Exception {
        LocalDate startDate = new LocalDate(2012, 12, 1);
        LocalDate endDate = new LocalDate(2012, 12, 31);
        RecurringInvoiceItem recurringItem = new RecurringInvoiceItem(UUID.randomUUID(), UUID.randomUUID(), null, null, UUID.randomUUID().toString(), UUID.randomUUID().toString(), startDate, endDate, BigDecimal.TEN, BigDecimal.TEN, Currency.USD);
        this.checkOutput((InvoiceItem)recurringItem, "{{#invoiceItem}}<td>{{formattedStartDate}}{{#formattedEndDate}} - {{formattedEndDate}}{{/formattedEndDate}}</td>{{/invoiceItem}}", "<td>Dec 1, 2012 - Dec 31, 2012</td>");
    }

    private void checkOutput(InvoiceItem invoiceItem, String template, String expected) {
        this.checkOutput(invoiceItem, template, expected, Locale.US);
    }

    private void checkOutput(InvoiceItem invoiceItem, String template, String expected, Locale locale) {
        HashMap<String, DefaultInvoiceItemFormatter> data = new HashMap<String, DefaultInvoiceItemFormatter>();
        data.put("invoiceItem", new DefaultInvoiceItemFormatter(this.config, invoiceItem, DateTimeFormat.mediumDate().withLocale(locale), locale, (InternalTenantContext)this.internalCallContext, this.resourceBundleFactory));
        String formattedText = this.templateEngine.executeTemplateText(template, data);
        Assert.assertEquals((String)formattedText, (String)expected);
    }
}

