/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.invoice.tree.NodeInterval;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeInterval {
    private NodeInterval.AddNodeCallback CALLBACK = new DummyAddNodeCallback();

    @Test(groups={"fast"})
    public void testAddExistingItemSimple() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-07");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-08", "2014-01-15");
        DummyNodeInterval thirdChildLevel1 = this.createNodeInterval("2014-01-16", "2014-02-01");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        root.addNode(thirdChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-03", "2014-01-5");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-16", "2014-01-17");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        this.checkNode(top, 3, root, firstChildLevel1, null);
        this.checkNode(firstChildLevel1, 2, top, firstChildLevel2, secondChildLevel1);
        this.checkNode(secondChildLevel1, 0, top, null, thirdChildLevel1);
        this.checkNode(thirdChildLevel1, 1, top, thirdChildLevel2, null);
        this.checkNode(firstChildLevel2, 0, firstChildLevel1, null, secondChildLevel2);
        this.checkNode(secondChildLevel2, 0, firstChildLevel1, null, null);
        this.checkNode(thirdChildLevel2, 0, thirdChildLevel1, null, null);
    }

    @Test(groups={"fast"})
    public void testAddExistingItemWithRebalance() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-03", "2014-01-5");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-16", "2014-01-17");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-07");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-08", "2014-01-15");
        DummyNodeInterval thirdChildLevel1 = this.createNodeInterval("2014-01-16", "2014-02-01");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        root.addNode(thirdChildLevel1, this.CALLBACK);
        this.checkNode(top, 3, root, firstChildLevel1, null);
        this.checkNode(firstChildLevel1, 2, top, firstChildLevel2, secondChildLevel1);
        this.checkNode(secondChildLevel1, 0, top, null, thirdChildLevel1);
        this.checkNode(thirdChildLevel1, 1, top, thirdChildLevel2, null);
        this.checkNode(firstChildLevel2, 0, firstChildLevel1, null, secondChildLevel2);
        this.checkNode(secondChildLevel2, 0, firstChildLevel1, null, null);
        this.checkNode(thirdChildLevel2, 0, thirdChildLevel1, null, null);
    }

    @Test(groups={"fast"})
    public void testBuild() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-07");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-08", "2014-01-15");
        DummyNodeInterval thirdChildLevel1 = this.createNodeInterval("2014-01-16", "2014-02-01");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        root.addNode(thirdChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-03", "2014-01-5");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-16", "2014-01-17");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        final LinkedList output = new LinkedList();
        root.build(new NodeInterval.BuildNodeCallback(){

            public void onMissingInterval(NodeInterval curNode, LocalDate startDate, LocalDate endDate) {
                output.add(TestNodeInterval.this.createNodeInterval(startDate, endDate));
            }

            public void onLastNode(NodeInterval curNode) {
            }
        });
        LinkedList<DummyNodeInterval> expected = new LinkedList<DummyNodeInterval>();
        expected.add(this.createNodeInterval("2014-01-05", "2014-01-07"));
        expected.add(this.createNodeInterval("2014-01-07", "2014-01-08"));
        expected.add(this.createNodeInterval("2014-01-15", "2014-01-16"));
        expected.add(this.createNodeInterval("2014-01-17", "2014-02-01"));
        Assert.assertEquals((int)output.size(), (int)expected.size());
        this.checkInterval((NodeInterval)output.get(0), (NodeInterval)expected.get(0));
        this.checkInterval((NodeInterval)output.get(1), (NodeInterval)expected.get(1));
    }

    @Test(groups={"fast"})
    public void testSearch() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-07");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-08", "2014-01-15");
        DummyNodeInterval thirdChildLevel1 = this.createNodeInterval("2014-01-16", "2014-02-01");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        root.addNode(thirdChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-03", "2014-01-5");
        final DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-16", "2014-01-17");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        DummyNodeInterval firstChildLevel3 = this.createNodeInterval("2014-01-01", "2014-01-02");
        final DummyNodeInterval secondChildLevel3 = this.createNodeInterval("2014-01-03", "2014-01-04");
        root.addNode(firstChildLevel3, this.CALLBACK);
        root.addNode(secondChildLevel3, this.CALLBACK);
        NodeInterval search1 = root.findNode(new LocalDate((Object)"2014-01-04"), new NodeInterval.SearchCallback(){

            public boolean isMatch(NodeInterval curNode) {
                return ((DummyNodeInterval)curNode).getId().equals(secondChildLevel3.getId());
            }
        });
        this.checkInterval(search1, secondChildLevel3);
        NodeInterval search2 = root.findNode(new NodeInterval.SearchCallback(){

            public boolean isMatch(NodeInterval curNode) {
                return ((DummyNodeInterval)curNode).getId().equals(thirdChildLevel2.getId());
            }
        });
        this.checkInterval(search2, thirdChildLevel2);
        NodeInterval nullSearch = root.findNode(new NodeInterval.SearchCallback(){

            public boolean isMatch(NodeInterval curNode) {
                return ((DummyNodeInterval)curNode).getId().equals("foo");
            }
        });
        Assert.assertNull((Object)nullSearch);
    }

    @Test(groups={"fast"})
    public void testWalkTree() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval firstChildLevel0 = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(firstChildLevel0, this.CALLBACK);
        DummyNodeInterval secondChildLevel0 = this.createNodeInterval("2014-02-01", "2014-03-01");
        root.addNode(secondChildLevel0, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-07");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-08", "2014-01-15");
        DummyNodeInterval thirdChildLevel1 = this.createNodeInterval("2014-01-16", "2014-02-01");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        root.addNode(thirdChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-03", "2014-01-05");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-16", "2014-01-17");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        DummyNodeInterval firstChildLevel3 = this.createNodeInterval("2014-01-01", "2014-01-02");
        DummyNodeInterval secondChildLevel3 = this.createNodeInterval("2014-01-03", "2014-01-04");
        root.addNode(firstChildLevel3, this.CALLBACK);
        root.addNode(secondChildLevel3, this.CALLBACK);
        LinkedList<DummyNodeInterval> expected = new LinkedList<DummyNodeInterval>();
        expected.add(root);
        expected.add(firstChildLevel0);
        expected.add(firstChildLevel1);
        expected.add(firstChildLevel2);
        expected.add(firstChildLevel3);
        expected.add(secondChildLevel2);
        expected.add(secondChildLevel3);
        expected.add(secondChildLevel1);
        expected.add(thirdChildLevel1);
        expected.add(thirdChildLevel2);
        expected.add(secondChildLevel0);
        final LinkedList result = new LinkedList();
        root.walkTree(new NodeInterval.WalkCallback(){

            public void onCurrentNode(int depth, NodeInterval curNode, NodeInterval parent) {
                result.add(curNode);
            }
        });
        Assert.assertEquals((int)result.size(), (int)expected.size());
        for (int i = 0; i < result.size(); ++i) {
            if (i == 0) {
                Assert.assertTrue((boolean)((NodeInterval)result.get(0)).isRoot());
                this.checkInterval((NodeInterval)result.get(0), this.createNodeInterval("2014-01-01", "2014-03-01"));
                continue;
            }
            this.checkInterval((NodeInterval)result.get(i), (NodeInterval)expected.get(i));
        }
    }

    @Test(groups={"fast"})
    public void testRemoveLeftChildWithGrandChildren() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-20");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-21", "2014-01-31");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-01", "2014-01-03");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-04", "2014-01-10");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-11", "2014-01-20");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        final ArrayList<DummyNodeInterval> expectedNodes = new ArrayList<DummyNodeInterval>();
        expectedNodes.add(root);
        expectedNodes.add(top);
        expectedNodes.add(firstChildLevel1);
        expectedNodes.add(firstChildLevel2);
        expectedNodes.add(secondChildLevel2);
        expectedNodes.add(thirdChildLevel2);
        expectedNodes.add(secondChildLevel1);
        root.walkTree(new NodeInterval.WalkCallback(){

            public void onCurrentNode(int depth, NodeInterval curNode, NodeInterval parent) {
                Assert.assertEquals((Object)curNode, expectedNodes.remove(0));
            }
        });
        top.removeChild(firstChildLevel1);
        final ArrayList<DummyNodeInterval> expectedNodesAfterRemoval = new ArrayList<DummyNodeInterval>();
        expectedNodesAfterRemoval.add(root);
        expectedNodesAfterRemoval.add(top);
        expectedNodesAfterRemoval.add(firstChildLevel2);
        expectedNodesAfterRemoval.add(secondChildLevel2);
        expectedNodesAfterRemoval.add(thirdChildLevel2);
        expectedNodesAfterRemoval.add(secondChildLevel1);
        root.walkTree(new NodeInterval.WalkCallback(){

            public void onCurrentNode(int depth, NodeInterval curNode, NodeInterval parent) {
                Assert.assertEquals((Object)curNode, expectedNodesAfterRemoval.remove(0));
            }
        });
    }

    @Test(groups={"fast"})
    public void testRemoveMiddleChildWithGrandChildren() {
        DummyNodeInterval root = new DummyNodeInterval();
        DummyNodeInterval top = this.createNodeInterval("2014-01-01", "2014-02-01");
        root.addNode(top, this.CALLBACK);
        DummyNodeInterval firstChildLevel1 = this.createNodeInterval("2014-01-01", "2014-01-20");
        DummyNodeInterval secondChildLevel1 = this.createNodeInterval("2014-01-21", "2014-01-31");
        root.addNode(firstChildLevel1, this.CALLBACK);
        root.addNode(secondChildLevel1, this.CALLBACK);
        DummyNodeInterval firstChildLevel2 = this.createNodeInterval("2014-01-21", "2014-01-23");
        DummyNodeInterval secondChildLevel2 = this.createNodeInterval("2014-01-24", "2014-01-25");
        DummyNodeInterval thirdChildLevel2 = this.createNodeInterval("2014-01-26", "2014-01-31");
        root.addNode(firstChildLevel2, this.CALLBACK);
        root.addNode(secondChildLevel2, this.CALLBACK);
        root.addNode(thirdChildLevel2, this.CALLBACK);
        final ArrayList<DummyNodeInterval> expectedNodes = new ArrayList<DummyNodeInterval>();
        expectedNodes.add(root);
        expectedNodes.add(top);
        expectedNodes.add(firstChildLevel1);
        expectedNodes.add(secondChildLevel1);
        expectedNodes.add(firstChildLevel2);
        expectedNodes.add(secondChildLevel2);
        expectedNodes.add(thirdChildLevel2);
        root.walkTree(new NodeInterval.WalkCallback(){

            public void onCurrentNode(int depth, NodeInterval curNode, NodeInterval parent) {
                Assert.assertEquals((Object)curNode, expectedNodes.remove(0));
            }
        });
        top.removeChild(secondChildLevel1);
        final ArrayList<DummyNodeInterval> expectedNodesAfterRemoval = new ArrayList<DummyNodeInterval>();
        expectedNodesAfterRemoval.add(root);
        expectedNodesAfterRemoval.add(top);
        expectedNodesAfterRemoval.add(firstChildLevel1);
        expectedNodesAfterRemoval.add(firstChildLevel2);
        expectedNodesAfterRemoval.add(secondChildLevel2);
        expectedNodesAfterRemoval.add(thirdChildLevel2);
        root.walkTree(new NodeInterval.WalkCallback(){

            public void onCurrentNode(int depth, NodeInterval curNode, NodeInterval parent) {
                Assert.assertEquals((Object)curNode, expectedNodesAfterRemoval.remove(0));
            }
        });
    }

    private void checkInterval(NodeInterval real, NodeInterval expected) {
        Assert.assertEquals((Object)real.getStart(), (Object)expected.getStart());
        Assert.assertEquals((Object)real.getEnd(), (Object)expected.getEnd());
    }

    private void checkNode(NodeInterval node, int expectedChildren, DummyNodeInterval expectedParent, DummyNodeInterval expectedLeftChild, DummyNodeInterval expectedRightSibling) {
        Assert.assertEquals((int)node.getNbChildren(), (int)expectedChildren);
        Assert.assertEquals((Object)node.getParent(), (Object)((Object)expectedParent));
        Assert.assertEquals((Object)node.getRightSibling(), (Object)((Object)expectedRightSibling));
        Assert.assertEquals((Object)node.getLeftChild(), (Object)((Object)expectedLeftChild));
        Assert.assertEquals((Object)node.getLeftChild(), (Object)((Object)expectedLeftChild));
    }

    private DummyNodeInterval createNodeInterval(LocalDate startDate, LocalDate endDate) {
        return new DummyNodeInterval(null, startDate, endDate);
    }

    private DummyNodeInterval createNodeInterval(String startDate, String endDate) {
        return this.createNodeInterval(new LocalDate((Object)startDate), new LocalDate((Object)endDate));
    }

    public class DummyAddNodeCallback
    implements NodeInterval.AddNodeCallback {
        public boolean onExistingNode(NodeInterval existingNode) {
            return false;
        }

        public boolean shouldInsertNode(NodeInterval insertionNode) {
            return true;
        }
    }

    public class DummyNodeInterval
    extends NodeInterval {
        private final UUID id;

        public DummyNodeInterval() {
            this.id = UUID.randomUUID();
        }

        public DummyNodeInterval(NodeInterval parent, LocalDate startDate, LocalDate endDate) {
            super(parent, startDate, endDate);
            this.id = UUID.randomUUID();
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DummyNodeInterval)) {
                return false;
            }
            DummyNodeInterval that = (DummyNodeInterval)((Object)o);
            return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }
}

