/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.tree;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.ItemAdjInvoiceItem;
import org.killbill.billing.invoice.model.RecurringInvoiceItem;
import org.killbill.billing.invoice.model.RepairAdjInvoiceItem;
import org.killbill.billing.invoice.tree.ItemsNodeInterval;
import org.killbill.billing.invoice.tree.SubscriptionItemTree;
import org.killbill.billing.invoice.tree.TreePrinter;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSubscriptionItemTree
extends InvoiceTestSuiteNoDB {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final UUID invoiceId = UUID.randomUUID();
    private final UUID accountId = UUID.randomUUID();
    private final UUID subscriptionId = UUID.randomUUID();
    private final UUID bundleId = UUID.randomUUID();
    private final String planName = "my-plan";
    private final String phaseName = "my-phase";
    private final Currency currency = Currency.USD;

    @Test(groups={"fast"}, description="Complex multi-level tree, mostly used to test the tree printer")
    public void testMultipleLevels() throws Exception {
        BigDecimal rate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate startRepairDate1 = new LocalDate(2014, 1, 10);
        LocalDate endRepairDate1 = new LocalDate(2014, 1, 15);
        LocalDate startRepairDate11 = new LocalDate(2014, 1, 10);
        LocalDate endRepairDate12 = new LocalDate(2014, 1, 12);
        LocalDate startRepairDate2 = new LocalDate(2014, 1, 20);
        LocalDate endRepairDate2 = new LocalDate(2014, 1, 25);
        LocalDate startRepairDate21 = new LocalDate(2014, 1, 22);
        LocalDate endRepairDate22 = new LocalDate(2014, 1, 23);
        BigDecimal amount = rate = BigDecimal.TEN;
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount, rate, this.currency);
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startRepairDate1, endRepairDate1, amount, rate, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startRepairDate1, endRepairDate1, amount.negate(), this.currency, initial.getId());
        RecurringInvoiceItem newItem11 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startRepairDate11, endRepairDate12, amount, rate, this.currency);
        RepairAdjInvoiceItem repair12 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startRepairDate11, endRepairDate12, amount.negate(), this.currency, newItem1.getId());
        RecurringInvoiceItem newItem2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startRepairDate2, endRepairDate2, amount, rate, this.currency);
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startRepairDate2, endRepairDate2, amount.negate(), this.currency, initial.getId());
        RecurringInvoiceItem newItem21 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startRepairDate21, endRepairDate22, amount, rate, this.currency);
        RepairAdjInvoiceItem repair22 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startRepairDate21, endRepairDate22, amount.negate(), this.currency, newItem2.getId());
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)newItem11);
        tree.addItem((InvoiceItem)repair12);
        tree.addItem((InvoiceItem)newItem2);
        tree.addItem((InvoiceItem)repair2);
        tree.addItem((InvoiceItem)newItem21);
        tree.addItem((InvoiceItem)repair22);
        tree.build();
        tree.flatten(true);
    }

    @Test(groups={"fast"})
    public void testWithExistingSplitRecurring() {
        BigDecimal rate = new BigDecimal("40.00");
        RecurringInvoiceItem recurring1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", new LocalDate(2016, 9, 8), new LocalDate(2016, 9, 9), new BigDecimal("2.0"), rate, this.currency);
        RecurringInvoiceItem recurring2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", new LocalDate(2016, 9, 9), new LocalDate(2016, 10, 8), new BigDecimal("38.0"), rate, this.currency);
        ArrayList<RecurringInvoiceItem> existingItems = new ArrayList<RecurringInvoiceItem>();
        existingItems.add(recurring1);
        existingItems.add(recurring2);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        for (InvoiceItem invoiceItem : existingItems) {
            tree.addItem(invoiceItem);
        }
        tree.build();
        tree.flatten(true);
        RecurringInvoiceItem proposedItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", new LocalDate(2016, 9, 8), new LocalDate(2016, 10, 8), rate, rate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposedItem);
        tree.buildForMerge();
        LinkedList linkedList = Lists.newLinkedList();
        linkedList.add(proposedItem);
        linkedList.add(new RepairAdjInvoiceItem(this.invoiceId, this.accountId, recurring1.getStartDate(), recurring1.getEndDate(), recurring1.getAmount().negate(), this.currency, recurring1.getId()));
        linkedList.add(new RepairAdjInvoiceItem(this.invoiceId, this.accountId, recurring2.getStartDate(), recurring2.getEndDate(), recurring2.getAmount().negate(), this.currency, recurring2.getId()));
        this.verifyResult(tree.getView(), linkedList);
        existingItems.addAll(tree.getView());
        Assert.assertEquals((int)existingItems.size(), (int)5);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        for (InvoiceItem invoiceItem : existingItems) {
            tree.addItem(invoiceItem);
        }
        tree.build();
        tree.flatten(true);
        RecurringInvoiceItem proposedItem2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", new LocalDate(2016, 9, 8), new LocalDate(2016, 10, 8), rate, rate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposedItem2);
        tree.buildForMerge();
        Assert.assertTrue((boolean)tree.getView().isEmpty());
    }

    @Test(groups={"fast"})
    public void testSimpleRepair() {
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate repairDate = new LocalDate(2014, 1, 23);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        BigDecimal amount2 = rate2 = new BigDecimal("14.85");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RecurringInvoiceItem newItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "someelse", "someelse", repairDate, endDate, amount2, rate2, this.currency);
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate, endDate, amount1.negate(), this.currency, initial.getId());
        LinkedList expectedResult = Lists.newLinkedList();
        RecurringInvoiceItem expected1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, repairDate, new BigDecimal("8.52"), rate1, this.currency);
        expectedResult.add(expected1);
        RecurringInvoiceItem expected2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "someelse", "someelse", repairDate, endDate, amount2, rate2, this.currency);
        expectedResult.add(expected2);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem);
        tree.addItem((InvoiceItem)repair);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)newItem);
        tree.addItem((InvoiceItem)initial);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testInvalidRepair() {
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal rate = new BigDecimal("12.00");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, rate, rate, this.currency);
        RepairAdjInvoiceItem tooEarlyRepair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate.minusDays(1), endDate, rate.negate(), this.currency, initial.getId());
        RepairAdjInvoiceItem tooLateRepair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, endDate.plusDays(1), rate.negate(), this.currency, initial.getId());
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)tooEarlyRepair);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)tooLateRepair);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"})
    public void testDanglingRepair() {
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal rate = new BigDecimal("12.00");
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate.minusDays(1), endDate, rate.negate(), this.currency, UUID.randomUUID());
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"})
    public void testMultipleRepair() {
        BigDecimal rate3;
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate repairDate1 = new LocalDate(2014, 1, 23);
        LocalDate repairDate2 = new LocalDate(2014, 1, 26);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        BigDecimal amount2 = rate2 = new BigDecimal("14.85");
        BigDecimal amount3 = rate3 = new BigDecimal("19.23");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate1, endDate, amount2, rate2, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate1, endDate, amount1.negate(), this.currency, initial.getId());
        RecurringInvoiceItem newItem2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate2, endDate, amount3, rate3, this.currency);
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate2, endDate, amount2.negate(), this.currency, newItem1.getId());
        LinkedList expectedResult = Lists.newLinkedList();
        RecurringInvoiceItem expected1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, repairDate1, new BigDecimal("8.52"), rate1, this.currency);
        expectedResult.add(expected1);
        RecurringInvoiceItem expected2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate1, repairDate2, new BigDecimal("4.95"), rate2, this.currency);
        expectedResult.add(expected2);
        RecurringInvoiceItem expected3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate2, endDate, amount3, rate3, this.currency);
        expectedResult.add(expected3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)newItem2);
        tree.addItem((InvoiceItem)repair2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair2);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)newItem2);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)initial);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)repair2);
        tree.addItem((InvoiceItem)newItem2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMultipleBlockedBillings() {
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate blockStart1 = new LocalDate(2014, 1, 8);
        LocalDate unblockStart1 = new LocalDate(2014, 1, 10);
        LocalDate blockStart2 = new LocalDate(2014, 1, 17);
        LocalDate unblockStart2 = new LocalDate(2014, 1, 23);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RepairAdjInvoiceItem block1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockStart1, unblockStart1, amount1.negate(), this.currency, initial.getId());
        RepairAdjInvoiceItem block2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockStart2, unblockStart2, amount1.negate(), this.currency, initial.getId());
        LinkedList expectedResult = Lists.newLinkedList();
        RecurringInvoiceItem expected1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, blockStart1, new BigDecimal("2.71"), rate1, this.currency);
        expectedResult.add(expected1);
        RecurringInvoiceItem expected2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockStart1, blockStart2, new BigDecimal("2.71"), rate1, this.currency);
        expectedResult.add(expected2);
        RecurringInvoiceItem expected3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockStart2, endDate, new BigDecimal("3.48"), rate1, this.currency);
        expectedResult.add(expected3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)block1);
        tree.addItem((InvoiceItem)block2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testBlockAcrossPeriod() {
        BigDecimal rate1;
        LocalDate startDate1 = new LocalDate(2014, 1, 1);
        LocalDate blockDate = new LocalDate(2014, 1, 25);
        LocalDate startDate2 = new LocalDate(2014, 2, 1);
        LocalDate unblockDate = new LocalDate(2014, 2, 7);
        LocalDate endDate = new LocalDate(2014, 3, 1);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        RecurringInvoiceItem first = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, startDate2, amount1, rate1, this.currency);
        RecurringInvoiceItem second = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate2, endDate, amount1, rate1, this.currency);
        RepairAdjInvoiceItem block1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockDate, startDate2, amount1.negate(), this.currency, first.getId());
        RepairAdjInvoiceItem block2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate2, unblockDate, amount1.negate(), this.currency, first.getId());
        LinkedList expectedResult = Lists.newLinkedList();
        RecurringInvoiceItem expected1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, blockDate, new BigDecimal("9.29"), rate1, this.currency);
        RecurringInvoiceItem expected2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate, endDate, new BigDecimal("9.43"), rate1, this.currency);
        expectedResult.add(expected1);
        expectedResult.add(expected2);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)first);
        tree.addItem((InvoiceItem)second);
        tree.addItem((InvoiceItem)block1);
        tree.addItem((InvoiceItem)block2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testAnnualFullRepairFollowedByMonthly() {
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate firstMonthlyEndDate = new LocalDate(2014, 2, 1);
        LocalDate secondMonthlyEndDate = new LocalDate(2014, 3, 1);
        LocalDate endDate = new LocalDate(2015, 2, 1);
        BigDecimal amount1 = rate1 = new BigDecimal("120.00");
        BigDecimal amount2 = rate2 = new BigDecimal("10.00");
        RecurringInvoiceItem annual = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, endDate, amount1.negate(), this.currency, annual.getId());
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "someelse", "someelse", startDate, firstMonthlyEndDate, amount2, rate2, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "someelse", "someelse", firstMonthlyEndDate, secondMonthlyEndDate, amount2, rate2, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly1);
        expectedResult.add(monthly2);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)annual);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)annual);
        tree.addItem((InvoiceItem)monthly2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
        tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)annual);
        tree.addItem((InvoiceItem)repair);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMonthlyToAnnualWithLeadingProRation() {
        BigDecimal yearlyRate;
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endMonthly1 = new LocalDate(2014, 2, 1);
        LocalDate endMonthly2 = new LocalDate(2014, 3, 1);
        LocalDate switchToAnnualDate = new LocalDate(2014, 2, 23);
        LocalDate endDate = new LocalDate(2015, 3, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        BigDecimal yearlyAmount = yearlyRate = new BigDecimal("100.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endMonthly1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, endMonthly2, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, switchToAnnualDate, endMonthly2, monthlyAmount.negate(), this.currency, monthly2.getId());
        RecurringInvoiceItem leadingAnnualProration = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", switchToAnnualDate, endMonthly2, yearlyAmount, yearlyRate, this.currency);
        RecurringInvoiceItem annual = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly2, endDate, yearlyAmount, yearlyRate, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly1);
        RecurringInvoiceItem monthly2Prorated = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, switchToAnnualDate, new BigDecimal("9.43"), monthlyRate, this.currency);
        expectedResult.add(monthly2Prorated);
        expectedResult.add(leadingAnnualProration);
        expectedResult.add(annual);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)leadingAnnualProration);
        tree.addItem((InvoiceItem)annual);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMonthlyToAnnualWithNoProRation() {
        BigDecimal yearlyRate;
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endMonthly1 = new LocalDate(2014, 2, 1);
        LocalDate endMonthly2 = new LocalDate(2014, 3, 1);
        LocalDate switchToAnnualDate = new LocalDate(2014, 2, 23);
        LocalDate endDate = new LocalDate(2015, 2, 23);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        BigDecimal yearlyAmount = yearlyRate = new BigDecimal("100.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endMonthly1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, endMonthly2, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, switchToAnnualDate, endMonthly2, monthlyAmount.negate(), this.currency, monthly2.getId());
        RecurringInvoiceItem annual = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", switchToAnnualDate, endDate, yearlyAmount, yearlyRate, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly1);
        RecurringInvoiceItem monthly2Prorated = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, switchToAnnualDate, new BigDecimal("9.43"), monthlyRate, this.currency);
        expectedResult.add(monthly2Prorated);
        expectedResult.add(annual);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repair);
        tree.addItem((InvoiceItem)annual);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testOverlappingRecurring() {
        BigDecimal rate;
        LocalDate startDate1 = new LocalDate(2012, 5, 1);
        LocalDate startDate2 = new LocalDate(2012, 5, 2);
        LocalDate endDate = new LocalDate(2012, 6, 1);
        BigDecimal amount = rate = BigDecimal.TEN;
        RecurringInvoiceItem recurring1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, endDate, amount, rate, this.currency);
        RecurringInvoiceItem recurring2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate2, endDate, amount, rate, this.currency);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)recurring1);
        tree.addItem((InvoiceItem)recurring2);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/664")
    public void testDoubleBillingOnDifferentInvoices() {
        BigDecimal rate;
        LocalDate startDate1 = new LocalDate(2012, 5, 1);
        LocalDate endDate = new LocalDate(2012, 6, 1);
        BigDecimal amount = rate = BigDecimal.TEN;
        RecurringInvoiceItem recurring1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, endDate, amount, rate, this.currency);
        RecurringInvoiceItem recurring2 = new RecurringInvoiceItem(UUID.randomUUID(), this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, endDate, amount, rate, this.currency);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)recurring1);
        tree.addItem((InvoiceItem)recurring2);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"})
    public void testInvalidRepairCausingOverlappingRecurring() {
        BigDecimal rate3;
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate repairDate1 = new LocalDate(2014, 1, 23);
        LocalDate repairDate2 = new LocalDate(2014, 1, 26);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        BigDecimal amount2 = rate2 = new BigDecimal("14.85");
        BigDecimal amount3 = rate3 = new BigDecimal("19.23");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate1, endDate, amount2, rate2, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate1, endDate, amount1.negate(), this.currency, initial.getId());
        RecurringInvoiceItem newItem2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate2, endDate, amount3, rate3, this.currency);
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate2, endDate, amount2.negate(), this.currency, initial.getId());
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)repair2);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)newItem2);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"})
    public void testInvalidRepairCausingOverlappingRecurringV2() {
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate repairDate1 = new LocalDate(2014, 1, 23);
        LocalDate repairDate2 = new LocalDate(2014, 1, 26);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        BigDecimal amount2 = rate2 = new BigDecimal("14.85");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", repairDate1, endDate, amount2, rate2, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, repairDate2, endDate, amount1.negate(), this.currency, initial.getId());
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        try {
            tree.build();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(groups={"fast"})
    public void testOverlappingRepair() {
        BigDecimal rate2;
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2012, 5, 1);
        LocalDate endDate = new LocalDate(2013, 5, 1);
        LocalDate changeDate = new LocalDate(2012, 5, 11);
        LocalDate monthlyAlignmentDate = new LocalDate(2012, 6, 1);
        BigDecimal amount1 = rate1 = new BigDecimal("2400.00");
        BigDecimal amount2 = rate2 = new BigDecimal("300.00");
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, changeDate, endDate, amount1.negate(), this.currency, initial.getId());
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "someelse", "someelse", changeDate, monthlyAlignmentDate, amount2, rate2, this.currency);
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, changeDate, monthlyAlignmentDate, amount2.negate(), this.currency, newItem1.getId());
        RecurringInvoiceItem newItem2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", changeDate, endDate, amount1, rate1, this.currency);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)repair1);
        tree.addItem((InvoiceItem)newItem2);
        tree.addItem((InvoiceItem)repair2);
        LinkedList expectedResult = Lists.newLinkedList();
        RecurringInvoiceItem expected1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, changeDate, new BigDecimal("65.75"), rate1, this.currency);
        expectedResult.add(expected1);
        expectedResult.add(newItem2);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testFullRepairPruneLogic1() {
        BigDecimal monthlyRate;
        LocalDate endDate2;
        LocalDate endDate1;
        LocalDate startDate1 = new LocalDate(2015, 1, 1);
        LocalDate startDate2 = endDate1 = new LocalDate(2015, 2, 1);
        LocalDate startDate3 = endDate2 = new LocalDate(2015, 3, 1);
        LocalDate endDate3 = new LocalDate(2015, 4, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, endDate1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate2, endDate2, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repairMonthly2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate2, endDate2, new BigDecimal("-12.00"), this.currency, monthly2.getId());
        RecurringInvoiceItem monthly3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate3, endDate3, monthlyAmount, monthlyRate, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly1);
        expectedResult.add(monthly3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repairMonthly2);
        tree.addItem((InvoiceItem)monthly3);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testFullRepairPruneLogic2() {
        BigDecimal monthlyRateFinal;
        BigDecimal monthlyRateInit;
        LocalDate endDate2;
        LocalDate endDate1;
        LocalDate startDate1 = new LocalDate(2015, 1, 1);
        LocalDate startDate2 = endDate1 = new LocalDate(2015, 2, 1);
        LocalDate startDate3 = endDate2 = new LocalDate(2015, 3, 1);
        LocalDate endDate3 = new LocalDate(2015, 4, 1);
        BigDecimal monthlyAmountInit = monthlyRateInit = new BigDecimal("12.00");
        BigDecimal monthlyAmountFinal = monthlyRateFinal = new BigDecimal("15.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate1, endDate1, monthlyRateInit, monthlyAmountInit, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate2, endDate2, monthlyRateInit, monthlyAmountInit, this.currency);
        RepairAdjInvoiceItem repairMonthly2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate2, endDate2, new BigDecimal("-12.00"), this.currency, monthly2.getId());
        RecurringInvoiceItem monthly2New = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate2, endDate2, monthlyRateFinal, monthlyAmountFinal, this.currency);
        RecurringInvoiceItem monthly3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate3, endDate3, monthlyRateFinal, monthlyAmountFinal, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly1);
        expectedResult.add(monthly2New);
        expectedResult.add(monthly3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repairMonthly2);
        tree.addItem((InvoiceItem)monthly2New);
        tree.addItem((InvoiceItem)monthly3);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testFullRepairByPartsPruneLogic1() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2015, 2, 1);
        LocalDate intermediate1 = new LocalDate(2015, 2, 8);
        LocalDate intermediate2 = new LocalDate(2015, 2, 16);
        LocalDate intermediate3 = new LocalDate(2015, 2, 24);
        LocalDate endDate = new LocalDate(2015, 3, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair11 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, intermediate1, new BigDecimal("3.00"), this.currency, monthly1.getId());
        RepairAdjInvoiceItem repair12 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate1, intermediate2, new BigDecimal("3.00"), this.currency, monthly1.getId());
        RepairAdjInvoiceItem repair13 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate2, intermediate3, new BigDecimal("3.00"), this.currency, monthly1.getId());
        RepairAdjInvoiceItem repair14 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate3, endDate, new BigDecimal("3.00"), this.currency, monthly1.getId());
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair21 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, intermediate1, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair22 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate1, intermediate2, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair23 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate2, intermediate3, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair24 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate3, endDate, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RecurringInvoiceItem monthly3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)repair11);
        tree.addItem((InvoiceItem)repair12);
        tree.addItem((InvoiceItem)repair13);
        tree.addItem((InvoiceItem)repair14);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repair21);
        tree.addItem((InvoiceItem)repair22);
        tree.addItem((InvoiceItem)repair23);
        tree.addItem((InvoiceItem)repair24);
        tree.addItem((InvoiceItem)monthly3);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testFullRepairByPartsPruneLogic2() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2015, 2, 1);
        LocalDate intermediate1 = new LocalDate(2015, 2, 8);
        LocalDate intermediate2 = new LocalDate(2015, 2, 16);
        LocalDate intermediate3 = new LocalDate(2015, 2, 24);
        LocalDate endDate = new LocalDate(2015, 3, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair11 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, endDate, new BigDecimal("-12.00"), this.currency, monthly1.getId());
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        RepairAdjInvoiceItem repair21 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, intermediate1, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair22 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate1, intermediate2, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair23 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate2, intermediate3, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RepairAdjInvoiceItem repair24 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, intermediate3, endDate, new BigDecimal("3.00"), this.currency, monthly2.getId());
        RecurringInvoiceItem monthly3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(monthly3);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)repair11);
        tree.addItem((InvoiceItem)monthly2);
        tree.addItem((InvoiceItem)repair21);
        tree.addItem((InvoiceItem)repair22);
        tree.addItem((InvoiceItem)repair23);
        tree.addItem((InvoiceItem)repair24);
        tree.addItem((InvoiceItem)monthly3);
        tree.build();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeWithNoExisting() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(proposed1);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeTwoSimilarItems() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeTwoDifferentItems() {
        BigDecimal monthlyRate2;
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        BigDecimal monthlyAmount2 = monthlyRate2 = new BigDecimal("15.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount2, monthlyRate2, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, endDate, monthlyAmount1.negate(), this.currency, monthly1.getId());
        expectedResult.add(proposed1);
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeCancellationWithInitialRepair() {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate blockDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", blockDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, blockDate, new BigDecimal("-9.29"), this.currency, monthly1.getId());
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeCancellationWithFinalRepair() {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate cancelDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, cancelDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, cancelDate, endDate, new BigDecimal("-2.71"), this.currency, monthly1.getId());
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeCancellationWithMiddleRepair() {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate blockDate = new LocalDate(2014, 1, 13);
        LocalDate unblockDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, blockDate, monthlyAmount1, monthlyRate1, this.currency);
        RecurringInvoiceItem proposed2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)proposed2);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockDate, unblockDate, new BigDecimal("-4.65"), this.currency, monthly1.getId());
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeCancellationWithTwoMiddleRepair() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate blockDate1 = new LocalDate(2014, 1, 7);
        LocalDate unblockDate1 = new LocalDate(2014, 1, 13);
        LocalDate blockDate2 = new LocalDate(2014, 1, 17);
        LocalDate unblockDate2 = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.addItem((InvoiceItem)monthly);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, blockDate1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem proposed2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate1, blockDate2, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem proposed3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate2, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)proposed2);
        tree.mergeProposedItem((InvoiceItem)proposed3);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockDate1, unblockDate1, new BigDecimal("-2.32"), this.currency, monthly.getId());
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, blockDate2, unblockDate2, new BigDecimal("-3.10"), this.currency, monthly.getId());
        expectedResult.add(repair1);
        expectedResult.add(repair2);
        this.verifyResult(tree.getView(), expectedResult);
        SubscriptionItemTree treeAgain = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthlyAgain = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        treeAgain.addItem((InvoiceItem)monthlyAgain);
        treeAgain.flatten(true);
        RecurringInvoiceItem proposed2Again = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate1, blockDate2, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem proposed1Again = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, blockDate1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem proposed3Again = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", unblockDate2, endDate, monthlyAmount, monthlyRate, this.currency);
        treeAgain.mergeProposedItem((InvoiceItem)proposed1Again);
        treeAgain.mergeProposedItem((InvoiceItem)proposed2Again);
        treeAgain.mergeProposedItem((InvoiceItem)proposed3Again);
        treeAgain.buildForMerge();
        this.verifyResult(treeAgain.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeUpgradeWithFinalRepair() {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate upgradeDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        BigDecimal monthlyRate2 = new BigDecimal("20.00");
        BigDecimal monthlyAmount2 = monthlyRate1;
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)monthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, upgradeDate, monthlyAmount1, monthlyRate1, this.currency);
        RecurringInvoiceItem proposed2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "foo", "foo", upgradeDate, endDate, monthlyAmount2, monthlyRate2, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)proposed2);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, upgradeDate, endDate, new BigDecimal("-2.71"), this.currency, monthly1.getId());
        expectedResult.add(proposed2);
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeWithSecondRepair() {
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2012, 5, 1);
        LocalDate endDate = new LocalDate(2012, 6, 1);
        LocalDate change1 = new LocalDate(2012, 5, 7);
        LocalDate change2 = new LocalDate(2012, 5, 8);
        BigDecimal amount1 = rate1 = new BigDecimal("599.95");
        BigDecimal rate2 = new BigDecimal("9.95");
        BigDecimal proratedAmount2 = new BigDecimal("8.02");
        BigDecimal rate3 = new BigDecimal("29.95");
        BigDecimal proratedAmount3 = new BigDecimal("23.19");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        RecurringInvoiceItem newItem1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "foo", "foo", change1, endDate, proratedAmount2, rate2, this.currency);
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, change1, endDate, new BigDecimal("-483.86"), this.currency, initial.getId());
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)newItem1);
        tree.addItem((InvoiceItem)repair1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, change1, amount1, rate1, this.currency);
        RecurringInvoiceItem proposed2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "foo", "foo", change1, change2, proratedAmount3, rate2, this.currency);
        RecurringInvoiceItem proposed3 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "bar", "bar", change2, endDate, proratedAmount3, rate3, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)proposed2);
        tree.mergeProposedItem((InvoiceItem)proposed3);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair2 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, change2, endDate, new BigDecimal("-7.70"), this.currency, initial.getId());
        expectedResult.add(proposed3);
        expectedResult.add(repair2);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testWithExistingFixedItem() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        BigDecimal fixedAmount = new BigDecimal("5.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        FixedPriceInvoiceItem fixed = new FixedPriceInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, fixedAmount, this.currency);
        tree.addItem((InvoiceItem)monthly);
        tree.addItem((InvoiceItem)fixed);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)fixed);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testWithNewFixedItem() {
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        BigDecimal fixedAmount = new BigDecimal("5.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem monthly = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        tree.addItem((InvoiceItem)monthly);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount, monthlyRate, this.currency);
        FixedPriceInvoiceItem fixed = new FixedPriceInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, fixedAmount, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.mergeProposedItem((InvoiceItem)fixed);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(fixed);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testRepairWithSmallItemAdjustment() {
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate itemAdjDate = new LocalDate(2014, 1, 2);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate cancelDate = new LocalDate(2014, 1, 23);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        ItemAdjInvoiceItem itemAdj = new ItemAdjInvoiceItem((InvoiceItem)initial, itemAdjDate, new BigDecimal("-2.00"), this.currency);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)itemAdj);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, cancelDate, amount1, rate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, cancelDate, endDate, new BigDecimal("-3.48"), this.currency, initial.getId());
        expectedResult.add(repair1);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testRepairWithLargeItemAdjustment() {
        BigDecimal rate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate itemAdjDate = new LocalDate(2014, 1, 2);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        LocalDate cancelDate = new LocalDate(2014, 1, 23);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem initial = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, amount1, rate1, this.currency);
        ItemAdjInvoiceItem itemAdj = new ItemAdjInvoiceItem((InvoiceItem)initial, itemAdjDate, new BigDecimal("-10.00"), this.currency);
        tree.addItem((InvoiceItem)initial);
        tree.addItem((InvoiceItem)itemAdj);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, cancelDate, amount1, rate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair1 = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, cancelDate, endDate, new BigDecimal("-2.00"), this.currency, initial.getId());
        expectedResult.add(repair1);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void testMergeMonthlyToAnnualWithNoProRation() {
        BigDecimal yearlyRate;
        BigDecimal monthlyRate;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate endMonthly1 = new LocalDate(2014, 2, 1);
        LocalDate endMonthly2 = new LocalDate(2014, 3, 1);
        LocalDate switchToAnnualDate = new LocalDate(2014, 2, 23);
        LocalDate endDate = new LocalDate(2015, 2, 23);
        BigDecimal monthlyAmount = monthlyRate = new BigDecimal("12.00");
        BigDecimal yearlyAmount = yearlyRate = new BigDecimal("100.00");
        RecurringInvoiceItem monthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endMonthly1, monthlyAmount, monthlyRate, this.currency);
        RecurringInvoiceItem monthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, endMonthly2, monthlyAmount, monthlyRate, this.currency);
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        tree.addItem((InvoiceItem)monthly1);
        tree.addItem((InvoiceItem)monthly2);
        tree.flatten(true);
        RecurringInvoiceItem proposed = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", switchToAnnualDate, endDate, yearlyAmount, yearlyRate, this.currency);
        RecurringInvoiceItem proposedMonthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endMonthly1, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposedMonthly1);
        RecurringInvoiceItem proRatedmonthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", endMonthly1, switchToAnnualDate, monthlyAmount, monthlyRate, this.currency);
        tree.mergeProposedItem((InvoiceItem)proRatedmonthly2);
        tree.mergeProposedItem((InvoiceItem)proposed);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, switchToAnnualDate, endMonthly2, new BigDecimal("-2.57"), this.currency, monthly2.getId());
        expectedResult.add(proposed);
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    @Test(groups={"fast"})
    public void verifyJson() throws IOException {
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        UUID id1 = UUID.fromString("e8ba6ce7-9bd4-417d-af53-70951ecaa99f");
        RecurringInvoiceItem yearly1 = new RecurringInvoiceItem(id1, new DateTime(), this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", new LocalDate((Object)"2014-01-01"), new LocalDate((Object)"2015-01-01"), BigDecimal.TEN, BigDecimal.TEN, this.currency);
        tree.addItem((InvoiceItem)yearly1);
        UUID id2 = UUID.fromString("48db1317-9a6e-4666-bcc5-fc7d3d0defc8");
        RecurringInvoiceItem newItem = new RecurringInvoiceItem(id2, new DateTime(), this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "other-plan", "other-plan", new LocalDate((Object)"2014-08-01"), new LocalDate((Object)"2015-01-01"), BigDecimal.ONE, BigDecimal.ONE, this.currency);
        tree.addItem((InvoiceItem)newItem);
        UUID id3 = UUID.fromString("02ec57f5-2723-478b-86ba-ebeaedacb9db");
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(id3, new DateTime(), this.invoiceId, this.accountId, new LocalDate((Object)"2014-08-01"), new LocalDate((Object)"2015-01-01"), BigDecimal.TEN.negate(), this.currency, yearly1.getId());
        tree.addItem((InvoiceItem)repair);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        tree.getRoot().jsonSerializeTree(new ObjectMapper(), (OutputStream)outputStream);
        String json = outputStream.toString("UTF-8");
        String expectedJson = "[{\"start\":\"2014-01-01\",\"end\":\"2015-01-01\",\"items\":[{\"id\":\"e8ba6ce7-9bd4-417d-af53-70951ecaa99f\",\"startDate\":\"2014-01-01\",\"endDate\":\"2015-01-01\",\"amount\":10.00,\"currency\":\"USD\",\"linkedId\":null,\"action\":\"ADD\"}]},[{\"start\":\"2014-08-01\",\"end\":\"2015-01-01\",\"items\":[{\"id\":\"48db1317-9a6e-4666-bcc5-fc7d3d0defc8\",\"startDate\":\"2014-08-01\",\"endDate\":\"2015-01-01\",\"amount\":1.00,\"currency\":\"USD\",\"linkedId\":null,\"action\":\"ADD\"},{\"id\":\"02ec57f5-2723-478b-86ba-ebeaedacb9db\",\"startDate\":\"2014-08-01\",\"endDate\":\"2015-01-01\",\"amount\":10.00,\"currency\":\"USD\",\"linkedId\":\"e8ba6ce7-9bd4-417d-af53-70951ecaa99f\",\"action\":\"CANCEL\"}]}]]";
        Assert.assertEquals((String)json, (String)"[{\"start\":\"2014-01-01\",\"end\":\"2015-01-01\",\"items\":[{\"id\":\"e8ba6ce7-9bd4-417d-af53-70951ecaa99f\",\"startDate\":\"2014-01-01\",\"endDate\":\"2015-01-01\",\"amount\":10.00,\"currency\":\"USD\",\"linkedId\":null,\"action\":\"ADD\"}]},[{\"start\":\"2014-08-01\",\"end\":\"2015-01-01\",\"items\":[{\"id\":\"48db1317-9a6e-4666-bcc5-fc7d3d0defc8\",\"startDate\":\"2014-08-01\",\"endDate\":\"2015-01-01\",\"amount\":1.00,\"currency\":\"USD\",\"linkedId\":null,\"action\":\"ADD\"},{\"id\":\"02ec57f5-2723-478b-86ba-ebeaedacb9db\",\"startDate\":\"2014-08-01\",\"endDate\":\"2015-01-01\",\"amount\":10.00,\"currency\":\"USD\",\"linkedId\":\"e8ba6ce7-9bd4-417d-af53-70951ecaa99f\",\"action\":\"CANCEL\"}]}]]");
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/286")
    public void testMaxedOutProRation() throws IOException {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate cancelDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem existing1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)existing1);
        ItemAdjInvoiceItem existingItemAdj1 = new ItemAdjInvoiceItem((InvoiceItem)existing1, startDate, monthlyRate1.negate(), this.currency);
        tree.addItem((InvoiceItem)existingItemAdj1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, cancelDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        ImmutableList expectedResult = ImmutableList.of((Object)proposed1);
        this.verifyResult(tree.getView(), (List<InvoiceItem>)expectedResult);
    }

    @Test(groups={"fast"})
    public void testPartialProRation() {
        BigDecimal monthlyRate1;
        LocalDate startDate = new LocalDate(2014, 1, 1);
        LocalDate cancelDate = new LocalDate(2014, 1, 25);
        LocalDate endDate = new LocalDate(2014, 2, 1);
        BigDecimal monthlyAmount1 = monthlyRate1 = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem existing1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)existing1);
        ItemAdjInvoiceItem existingItemAdj1 = new ItemAdjInvoiceItem((InvoiceItem)existing1, startDate, monthlyRate1.negate().add(BigDecimal.ONE), this.currency);
        tree.addItem((InvoiceItem)existingItemAdj1);
        tree.flatten(true);
        RecurringInvoiceItem proposed1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, cancelDate, monthlyAmount1, monthlyRate1, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposed1);
        tree.buildForMerge();
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, cancelDate, endDate, BigDecimal.ONE.negate(), Currency.USD, existing1.getId());
        ImmutableList expectedResult = ImmutableList.of((Object)repair);
        this.verifyResult(tree.getView(), (List<InvoiceItem>)expectedResult);
    }

    @Test(groups={"fast"})
    public void testWithWrongInitialItem() throws IOException {
        BigDecimal rate;
        LocalDate wrongStartDate = new LocalDate(2016, 9, 9);
        LocalDate correctStartDate = new LocalDate(2016, 9, 8);
        LocalDate endDate = new LocalDate(2016, 10, 8);
        BigDecimal amount = rate = new BigDecimal("12.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem wrongInitialItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", wrongStartDate, endDate, amount, rate, this.currency);
        tree.addItem((InvoiceItem)wrongInitialItem);
        ItemAdjInvoiceItem itemAdj = new ItemAdjInvoiceItem((InvoiceItem)wrongInitialItem, new LocalDate(2016, 10, 2), amount.negate(), this.currency);
        tree.addItem((InvoiceItem)itemAdj);
        RecurringInvoiceItem correctInitialItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", correctStartDate, endDate, amount, rate, this.currency);
        tree.addItem((InvoiceItem)correctInitialItem);
        Assert.assertEquals((Object)tree.getRoot().getStart(), (Object)correctStartDate);
        Assert.assertEquals((Object)tree.getRoot().getEnd(), (Object)endDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getStart(), (Object)correctStartDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getEnd(), (Object)endDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getLeftChild().getStart(), (Object)wrongStartDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getLeftChild().getEnd(), (Object)endDate);
        Assert.assertNull((Object)tree.getRoot().getLeftChild().getLeftChild().getLeftChild());
        Assert.assertNull((Object)tree.getRoot().getLeftChild().getLeftChild().getRightSibling());
        Assert.assertNull((Object)tree.getRoot().getLeftChild().getRightSibling());
        Assert.assertNull((Object)tree.getRoot().getRightSibling());
        tree.flatten(true);
        Assert.assertEquals((Object)tree.getRoot().getStart(), (Object)correctStartDate);
        Assert.assertEquals((Object)tree.getRoot().getEnd(), (Object)endDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getStart(), (Object)correctStartDate);
        Assert.assertEquals((Object)tree.getRoot().getLeftChild().getEnd(), (Object)endDate);
        Assert.assertNull((Object)tree.getRoot().getLeftChild().getLeftChild());
        Assert.assertNull((Object)tree.getRoot().getLeftChild().getRightSibling());
        Assert.assertNull((Object)tree.getRoot().getRightSibling());
    }

    private void verifyResult(List<InvoiceItem> result, List<InvoiceItem> expectedResult) {
        Assert.assertEquals((int)result.size(), (int)expectedResult.size());
        for (int i = 0; i < expectedResult.size(); ++i) {
            Assert.assertTrue((boolean)result.get(i).matches((Object)expectedResult.get(i)));
        }
    }

    @Test(groups={"fast"})
    public void testWithWrongInitialItemInLoop() {
        BigDecimal rate1;
        LocalDate wrongStartDate = new LocalDate(2016, 9, 9);
        LocalDate correctStartDate = new LocalDate(2016, 9, 8);
        LocalDate endDate = new LocalDate(2016, 10, 8);
        BigDecimal amount1 = rate1 = new BigDecimal("12.00");
        ArrayList<ItemAdjInvoiceItem> existingItems = new ArrayList<ItemAdjInvoiceItem>();
        ArrayList<RecurringInvoiceItem> proposedItems = new ArrayList<RecurringInvoiceItem>();
        RecurringInvoiceItem wrongInitialItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", wrongStartDate, endDate, amount1, rate1, this.currency);
        proposedItems.add(wrongInitialItem);
        int previousExistingSize = existingItems.size();
        int iteration = 0;
        do {
            SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
            for (InvoiceItem invoiceItem : existingItems) {
                tree.addItem(invoiceItem);
            }
            tree.build();
            tree.flatten(true);
            for (InvoiceItem invoiceItem : proposedItems) {
                tree.mergeProposedItem(invoiceItem);
            }
            tree.buildForMerge();
            existingItems.addAll(tree.getView());
            if (iteration == 0) {
                ItemAdjInvoiceItem itemAdj = new ItemAdjInvoiceItem((InvoiceItem)wrongInitialItem, new LocalDate(2016, 10, 2), amount1.negate(), this.currency);
                existingItems.add(itemAdj);
            }
            previousExistingSize = existingItems.size();
            proposedItems.clear();
            RecurringInvoiceItem correctInitialItem = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", correctStartDate, endDate, amount1, rate1, this.currency);
            proposedItems.add(correctInitialItem);
        } while (++iteration < 10);
        Assert.assertEquals((int)previousExistingSize, (int)3);
    }

    @Test(groups={"fast"})
    public void testWithFreeRecurring() {
        LocalDate startDate = new LocalDate(2012, 8, 1);
        LocalDate endDate = new LocalDate(2012, 9, 1);
        BigDecimal monthlyRate1 = new BigDecimal("12.00");
        BigDecimal monthlyRate2 = new BigDecimal("24.00");
        SubscriptionItemTree tree = new SubscriptionItemTree(this.subscriptionId, this.invoiceId);
        RecurringInvoiceItem freeMonthly = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, BigDecimal.ZERO, BigDecimal.ZERO, this.currency);
        tree.addItem((InvoiceItem)freeMonthly);
        RecurringInvoiceItem payingMonthly1 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyRate1, monthlyRate1, this.currency);
        tree.addItem((InvoiceItem)payingMonthly1);
        tree.flatten(true);
        RecurringInvoiceItem proposedPayingMonthly2 = new RecurringInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, "my-plan", "my-phase", startDate, endDate, monthlyRate2, monthlyRate2, this.currency);
        tree.mergeProposedItem((InvoiceItem)proposedPayingMonthly2);
        tree.buildForMerge();
        LinkedList expectedResult = Lists.newLinkedList();
        expectedResult.add(proposedPayingMonthly2);
        RepairAdjInvoiceItem repair = new RepairAdjInvoiceItem(this.invoiceId, this.accountId, startDate, endDate, monthlyRate1.negate(), this.currency, payingMonthly1.getId());
        expectedResult.add(repair);
        this.verifyResult(tree.getView(), expectedResult);
    }

    private void printTreeJSON(SubscriptionItemTree tree) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        tree.getRoot().jsonSerializeTree(OBJECT_MAPPER, (OutputStream)outputStream);
        System.out.println(outputStream.toString("UTF-8"));
    }

    private void printTree(SubscriptionItemTree tree) throws IOException {
        System.out.println(TreePrinter.print((ItemsNodeInterval)tree.getRoot()));
    }

    static {
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

