/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.tree;

import java.math.BigDecimal;
import java.util.SortedMap;
import org.joda.time.LocalDate;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.tree.Item;
import org.killbill.billing.invoice.tree.ItemsNodeInterval;
import org.killbill.billing.invoice.tree.TreePrinter;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTreePrinter
extends InvoiceTestSuiteNoDB {
    private ItemsNodeInterval root;
    private ItemsNodeInterval node11;
    private ItemsNodeInterval node21;
    private ItemsNodeInterval node22;
    private ItemsNodeInterval node12;
    private ItemsNodeInterval node23;
    private ItemsNodeInterval node31;

    @BeforeMethod(groups={"fast"})
    public void setUp() throws Exception {
        InvoiceItem item = (InvoiceItem)Mockito.mock(InvoiceItem.class);
        Mockito.when((Object)item.getAmount()).thenReturn((Object)BigDecimal.ZERO);
        this.root = new ItemsNodeInterval(null, new Item(item, new LocalDate(2016, 1, 1), new LocalDate(2016, 2, 1), null, Item.ItemAction.ADD));
        this.node11 = new ItemsNodeInterval(this.root, new Item(item, new LocalDate(2016, 1, 10), new LocalDate(2016, 1, 15), null, Item.ItemAction.ADD));
        this.node21 = new ItemsNodeInterval(this.node11, new Item(item, new LocalDate(2016, 1, 10), new LocalDate(2016, 1, 12), null, Item.ItemAction.ADD));
        this.node22 = new ItemsNodeInterval(this.node11, new Item(item, new LocalDate(2016, 1, 14), new LocalDate(2016, 1, 15), null, Item.ItemAction.ADD));
        this.node12 = new ItemsNodeInterval(this.root, new Item(item, new LocalDate(2016, 1, 20), new LocalDate(2016, 1, 25), null, Item.ItemAction.ADD));
        this.node23 = new ItemsNodeInterval(this.node12, new Item(item, new LocalDate(2016, 1, 22), new LocalDate(2016, 1, 24), null, Item.ItemAction.ADD));
        this.node31 = new ItemsNodeInterval(this.node23, new Item(item, new LocalDate(2016, 1, 22), new LocalDate(2016, 1, 23), null, Item.ItemAction.ADD));
    }

    @Test(groups={"fast"})
    public void testSimpleTranslate() throws Exception {
        this.root.leftChild = this.node11;
        this.node11.rightSibling = this.node12;
        this.node12.leftChild = this.node23;
        SortedMap coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)4);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(1, -1)), (Object)this.node12);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -2)), (Object)this.node23);
    }

    @Test(groups={"fast"})
    public void testComplexMultiLevelTree() throws Exception {
        SortedMap coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)1);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        this.root.leftChild = this.node11;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)2);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        this.node11.rightSibling = this.node12;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)3);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -1)), (Object)this.node12);
        this.node11.leftChild = this.node21;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)4);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -1)), (Object)this.node12);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-2, -2)), (Object)this.node21);
        this.node21.rightSibling = this.node22;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)5);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -1)), (Object)this.node12);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-2, -2)), (Object)this.node21);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -2)), (Object)this.node22);
        this.node12.leftChild = this.node23;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)6);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(1, -1)), (Object)this.node12);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-2, -2)), (Object)this.node21);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -2)), (Object)this.node22);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -2)), (Object)this.node23);
        this.node23.leftChild = this.node31;
        coords = TreePrinter.buildCoordinates((ItemsNodeInterval)this.root);
        Assert.assertEquals((int)coords.size(), (int)7);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, 0)), (Object)this.root);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -1)), (Object)this.node11);
        Assert.assertEquals(coords.get(new TreePrinter.XY(2, -1)), (Object)this.node12);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-2, -2)), (Object)this.node21);
        Assert.assertEquals(coords.get(new TreePrinter.XY(-1, -2)), (Object)this.node22);
        Assert.assertEquals(coords.get(new TreePrinter.XY(1, -2)), (Object)this.node23);
        Assert.assertEquals(coords.get(new TreePrinter.XY(0, -3)), (Object)this.node31);
    }
}

