/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.usage;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.UsageInvoiceItem;
import org.killbill.billing.invoice.usage.ContiguousIntervalUsageInArrear;
import org.killbill.billing.invoice.usage.DefaultRolledUpUnit;
import org.killbill.billing.invoice.usage.TestUsageInArrearBase;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.usage.RawUsage;
import org.killbill.billing.usage.api.svcs.DefaultRawUsage;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestContiguousIntervalCapacityInArrear
extends TestUsageInArrearBase {
    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        super.beforeClass();
    }

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        super.beforeMethod();
    }

    @Test(groups={"fast"})
    public void testComputeToBeBilledUsage() {
        LocalDate startDate = new LocalDate(2014, 3, 20);
        LocalDate endDate = new LocalDate(2014, 4, 20);
        DefaultUnit unit = new DefaultUnit().setName("unit");
        DefaultLimit limit = new DefaultLimit().setUnit(unit).setMax(Double.valueOf(100.0));
        DefaultTier tier = this.createDefaultTierWithLimits(BigDecimal.TEN, limit);
        DefaultUsage usage = this.createCapacityInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate targetDate = startDate.plusDays(1);
        ContiguousIntervalUsageInArrear intervalCapacityInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)ImmutableList.of(), targetDate, false, this.createMockBillingEvent(targetDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList()));
        ArrayList existingUsage = Lists.newArrayList();
        UsageInvoiceItem ii1 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii1);
        UsageInvoiceItem ii2 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii2);
        UsageInvoiceItem ii3 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate.minusDays(1), endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii3);
        UsageInvoiceItem ii4 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, "other", startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii4);
        FixedPriceInvoiceItem ii5 = new FixedPriceInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, startDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii5);
        Iterable billedItems = intervalCapacityInArrear.getBilledItems(startDate, endDate, (List)existingUsage);
        BigDecimal result = intervalCapacityInArrear.computeBilledUsage(billedItems);
        Assert.assertEquals((int)result.compareTo(BigDecimal.TEN.add(BigDecimal.TEN)), (int)0);
    }

    @Test(groups={"fast"})
    public void testComputeBilledUsage() throws CatalogApiException {
        DefaultUnit unit1 = new DefaultUnit().setName("unit1");
        DefaultUnit unit2 = new DefaultUnit().setName("unit2");
        DefaultLimit limit1_1 = new DefaultLimit().setUnit(unit1).setMax(Double.valueOf(100.0)).setMin(Double.valueOf(-1.0));
        DefaultLimit limit1_2 = new DefaultLimit().setUnit(unit2).setMax(Double.valueOf(1000.0)).setMin(Double.valueOf(-1.0));
        DefaultTier tier1 = this.createDefaultTierWithLimits(BigDecimal.TEN, limit1_1, limit1_2);
        DefaultLimit limit2_1 = new DefaultLimit().setUnit(unit1).setMax(Double.valueOf(200.0)).setMin(Double.valueOf(-1.0));
        DefaultLimit limit2_2 = new DefaultLimit().setUnit(unit2).setMax(Double.valueOf(2000.0)).setMin(Double.valueOf(-1.0));
        DefaultTier tier2 = this.createDefaultTierWithLimits(new BigDecimal("20.0"), limit2_1, limit2_2);
        DefaultLimit limit3_1 = new DefaultLimit().setUnit(unit1).setMin(Double.valueOf(-1.0)).setMax(Double.valueOf(-1.0));
        DefaultLimit limit3_2 = new DefaultLimit().setUnit(unit2).setMin(Double.valueOf(-1.0)).setMax(Double.valueOf(-1.0));
        DefaultTier tier3 = this.createDefaultTierWithLimits(new BigDecimal("30.0"), limit3_1, limit3_2);
        DefaultUsage usage = this.createCapacityInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier1, tier2, tier3);
        LocalDate targetDate = new LocalDate(2014, 3, 20);
        ContiguousIntervalUsageInArrear intervalCapacityInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)ImmutableList.of(), targetDate, false, this.createMockBillingEvent(targetDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList()));
        BigDecimal result = intervalCapacityInArrear.computeToBeBilledCapacityInArrear((List)ImmutableList.of((Object)new DefaultRolledUpUnit("unit1", Long.valueOf(100L)), (Object)new DefaultRolledUpUnit("unit2", Long.valueOf(1000L))));
        Assert.assertEquals((Object)result, (Object)BigDecimal.TEN);
        result = intervalCapacityInArrear.computeToBeBilledCapacityInArrear((List)ImmutableList.of((Object)new DefaultRolledUpUnit("unit1", Long.valueOf(100L)), (Object)new DefaultRolledUpUnit("unit2", Long.valueOf(1001L))));
        Assert.assertEquals((Object)result, (Object)new BigDecimal("20.0"));
        result = intervalCapacityInArrear.computeToBeBilledCapacityInArrear((List)ImmutableList.of((Object)new DefaultRolledUpUnit("unit1", Long.valueOf(101L)), (Object)new DefaultRolledUpUnit("unit2", Long.valueOf(1000L))));
        Assert.assertEquals((Object)result, (Object)new BigDecimal("20.0"));
        result = intervalCapacityInArrear.computeToBeBilledCapacityInArrear((List)ImmutableList.of((Object)new DefaultRolledUpUnit("unit1", Long.valueOf(101L)), (Object)new DefaultRolledUpUnit("unit2", Long.valueOf(1001L))));
        Assert.assertEquals((Object)result, (Object)new BigDecimal("20.0"));
        result = intervalCapacityInArrear.computeToBeBilledCapacityInArrear((List)ImmutableList.of((Object)new DefaultRolledUpUnit("unit1", Long.valueOf(10L)), (Object)new DefaultRolledUpUnit("unit2", Long.valueOf(2001L))));
        Assert.assertEquals((Object)result, (Object)new BigDecimal("30.0"));
    }

    @Test(groups={"fast"})
    public void testComputeMissingItems() throws CatalogApiException {
        LocalDate startDate = new LocalDate(2014, 3, 20);
        LocalDate firstBCDDate = new LocalDate(2014, 4, 15);
        LocalDate endDate = new LocalDate(2014, 5, 15);
        ArrayList<RawUsage> rawUsages = new ArrayList<RawUsage>();
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 3, 20), "unit", Long.valueOf(130L)));
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 3, 21), "unit", Long.valueOf(271L)));
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 4, 15), "unit", Long.valueOf(199L)));
        DefaultUnit unit = new DefaultUnit().setName("unit");
        DefaultLimit limit = new DefaultLimit().setUnit(unit).setMax(Double.valueOf(-1.0));
        DefaultTier tier = this.createDefaultTierWithLimits(BigDecimal.TEN, limit);
        DefaultUsage usage = this.createCapacityInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate targetDate = endDate;
        BillingEvent event1 = this.createMockBillingEvent(startDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        BillingEvent event2 = this.createMockBillingEvent(endDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, rawUsages, targetDate, true, event1, event2);
        ArrayList<UsageInvoiceItem> invoiceItems = new ArrayList<UsageInvoiceItem>();
        UsageInvoiceItem ii1 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, firstBCDDate, BigDecimal.ONE, this.currency);
        invoiceItems.add(ii1);
        UsageInvoiceItem ii2 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), firstBCDDate, endDate, BigDecimal.ONE, this.currency);
        invoiceItems.add(ii2);
        ContiguousIntervalUsageInArrear.UsageInArrearItemsAndNextNotificationDate usageResult = intervalConsumableInArrear.computeMissingItemsAndNextNotificationDate(invoiceItems);
        List rawResults = usageResult.getInvoiceItems();
        Assert.assertEquals((int)rawResults.size(), (int)4);
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)rawResults, (Predicate)new Predicate<InvoiceItem>(){

            public boolean apply(InvoiceItem input) {
                return input.getAmount().compareTo(BigDecimal.ZERO) > 0;
            }
        }));
        Assert.assertEquals((int)((InvoiceItem)result.get(0)).getAmount().compareTo(new BigDecimal("9.0")), (int)0, (String)String.format("%s != 9.0", ((InvoiceItem)result.get(0)).getAmount()));
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getCurrency(), (Object)Currency.BTC);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getAccountId(), (Object)this.accountId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getBundleId(), (Object)this.bundleId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getSubscriptionId(), (Object)this.subscriptionId);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getPlanName(), (String)this.planName);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getPhaseName(), (String)this.phaseName);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getUsageName(), (String)usage.getName());
        Assert.assertTrue((((InvoiceItem)result.get(0)).getStartDate().compareTo((ReadablePartial)startDate) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((InvoiceItem)result.get(0)).getEndDate().compareTo((ReadablePartial)firstBCDDate) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)((InvoiceItem)result.get(1)).getAmount().compareTo(new BigDecimal("9.0")), (int)0, (String)String.format("%s != 9.0", ((InvoiceItem)result.get(0)).getAmount()));
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getCurrency(), (Object)Currency.BTC);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getAccountId(), (Object)this.accountId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getBundleId(), (Object)this.bundleId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getSubscriptionId(), (Object)this.subscriptionId);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getPlanName(), (String)this.planName);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getPhaseName(), (String)this.phaseName);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getUsageName(), (String)usage.getName());
        Assert.assertTrue((((InvoiceItem)result.get(1)).getStartDate().compareTo((ReadablePartial)firstBCDDate) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((InvoiceItem)result.get(1)).getEndDate().compareTo((ReadablePartial)endDate) == 0 ? 1 : 0) != 0);
    }
}

