/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.usage;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.model.FixedPriceInvoiceItem;
import org.killbill.billing.invoice.model.UsageInvoiceItem;
import org.killbill.billing.invoice.usage.ContiguousIntervalUsageInArrear;
import org.killbill.billing.invoice.usage.DefaultRolledUpUnit;
import org.killbill.billing.invoice.usage.TestUsageInArrearBase;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.usage.RawUsage;
import org.killbill.billing.usage.api.RolledUpUnit;
import org.killbill.billing.usage.api.RolledUpUsage;
import org.killbill.billing.usage.api.svcs.DefaultRawUsage;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestContiguousIntervalConsumableInArrear
extends TestUsageInArrearBase {
    private static final Ordering<RolledUpUsage> TEST_ROLLED_UP_FIRST_USAGE_ORDERING = Ordering.natural().onResultOf((Function)new Function<RolledUpUsage, Comparable>(){

        public Comparable apply(RolledUpUsage ru) {
            return ((RolledUpUnit)ru.getRolledUpUnits().get(0)).getUnitType();
        }
    });

    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        super.beforeClass();
    }

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        super.beforeMethod();
    }

    @Test(groups={"fast"})
    public void testComputeToBeBilledUsage() {
        LocalDate startDate = new LocalDate(2014, 3, 20);
        LocalDate endDate = new LocalDate(2014, 4, 20);
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate targetDate = startDate.plusDays(1);
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)ImmutableList.of(), targetDate, false, this.createMockBillingEvent(targetDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList()));
        ArrayList existingUsage = Lists.newArrayList();
        UsageInvoiceItem ii1 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii1);
        UsageInvoiceItem ii2 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii2);
        UsageInvoiceItem ii3 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate.minusDays(1), endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii3);
        UsageInvoiceItem ii4 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, "other", startDate, endDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii4);
        FixedPriceInvoiceItem ii5 = new FixedPriceInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, startDate, BigDecimal.TEN, this.currency);
        existingUsage.add(ii5);
        BigDecimal result = intervalConsumableInArrear.computeBilledUsage(intervalConsumableInArrear.getBilledItems(startDate, endDate, (List)existingUsage));
        Assert.assertEquals((int)result.compareTo(BigDecimal.TEN.add(BigDecimal.TEN)), (int)0);
    }

    @Test(groups={"fast"})
    public void testComputeBilledUsage() throws CatalogApiException {
        DefaultTieredBlock block1 = this.createDefaultTieredBlock("unit", 100, 10, BigDecimal.ONE);
        DefaultTier tier1 = this.createDefaultTierWithBlocks(block1);
        DefaultTieredBlock block2 = this.createDefaultTieredBlock("unit", 1000, 100, BigDecimal.ONE);
        DefaultTier tier2 = this.createDefaultTierWithBlocks(block2);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier1, tier2);
        LocalDate targetDate = new LocalDate(2014, 3, 20);
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)ImmutableList.of(), targetDate, false, this.createMockBillingEvent(targetDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList()));
        BigDecimal result = intervalConsumableInArrear.computeToBeBilledConsumableInArrear((RolledUpUnit)new DefaultRolledUpUnit("unit", Long.valueOf(5325L)));
        Assert.assertEquals((Object)result, (Object)new BigDecimal("15"));
    }

    @Test(groups={"fast"})
    public void testComputeMissingItems() throws CatalogApiException {
        LocalDate startDate = new LocalDate(2014, 3, 20);
        LocalDate firstBCDDate = new LocalDate(2014, 4, 15);
        LocalDate endDate = new LocalDate(2014, 5, 15);
        ArrayList<RawUsage> rawUsages = new ArrayList<RawUsage>();
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 3, 20), "unit", Long.valueOf(130L)));
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 3, 21), "unit", Long.valueOf(271L)));
        rawUsages.add((RawUsage)new DefaultRawUsage(this.subscriptionId, new LocalDate(2014, 4, 15), "unit", Long.valueOf(199L)));
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 10, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate targetDate = endDate;
        BillingEvent event1 = this.createMockBillingEvent(startDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        BillingEvent event2 = this.createMockBillingEvent(endDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, rawUsages, targetDate, true, event1, event2);
        ArrayList<UsageInvoiceItem> invoiceItems = new ArrayList<UsageInvoiceItem>();
        UsageInvoiceItem ii1 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), startDate, firstBCDDate, BigDecimal.ONE, this.currency);
        invoiceItems.add(ii1);
        UsageInvoiceItem ii2 = new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, usage.getName(), firstBCDDate, endDate, BigDecimal.ONE, this.currency);
        invoiceItems.add(ii2);
        ContiguousIntervalUsageInArrear.UsageInArrearItemsAndNextNotificationDate usageResult = intervalConsumableInArrear.computeMissingItemsAndNextNotificationDate(invoiceItems);
        List rawResults = usageResult.getInvoiceItems();
        Assert.assertEquals((int)rawResults.size(), (int)4);
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)rawResults, (Predicate)new Predicate<InvoiceItem>(){

            public boolean apply(InvoiceItem input) {
                return input.getAmount().compareTo(BigDecimal.ZERO) > 0;
            }
        }));
        Assert.assertEquals((int)((InvoiceItem)result.get(0)).getAmount().compareTo(new BigDecimal("4.0")), (int)0, (String)String.format("%s != 4.0", ((InvoiceItem)result.get(0)).getAmount()));
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getCurrency(), (Object)Currency.BTC);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getAccountId(), (Object)this.accountId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getBundleId(), (Object)this.bundleId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(0)).getSubscriptionId(), (Object)this.subscriptionId);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getPlanName(), (String)this.planName);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getPhaseName(), (String)this.phaseName);
        Assert.assertEquals((String)((InvoiceItem)result.get(0)).getUsageName(), (String)usage.getName());
        Assert.assertTrue((((InvoiceItem)result.get(0)).getStartDate().compareTo((ReadablePartial)startDate) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((InvoiceItem)result.get(0)).getEndDate().compareTo((ReadablePartial)firstBCDDate) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)((InvoiceItem)result.get(1)).getAmount().compareTo(new BigDecimal("1.0")), (int)0, (String)String.format("%s != 1.0", ((InvoiceItem)result.get(0)).getAmount()));
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getCurrency(), (Object)Currency.BTC);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getAccountId(), (Object)this.accountId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getBundleId(), (Object)this.bundleId);
        Assert.assertEquals((Object)((InvoiceItem)result.get(1)).getSubscriptionId(), (Object)this.subscriptionId);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getPlanName(), (String)this.planName);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getPhaseName(), (String)this.phaseName);
        Assert.assertEquals((String)((InvoiceItem)result.get(1)).getUsageName(), (String)usage.getName());
        Assert.assertTrue((((InvoiceItem)result.get(1)).getStartDate().compareTo((ReadablePartial)firstBCDDate) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((InvoiceItem)result.get(1)).getEndDate().compareTo((ReadablePartial)endDate) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testGetRolledUpUsage() {
        DefaultTieredBlock tieredBlock1 = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTieredBlock tieredBlock2 = this.createDefaultTieredBlock("unit2", 10, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(tieredBlock1, tieredBlock2);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate t0 = new LocalDate(2015, 3, this.BCD);
        BillingEvent eventT0 = this.createMockBillingEvent(t0.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate t1 = new LocalDate(2015, 4, this.BCD);
        BillingEvent eventT1 = this.createMockBillingEvent(t1.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate t2 = new LocalDate(2015, 5, this.BCD);
        BillingEvent eventT2 = this.createMockBillingEvent(t2.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate t3 = new LocalDate(2015, 6, this.BCD);
        BillingEvent eventT3 = this.createMockBillingEvent(t3.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate targetDate = t3;
        DefaultRawUsage raw1 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 3, 1), "unit", Long.valueOf(12L));
        DefaultRawUsage raw2 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 3, 15), "unit", Long.valueOf(6L));
        DefaultRawUsage raw3 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 3, 25), "unit", Long.valueOf(4L));
        DefaultRawUsage raw4 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 5, 15), "unit", Long.valueOf(13L));
        DefaultRawUsage oraw1 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 5, 21), "unit2", Long.valueOf(21L));
        DefaultRawUsage raw5 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 5, 31), "unit", Long.valueOf(7L));
        DefaultRawUsage raw6 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 6, 15), "unit", Long.valueOf(100L));
        ImmutableList rawUsage = ImmutableList.of((Object)raw1, (Object)raw2, (Object)raw3, (Object)raw4, (Object)oraw1, (Object)raw5, (Object)raw6);
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)rawUsage, targetDate, true, eventT0, eventT1, eventT2, eventT3);
        List unsortedRolledUpUsage = intervalConsumableInArrear.getRolledUpUsage();
        Assert.assertEquals((int)unsortedRolledUpUsage.size(), (int)2);
        List rolledUpUsage = TEST_ROLLED_UP_FIRST_USAGE_ORDERING.sortedCopy((Iterable)unsortedRolledUpUsage);
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(0)).getStart().compareTo((ReadablePartial)t0), (int)0);
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(0)).getEnd().compareTo((ReadablePartial)t1), (int)0);
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(0)).getRolledUpUnits().size(), (int)1);
        Assert.assertEquals((String)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(0)).getRolledUpUnits().get(0)).getUnitType(), (String)"unit");
        Assert.assertEquals((Object)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(0)).getRolledUpUnits().get(0)).getAmount(), (Object)new Long(10L));
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(1)).getStart().compareTo((ReadablePartial)t2), (int)0);
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(1)).getEnd().compareTo((ReadablePartial)t3), (int)0);
        Assert.assertEquals((int)((RolledUpUsage)rolledUpUsage.get(1)).getRolledUpUnits().size(), (int)2);
        Assert.assertEquals((String)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(1)).getRolledUpUnits().get(0)).getUnitType(), (String)"unit");
        Assert.assertEquals((Object)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(1)).getRolledUpUnits().get(0)).getAmount(), (Object)new Long(20L));
        Assert.assertEquals((String)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(1)).getRolledUpUnits().get(1)).getUnitType(), (String)"unit2");
        Assert.assertEquals((Object)((RolledUpUnit)((RolledUpUsage)rolledUpUsage.get(1)).getRolledUpUnits().get(1)).getAmount(), (Object)new Long(21L));
    }

    @Test(groups={"fast"}, description="See https://github.com/killbill/killbill/issues/706")
    public void testWithRawUsageStartDateAfterEndDate() throws CatalogApiException {
        LocalDate startDate;
        LocalDate endDate;
        LocalDate targetDate = endDate = (startDate = new LocalDate(2014, 10, 16));
        LocalDate rawUsageStartDate = new LocalDate(2015, 10, 16);
        ArrayList<DefaultRawUsage> rawUsages = new ArrayList<DefaultRawUsage>();
        rawUsages.add(new DefaultRawUsage(this.subscriptionId, startDate, "unit", Long.valueOf(130L)));
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 10, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        BillingEvent event1 = this.createMockBillingEvent(startDate.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        BillingEvent event2 = this.createMockBillingEvent(new LocalDate(2014, 10, 16).toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = new ContiguousIntervalUsageInArrear((Usage)usage, this.accountId, this.invoiceId, rawUsages, targetDate, rawUsageStartDate, (InternalTenantContext)this.internalCallContext);
        intervalConsumableInArrear.addBillingEvent(event1);
        intervalConsumableInArrear.addBillingEvent(event2);
        ContiguousIntervalUsageInArrear res = intervalConsumableInArrear.build(true);
        Assert.assertEquals((int)res.getTransitionTimes().size(), (int)0);
    }

    @Test(groups={"fast"})
    public void testGetRolledUpUsageOnlyUsageBeforeTransitionTime() {
        DefaultTieredBlock tieredBlock1 = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTieredBlock tieredBlock2 = this.createDefaultTieredBlock("unit2", 10, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(tieredBlock1, tieredBlock2);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        LocalDate t0 = new LocalDate(2015, 3, this.BCD);
        BillingEvent eventT0 = this.createMockBillingEvent(t0.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate t1 = new LocalDate(2015, 4, this.BCD);
        BillingEvent eventT1 = this.createMockBillingEvent(t1.toDateTimeAtStartOfDay(DateTimeZone.UTC), BillingPeriod.MONTHLY, Collections.<Usage>emptyList());
        LocalDate targetDate = t1;
        DefaultRawUsage raw1 = new DefaultRawUsage(this.subscriptionId, new LocalDate(2015, 3, 1), "unit", Long.valueOf(12L));
        ImmutableList rawUsage = ImmutableList.of((Object)raw1);
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = this.createContiguousIntervalConsumableInArrear(usage, (List<RawUsage>)rawUsage, targetDate, true, eventT0, eventT1);
        List unsortedRolledUpUsage = intervalConsumableInArrear.getRolledUpUsage();
        Assert.assertEquals((int)unsortedRolledUpUsage.size(), (int)0);
    }
}

