/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.usage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.model.UsageInvoiceItem;
import org.killbill.billing.invoice.usage.TestUsageInArrearBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRawUsageOptimizer
extends TestUsageInArrearBase {
    @Test(groups={"fast"})
    public void testWithNoItems() {
        LocalDate firstEventStartDate = new LocalDate(2014, 3, 15);
        ArrayList invoiceItems = new ArrayList();
        HashMap<String, DefaultUsage> knownUsage = new HashMap<String, DefaultUsage>();
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        knownUsage.put(this.usageName, usage);
        LocalDate result = this.rawUsageOptimizer.getOptimizedRawUsageStartDate(firstEventStartDate, firstEventStartDate.plusDays(1), invoiceItems, knownUsage, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)result.compareTo((ReadablePartial)firstEventStartDate), (int)0);
    }

    @Test(groups={"fast"})
    public void testWithOneMonthlyUsageSectionTooFewItems() {
        LocalDate firstEventStartDate = new LocalDate(2014, 3, 15);
        ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
        invoiceItems.add(this.createUsageItem(firstEventStartDate));
        LocalDate targetDate = ((InvoiceItem)invoiceItems.get(invoiceItems.size() - 1)).getEndDate();
        HashMap<String, DefaultUsage> knownUsage = new HashMap<String, DefaultUsage>();
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        knownUsage.put(this.usageName, usage);
        LocalDate result = this.rawUsageOptimizer.getOptimizedRawUsageStartDate(firstEventStartDate, targetDate, invoiceItems, knownUsage, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)result.compareTo((ReadablePartial)firstEventStartDate), (int)0);
    }

    @Test(groups={"fast"})
    public void testWithOneMonthlyUsageSectionAndEnoughUsageItems() {
        LocalDate firstEventStartDate = new LocalDate(2014, 3, 15);
        ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
        for (int i = 0; i < 5; ++i) {
            invoiceItems.add(this.createUsageItem(firstEventStartDate.plusMonths(i)));
        }
        LocalDate targetDate = ((InvoiceItem)invoiceItems.get(invoiceItems.size() - 1)).getEndDate();
        HashMap<String, DefaultUsage> knownUsage = new HashMap<String, DefaultUsage>();
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        knownUsage.put(this.usageName, usage);
        LocalDate result = this.rawUsageOptimizer.getOptimizedRawUsageStartDate(firstEventStartDate, targetDate, invoiceItems, knownUsage, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)result.compareTo((ReadablePartial)new LocalDate(2014, 6, 15)), (int)0, (String)("112 got " + result));
    }

    @Test(groups={"fast"})
    public void testWithOneMonthlyAndOneNonActiveAnnualUsageSectionAndEnoughUsageItems() {
        LocalDate firstEventStartDate = new LocalDate(2014, 3, 15);
        ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
        for (int i = 0; i < 5; ++i) {
            invoiceItems.add(this.createUsageItem(firstEventStartDate.plusMonths(i)));
        }
        LocalDate targetDate = ((InvoiceItem)invoiceItems.get(invoiceItems.size() - 1)).getEndDate();
        HashMap<String, DefaultUsage> knownUsage = new HashMap<String, DefaultUsage>();
        DefaultTieredBlock block = this.createDefaultTieredBlock("unit", 100, 1000, BigDecimal.ONE);
        DefaultTier tier = this.createDefaultTierWithBlocks(block);
        DefaultUsage usage = this.createConsumableInArrearUsage(this.usageName, BillingPeriod.MONTHLY, tier);
        knownUsage.put(this.usageName, usage);
        DefaultTieredBlock block2 = this.createDefaultTieredBlock("unit2", 10, 10000, BigDecimal.TEN);
        DefaultTier tier2 = this.createDefaultTierWithBlocks(block2);
        DefaultUsage usage2 = this.createConsumableInArrearUsage("usageName2", BillingPeriod.ANNUAL, tier2);
        knownUsage.put("usageName2", usage2);
        LocalDate result = this.rawUsageOptimizer.getOptimizedRawUsageStartDate(firstEventStartDate, targetDate, invoiceItems, knownUsage, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)result.compareTo((ReadablePartial)new LocalDate(2014, 6, 15)), (int)0, (String)("142 got " + result));
    }

    private InvoiceItem createUsageItem(LocalDate startDate) {
        return new UsageInvoiceItem(this.invoiceId, this.accountId, this.bundleId, this.subscriptionId, this.planName, this.phaseName, this.usageName, startDate, startDate.plusMonths(1), BigDecimal.TEN, Currency.USD);
    }
}

