/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.usage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.invoice.usage.ContiguousIntervalUsageInArrear;
import org.killbill.billing.invoice.usage.SubscriptionUsageInArrear;
import org.killbill.billing.invoice.usage.TestUsageInArrearBase;
import org.killbill.billing.junction.BillingEvent;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSubscriptionConsumableInArrear
extends TestUsageInArrearBase {
    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        super.beforeClass();
    }

    @Test(groups={"fast"})
    public void testComputeInArrearUsageInterval() {
        ArrayList billingEvents = Lists.newArrayList();
        String usageName1 = "erw";
        DefaultTieredBlock block1 = this.createDefaultTieredBlock("unit", 100, 10, BigDecimal.ONE);
        DefaultTier tier1 = this.createDefaultTierWithBlocks(block1);
        DefaultUsage usage1 = this.createConsumableInArrearUsage("erw", BillingPeriod.MONTHLY, tier1);
        String usageName2 = "hghg";
        DefaultTieredBlock block2 = this.createDefaultTieredBlock("unit", 100, 10, BigDecimal.ONE);
        DefaultTier tier2 = this.createDefaultTierWithBlocks(block2);
        DefaultUsage usage2 = this.createConsumableInArrearUsage("hghg", BillingPeriod.MONTHLY, tier2);
        DateTime dt1 = new DateTime(2013, 3, 23, 4, 34, 59, DateTimeZone.UTC);
        BillingEvent evt1 = this.createMockBillingEvent(dt1, BillingPeriod.MONTHLY, (List<Usage>)ImmutableList.builder().add((Object)usage1).add((Object)usage2).build());
        billingEvents.add(evt1);
        DateTime dt2 = new DateTime(2013, 4, 23, 4, 34, 59, DateTimeZone.UTC);
        BillingEvent evt2 = this.createMockBillingEvent(dt2, BillingPeriod.MONTHLY, (List<Usage>)ImmutableList.builder().add((Object)usage1).build());
        billingEvents.add(evt2);
        DateTime dt3 = new DateTime(2013, 5, 23, 4, 34, 59, DateTimeZone.UTC);
        BillingEvent evt3 = this.createMockBillingEvent(dt3, BillingPeriod.MONTHLY, (List<Usage>)ImmutableList.builder().add((Object)usage1).add((Object)usage2).build());
        billingEvents.add(evt3);
        LocalDate targetDate = new LocalDate(2013, 6, 23);
        SubscriptionUsageInArrear foo = new SubscriptionUsageInArrear(this.accountId, this.invoiceId, (List)billingEvents, (List)ImmutableList.of(), targetDate, new LocalDate((Object)dt1, DateTimeZone.UTC), (InternalTenantContext)this.internalCallContext);
        List result = foo.computeInArrearUsageInterval();
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((ContiguousIntervalUsageInArrear)result.get(0)).getUsage().getName(), (String)"hghg");
        Assert.assertEquals((int)((ContiguousIntervalUsageInArrear)result.get(0)).getTransitionTimes().size(), (int)3);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(0)).getTransitionTimes().get(0)).compareTo((ReadablePartial)new LocalDate(2013, 3, 23)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(0)).getTransitionTimes().get(1)).compareTo((ReadablePartial)new LocalDate(2013, 4, 15)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(0)).getTransitionTimes().get(2)).compareTo((ReadablePartial)new LocalDate(2013, 4, 23)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)((ContiguousIntervalUsageInArrear)result.get(1)).getUsage().getName(), (String)"erw");
        Assert.assertEquals((int)((ContiguousIntervalUsageInArrear)result.get(1)).getTransitionTimes().size(), (int)4);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(1)).getTransitionTimes().get(0)).compareTo((ReadablePartial)new LocalDate(2013, 3, 23)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(1)).getTransitionTimes().get(1)).compareTo((ReadablePartial)new LocalDate(2013, 4, 15)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(1)).getTransitionTimes().get(2)).compareTo((ReadablePartial)new LocalDate(2013, 5, 15)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(1)).getTransitionTimes().get(3)).compareTo((ReadablePartial)new LocalDate(2013, 6, 15)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)((ContiguousIntervalUsageInArrear)result.get(2)).getUsage().getName(), (String)"hghg");
        Assert.assertEquals((int)((ContiguousIntervalUsageInArrear)result.get(2)).getTransitionTimes().size(), (int)2);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(2)).getTransitionTimes().get(0)).compareTo((ReadablePartial)new LocalDate(2013, 5, 23)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((((LocalDate)((ContiguousIntervalUsageInArrear)result.get(2)).getTransitionTimes().get(1)).compareTo((ReadablePartial)new LocalDate(2013, 6, 15)) == 0 ? 1 : 0) != 0);
    }
}

