/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.usage;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.usage.ContiguousIntervalUsageInArrear;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.usage.RawUsage;
import org.mockito.Mockito;
import org.testng.annotations.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestUsageInArrearBase
extends InvoiceTestSuiteNoDB {
    protected int BCD;
    protected UUID accountId;
    protected UUID bundleId;
    protected UUID subscriptionId;
    protected UUID invoiceId;
    protected String planName;
    protected String phaseName;
    protected Currency currency;
    protected String usageName;

    @Override
    @BeforeClass(groups={"fast"})
    protected void beforeClass() throws Exception {
        super.beforeClass();
        this.BCD = 15;
        this.usageName = "foo";
        this.accountId = UUID.randomUUID();
        this.bundleId = UUID.randomUUID();
        this.subscriptionId = UUID.randomUUID();
        this.invoiceId = UUID.randomUUID();
        this.planName = "planName";
        this.phaseName = "phaseName";
        this.currency = Currency.BTC;
    }

    protected ContiguousIntervalUsageInArrear createContiguousIntervalConsumableInArrear(DefaultUsage usage, List<RawUsage> rawUsages, LocalDate targetDate, boolean closedInterval, BillingEvent ... events) {
        ContiguousIntervalUsageInArrear intervalConsumableInArrear = new ContiguousIntervalUsageInArrear((Usage)usage, this.accountId, this.invoiceId, rawUsages, targetDate, new LocalDate((Object)events[0].getEffectiveDate()), (InternalTenantContext)this.internalCallContext);
        for (BillingEvent event : events) {
            intervalConsumableInArrear.addBillingEvent(event);
        }
        intervalConsumableInArrear.build(closedInterval);
        return intervalConsumableInArrear;
    }

    protected DefaultUsage createConsumableInArrearUsage(String usageName, BillingPeriod billingPeriod, DefaultTier ... tiers) {
        DefaultUsage usage = new DefaultUsage();
        usage.setName(usageName);
        usage.setBillingMode(BillingMode.IN_ARREAR);
        usage.setUsageType(UsageType.CONSUMABLE);
        usage.setBillingPeriod(billingPeriod);
        usage.setTiers(tiers);
        return usage;
    }

    protected DefaultUsage createCapacityInArrearUsage(String usageName, BillingPeriod billingPeriod, DefaultTier ... tiers) {
        DefaultUsage usage = new DefaultUsage();
        usage.setName(usageName);
        usage.setBillingMode(BillingMode.IN_ARREAR);
        usage.setUsageType(UsageType.CAPACITY);
        usage.setBillingPeriod(billingPeriod);
        usage.setTiers(tiers);
        return usage;
    }

    protected DefaultTier createDefaultTierWithBlocks(DefaultTieredBlock ... blocks) {
        DefaultTier tier = new DefaultTier();
        tier.setBlocks(blocks);
        return tier;
    }

    protected DefaultTier createDefaultTierWithLimits(BigDecimal recurringAmountInCurrency, DefaultLimit ... limits) {
        DefaultTier tier = new DefaultTier();
        tier.setLimits(limits);
        DefaultPrice[] prices = new DefaultPrice[]{new DefaultPrice().setCurrency(this.currency).setValue(recurringAmountInCurrency)};
        DefaultInternationalPrice price = new DefaultInternationalPrice().setPrices(prices);
        tier.setRecurringPrice(price);
        return tier;
    }

    protected DefaultTieredBlock createDefaultTieredBlock(String unit, int size, int max, BigDecimal btcPrice) {
        DefaultTieredBlock block = new DefaultTieredBlock();
        block.setUnit(new DefaultUnit().setName(unit));
        block.setSize(new Double(size));
        DefaultPrice[] prices = new DefaultPrice[]{new DefaultPrice()};
        prices[0].setCurrency(Currency.BTC).setValue(btcPrice);
        block.setPrice(new DefaultInternationalPrice().setPrices(prices));
        block.setMax(new Double(max));
        return block;
    }

    protected BillingEvent createMockBillingEvent(DateTime effectiveDate, BillingPeriod billingPeriod, List<Usage> usages) {
        BillingEvent result = (BillingEvent)Mockito.mock(BillingEvent.class);
        Mockito.when((Object)result.getCurrency()).thenReturn((Object)Currency.BTC);
        Mockito.when((Object)result.getBillCycleDayLocal()).thenReturn((Object)this.BCD);
        Mockito.when((Object)result.getEffectiveDate()).thenReturn((Object)effectiveDate);
        Mockito.when((Object)result.getBillingPeriod()).thenReturn((Object)billingPeriod);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getId()).thenReturn((Object)this.accountId);
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)this.subscriptionId);
        Mockito.when((Object)subscription.getBundleId()).thenReturn((Object)this.bundleId);
        Mockito.when((Object)result.getSubscription()).thenReturn((Object)subscription);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)this.planName);
        Mockito.when((Object)result.getPlan()).thenReturn((Object)plan);
        PlanPhase phase = (PlanPhase)Mockito.mock(PlanPhase.class);
        Mockito.when((Object)phase.getName()).thenReturn((Object)this.phaseName);
        Mockito.when((Object)result.getPlanPhase()).thenReturn((Object)phase);
        Mockito.when((Object)result.getUsages()).thenReturn(usages);
        return result;
    }
}

