/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface LifecycleHandlerType {
    public LifecycleLevel value();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LifecycleLevel {
        BOOT(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        LOAD_CATALOG(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        INIT_BUS(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        INIT_PLUGIN(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        INIT_SERVICE(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        START_PLUGIN(Sequence.STARTUP_PRE_EVENT_REGISTRATION),
        START_SERVICE(Sequence.STARTUP_POST_EVENT_REGISTRATION),
        STOP_SERVICE(Sequence.SHUTDOWN_PRE_EVENT_UNREGISTRATION),
        STOP_PLUGIN(Sequence.SHUTDOWN_PRE_EVENT_UNREGISTRATION),
        STOP_BUS(Sequence.SHUTDOWN_POST_EVENT_UNREGISTRATION),
        SHUTDOWN(Sequence.SHUTDOWN_POST_EVENT_UNREGISTRATION);

        private final Sequence seq;

        private LifecycleLevel(Sequence seq) {
            this.seq = seq;
        }

        public Sequence getSequence() {
            return this.seq;
        }

        public static List<LifecycleLevel> getLevelsForSequence(Sequence seq) {
            ArrayList<LifecycleLevel> result = new ArrayList<LifecycleLevel>();
            for (LifecycleLevel level : LifecycleLevel.values()) {
                if (level.getSequence() != seq) continue;
                result.add(level);
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Sequence {
            STARTUP_PRE_EVENT_REGISTRATION,
            STARTUP_POST_EVENT_REGISTRATION,
            SHUTDOWN_PRE_EVENT_UNREGISTRATION,
            SHUTDOWN_POST_EVENT_UNREGISTRATION;

        }
    }
}

