/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.xmlloader.UriAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKillbillConfigSource
implements KillbillConfigSource,
OSGIConfigProperties {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKillbillConfigSource.class);
    private static final String PROPERTIES_FILE = "org.killbill.server.properties";
    private static final String GMT_ID = "GMT";
    private final Properties properties;

    public DefaultKillbillConfigSource() throws IOException, URISyntaxException {
        this((String)null);
    }

    public DefaultKillbillConfigSource(Map<String, String> extraDefaultProperties) throws IOException, URISyntaxException {
        this(null, extraDefaultProperties);
    }

    public DefaultKillbillConfigSource(@Nullable String file) throws URISyntaxException, IOException {
        this(file, (Map<String, String>)ImmutableMap.of());
    }

    public DefaultKillbillConfigSource(@Nullable String file, Map<String, String> extraDefaultProperties) throws URISyntaxException, IOException {
        if (file == null) {
            this.properties = this.loadPropertiesFromFileOrSystemProperties();
        } else {
            this.properties = new Properties();
            this.properties.load(UriAccessor.accessUri((URI)this.getClass().getResource(file).toURI()));
        }
        for (String key : extraDefaultProperties.keySet()) {
            String value = extraDefaultProperties.get(key);
            if (value == null) continue;
            this.properties.put(key, value);
        }
        this.populateDefaultProperties();
    }

    public String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadPropertiesFromFileOrSystemProperties() {
        String propertiesFileLocation = System.getProperty(PROPERTIES_FILE);
        if (propertiesFileLocation != null) {
            try {
                Properties properties = new Properties();
                properties.load(UriAccessor.accessUri((String)propertiesFileLocation));
                return properties;
            }
            catch (IOException e) {
                logger.warn("Unable to access properties file, defaulting to system properties", (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.warn("Unable to access properties file, defaulting to system properties", (Throwable)e);
            }
        }
        return System.getProperties();
    }

    @VisibleForTesting
    protected void populateDefaultProperties() {
        Properties defaultProperties = this.getDefaultProperties();
        for (String propertyName : defaultProperties.stringPropertyNames()) {
            if (this.properties.get(propertyName) != null) continue;
            this.properties.put(propertyName, defaultProperties.get(propertyName));
        }
        Properties defaultSystemProperties = this.getDefaultSystemProperties();
        for (String propertyName : defaultSystemProperties.stringPropertyNames()) {
            if (propertyName.equals("user.timezone")) {
                if (!GMT_ID.equals(System.getProperty(propertyName))) {
                    logger.warn("!!!  Naughty overwrite of user.timezone system property with {} may break database serialization of date. Kill Bill will overwrite to GMT !!!", (Object)System.getProperty(propertyName));
                }
                System.setProperty(propertyName, GMT_ID);
                TimeZone.setDefault(TimeZone.getTimeZone(GMT_ID));
                continue;
            }
            if (System.getProperty(propertyName) != null) continue;
            System.setProperty(propertyName, defaultSystemProperties.get(propertyName).toString());
        }
    }

    @VisibleForTesting
    public void setProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    @VisibleForTesting
    protected Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put("org.killbill.persistent.bus.external.tableName", "bus_ext_events");
        properties.put("org.killbill.persistent.bus.external.historyTableName", "bus_ext_events_history");
        return properties;
    }

    @VisibleForTesting
    protected Properties getDefaultSystemProperties() {
        Properties properties = new Properties();
        properties.put("user.timezone", GMT_ID);
        properties.put("ANTLR_USE_DIRECT_CLASS_LOADING", "true");
        properties.put("org.slf4j.simpleLogger.log.jdbc", "ERROR");
        properties.put("log4jdbc.dump.sql.maxlinelength", "0");
        properties.put("log4jdbc.spylogdelegator.name", "net.sf.log4jdbc.log.slf4j.Slf4jSpyLogDelegator");
        return properties;
    }
}

