/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.jndi;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceProxy
implements DataSource {
    private static final Map<String, DataSource> delegates = new ConcurrentHashMap<String, DataSource>();
    private final DataSource delegate;

    public static <T extends DataSource> void addDelegate(String dataSourceId, T dataSource) {
        delegates.put(dataSourceId, dataSource);
    }

    public static DataSource getDelegate(String dataSourceId) {
        return delegates.get(dataSourceId);
    }

    public DataSourceProxy(String dataSourceId) {
        this.delegate = delegates.get(dataSourceId);
        Preconditions.checkNotNull((Object)this.delegate, (Object)("DataSource delegate for id " + dataSourceId + " hasn't been configured!"));
    }

    public DataSource getDelegate() {
        return this.delegate;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDelegate().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDelegate().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDelegate().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDelegate().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDelegate().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDelegate().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDelegate().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDelegate().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDelegate().isWrapperFor(iface);
    }
}

