/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.jndi;

import com.google.common.base.Preconditions;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceableDataSourceSpyFactory
implements ObjectFactory {
    public static final String DATA_SOURCE_ID = "dataSourceId";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Reference reference = (Reference)obj;
            RefAddr dataSourceIdAddr = reference.get(DATA_SOURCE_ID);
            Preconditions.checkNotNull((Object)dataSourceIdAddr);
            String dataSourceId = (String)dataSourceIdAddr.getContent();
            Preconditions.checkNotNull((Object)dataSourceId);
            return new ReferenceableDataSourceSpy(dataSourceId);
        }
        return null;
    }
}

