/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.config;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultKillbillConfigSource {
    private static final String ENABLE_JASYPT_PROPERTY = "org.killbill.server.enableJasypt";
    private static final String JASYPT_ENCRYPTOR_PASSWORD_PROPERTY = "JASYPT_ENCRYPTOR_PASSWORD";
    private static final String JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY = "JASYPT_ENCRYPTOR_ALGORITHM";
    private static final String JASYPT_PASSWORD = "top_secret!";
    private static final String JASYPT_ALGORITHM = "PBEWITHMD5ANDDES";
    private static final String ENCRYPTED_PROPERTY_1 = "test.encrypted.property1";
    private static final String ENCRYPTED_PROPERTY_2 = "test.encrypted.property2";

    @BeforeMethod(groups={"fast"})
    public void setup() {
        System.clearProperty(ENABLE_JASYPT_PROPERTY);
        System.clearProperty(JASYPT_PASSWORD);
        System.clearProperty(JASYPT_ALGORITHM);
        System.clearProperty(ENCRYPTED_PROPERTY_1);
        System.clearProperty(ENCRYPTED_PROPERTY_2);
    }

    @Test(groups={"fast"})
    public void testFromEnvVariableName() throws IOException, URISyntaxException {
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource();
        Assert.assertEquals((String)configSource.fromEnvVariableName(""), (String)"");
        Assert.assertEquals((String)configSource.fromEnvVariableName("KB_org_killbill_billing_osgi_dao_prepStmtCacheSize"), (String)"org.killbill.billing.osgi.dao.prepStmtCacheSize");
        Assert.assertEquals((String)configSource.fromEnvVariableName("KB_org_killbill_billing_osgi_dao__prepStmtCacheSize"), (String)"org.killbill.billing.osgi.dao..prepStmtCacheSize");
    }

    @Test(groups={"fast"})
    public void testJasyptDisabledByDefault() throws IOException, URISyntaxException {
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource();
        String enableJasyptString = configSource.getString(ENABLE_JASYPT_PROPERTY);
        Assert.assertFalse((boolean)Boolean.parseBoolean(enableJasyptString));
    }

    @Test(groups={"fast"})
    public void testDecyptionExplicitlyDisabled() throws IOException, URISyntaxException {
        String unencryptedValue = "myPropertyValue";
        String encryptedValue = this.encString("myPropertyValue");
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"false", (Object)ENCRYPTED_PROPERTY_1, (Object)encryptedValue, (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)JASYPT_PASSWORD, (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)JASYPT_ALGORITHM);
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource((Map)properties);
        String actualValue = configSource.getString(ENCRYPTED_PROPERTY_1);
        Assert.assertEquals((String)encryptedValue, (String)actualValue);
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalArgumentException.class})
    public void testDecryptEmptyPassword() throws IOException, URISyntaxException {
        String encryptedValue = this.encString("myPropertyValue");
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"true", (Object)ENCRYPTED_PROPERTY_1, (Object)encryptedValue, (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)"", (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource((Map)properties);
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalArgumentException.class})
    public void testDecryptEmptyAlgorithm() throws IOException, URISyntaxException {
        String encryptedValue = this.encString("myPropertyValue");
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"true", (Object)ENCRYPTED_PROPERTY_1, (Object)encryptedValue, (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)JASYPT_PASSWORD, (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)"");
        new DefaultKillbillConfigSource((Map)properties);
    }

    @Test(groups={"fast"}, expectedExceptions={EncryptionOperationNotPossibleException.class})
    public void testDecryptInvalidJasyptString() throws IOException, URISyntaxException {
        String encryptedValue = "ENC(notAValidEncryptedString!)";
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"true", (Object)ENCRYPTED_PROPERTY_1, (Object)"ENC(notAValidEncryptedString!)", (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)JASYPT_PASSWORD, (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource((Map)properties);
    }

    @Test(groups={"fast"}, expectedExceptions={EncryptionOperationNotPossibleException.class})
    public void testDecryptEmptyJasyptString() throws IOException, URISyntaxException {
        String encryptedValue = "ENC()";
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"true", (Object)ENCRYPTED_PROPERTY_1, (Object)"ENC()", (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)JASYPT_PASSWORD, (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource((Map)properties);
    }

    @Test(groups={"fast"})
    public void testDecryptJasyptPropertySuccessfully() throws IOException, URISyntaxException {
        String unencryptedValue1 = "myPropertyValue";
        String encryptedValue1 = this.encString("myPropertyValue");
        String unencryptedValue2 = "myOtherPropertyValue";
        String encryptedValue2 = this.encString("myOtherPropertyValue");
        ImmutableMap properties = ImmutableMap.of((Object)ENABLE_JASYPT_PROPERTY, (Object)"true", (Object)ENCRYPTED_PROPERTY_1, (Object)encryptedValue1, (Object)ENCRYPTED_PROPERTY_2, (Object)encryptedValue2, (Object)JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, (Object)JASYPT_PASSWORD, (Object)JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, (Object)JASYPT_ALGORITHM);
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource((Map)properties);
        String actualValue1 = configSource.getString(ENCRYPTED_PROPERTY_1);
        String actualValue2 = configSource.getString(ENCRYPTED_PROPERTY_2);
        Assert.assertEquals((String)"myPropertyValue", (String)actualValue1);
        Assert.assertEquals((String)"myOtherPropertyValue", (String)actualValue2);
    }

    private String encString(String unencryptedValue) {
        return "ENC(" + this.encrypt(unencryptedValue, JASYPT_ALGORITHM, JASYPT_PASSWORD) + ")";
    }

    private String encrypt(String unencryptedValue, String jasyptAlgorithm, String jasyptPassword) {
        StandardPBEStringEncryptor encryptor = this.setupEncryptor(jasyptPassword, jasyptAlgorithm);
        return encryptor.encrypt(unencryptedValue);
    }

    private StandardPBEStringEncryptor setupEncryptor(String password, String algorithm) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(password);
        encryptor.setAlgorithm(algorithm);
        return encryptor;
    }
}

