/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.killbill.xmlloader.UriAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKillbillConfigSource
implements KillbillConfigSource,
OSGIConfigProperties {
    private static final Object lock = new Object();
    private static final String PROP_USER_TIME_ZONE = "user.timezone";
    private static final String PROP_SECURITY_EGD = "java.security.egd";
    private static final Logger logger = LoggerFactory.getLogger(DefaultKillbillConfigSource.class);
    private static final String PROPERTIES_FILE = "org.killbill.server.properties";
    private static final String GMT_ID = "GMT";
    private static final String LOOKUP_ENVIRONMENT_VARIABLES = "org.killbill.server.lookupEnvironmentVariables";
    static final String ENVIRONMENT_VARIABLE_PREFIX = "KB_";
    private static final String ENABLE_JASYPT_DECRYPTION = "org.killbill.server.enableJasypt";
    private static final String JASYPT_ENCRYPTOR_PASSWORD_KEY = "JASYPT_ENCRYPTOR_PASSWORD";
    private static final String JASYPT_ENCRYPTOR_ALGORITHM_KEY = "JASYPT_ENCRYPTOR_ALGORITHM";
    private static final String ENC_PREFIX = "ENC(";
    private static final String ENC_SUFFIX = ")";
    private static final int NOT_SHOWN = 0;
    private static final int SHOWN = 1;
    private static volatile int GMT_WARNING = 0;
    private static volatile int ENTROPY_WARNING = 0;
    private final Properties properties;

    public DefaultKillbillConfigSource() throws IOException, URISyntaxException {
        this((String)null);
    }

    public DefaultKillbillConfigSource(Map<String, String> extraDefaultProperties) throws IOException, URISyntaxException {
        this(null, extraDefaultProperties);
    }

    public DefaultKillbillConfigSource(@Nullable String file) throws URISyntaxException, IOException {
        this(file, Collections.emptyMap());
    }

    public DefaultKillbillConfigSource(@Nullable String file, Map<String, String> extraDefaultProperties) throws URISyntaxException, IOException {
        if (file == null) {
            this.properties = this.loadPropertiesFromFileOrSystemProperties();
        } else {
            this.properties = new Properties();
            this.properties.load(UriAccessor.accessUri((URI)Objects.requireNonNull(this.getClass().getResource(file)).toURI()));
        }
        for (Map.Entry<String, String> entry : extraDefaultProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        this.populateDefaultProperties();
        if (Boolean.parseBoolean(this.getString(LOOKUP_ENVIRONMENT_VARIABLES))) {
            this.overrideWithEnvironmentVariables();
        }
        if (Boolean.parseBoolean(this.getString(ENABLE_JASYPT_DECRYPTION))) {
            this.decryptJasyptProperties();
        }
    }

    public String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        Properties result = new Properties();
        this.properties.stringPropertyNames().forEach(key -> result.setProperty((String)key, this.properties.getProperty((String)key)));
        return result;
    }

    private Properties loadPropertiesFromFileOrSystemProperties() {
        String propertiesFileLocation = System.getProperty(PROPERTIES_FILE);
        if (propertiesFileLocation != null) {
            try {
                Properties properties = new Properties();
                properties.load(UriAccessor.accessUri((String)propertiesFileLocation));
                return properties;
            }
            catch (IOException e) {
                logger.warn("Unable to access properties file, defaulting to system properties", (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.warn("Unable to access properties file, defaulting to system properties", (Throwable)e);
            }
        }
        return new Properties(System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void populateDefaultProperties() {
        Properties defaultProperties = this.getDefaultProperties();
        for (String propertyName : defaultProperties.stringPropertyNames()) {
            if (this.properties.get(propertyName) != null) continue;
            this.properties.put(propertyName, defaultProperties.get(propertyName));
        }
        Properties defaultSystemProperties = this.getDefaultSystemProperties();
        for (String propertyName : defaultSystemProperties.stringPropertyNames()) {
            if (propertyName.equals(PROP_USER_TIME_ZONE)) {
                if (!GMT_ID.equals(System.getProperty(propertyName)) && GMT_WARNING == 0) {
                    Object object = lock;
                    synchronized (object) {
                        if (GMT_WARNING == 0) {
                            GMT_WARNING = 1;
                            logger.info("Overwrite of user.timezone system property with {} may break database serialization of date. Kill Bill will overwrite to GMT", (Object)System.getProperty(propertyName));
                        }
                    }
                }
                System.setProperty(propertyName, GMT_ID);
                TimeZone.setDefault(TimeZone.getTimeZone(GMT_ID));
                continue;
            }
            if (System.getProperty(propertyName) != null) continue;
            System.setProperty(propertyName, defaultSystemProperties.get(propertyName).toString());
        }
        if (System.getProperty(PROP_SECURITY_EGD) == null && ENTROPY_WARNING == 0) {
            Object object = lock;
            synchronized (object) {
                if (ENTROPY_WARNING == 0) {
                    ENTROPY_WARNING = 1;
                    logger.warn("System property {} has not been set, this may cause some requests to hang because of a lack of entropy. You should probably set it to 'file:/dev/./urandom'", (Object)PROP_SECURITY_EGD);
                }
            }
        }
    }

    @VisibleForTesting
    public void setProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    @VisibleForTesting
    protected Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put("org.killbill.persistent.bus.external.tableName", "bus_ext_events");
        properties.put("org.killbill.persistent.bus.external.historyTableName", "bus_ext_events_history");
        properties.put(ENABLE_JASYPT_DECRYPTION, "false");
        properties.put(LOOKUP_ENVIRONMENT_VARIABLES, "true");
        return properties;
    }

    @VisibleForTesting
    protected Properties getDefaultSystemProperties() {
        Properties properties = new Properties();
        properties.put(PROP_USER_TIME_ZONE, GMT_ID);
        properties.put("ANTLR_USE_DIRECT_CLASS_LOADING", "true");
        properties.put("org.slf4j.simpleLogger.log.jdbc", "ERROR");
        properties.put("log4jdbc.dump.sql.maxlinelength", "0");
        properties.put("log4jdbc.spylogdelegator.name", "net.sf.log4jdbc.log.slf4j.Slf4jSpyLogDelegator");
        return properties;
    }

    private void overrideWithEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().startsWith(ENVIRONMENT_VARIABLE_PREFIX)) continue;
            String propertyName = this.fromEnvVariableName(entry.getKey());
            String value = entry.getValue();
            this.properties.setProperty(propertyName, value);
        }
    }

    @VisibleForTesting
    String fromEnvVariableName(String key) {
        return key.replace(ENVIRONMENT_VARIABLE_PREFIX, "").replaceAll("_", "\\.");
    }

    private void decryptJasyptProperties() {
        String password = this.getEnvironmentVariable(JASYPT_ENCRYPTOR_PASSWORD_KEY, System.getProperty(JASYPT_ENCRYPTOR_PASSWORD_KEY));
        String algorithm = this.getEnvironmentVariable(JASYPT_ENCRYPTOR_ALGORITHM_KEY, System.getProperty(JASYPT_ENCRYPTOR_ALGORITHM_KEY));
        Enumeration<Object> keys = this.properties.keys();
        StandardPBEStringEncryptor encryptor = this.initializeEncryptor(password, algorithm);
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.properties.get(key);
            Optional<String> decryptableValue = this.decryptableValue(value);
            decryptableValue.ifPresent(s -> this.properties.setProperty(key, encryptor.decrypt(s)));
        }
    }

    private StandardPBEStringEncryptor initializeEncryptor(String password, String algorithm) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        if (Strings.isNullOrEmpty((String)password)) {
            logger.error("JASYPT_ENCRYPTOR_PASSWORD is not set. Decrypting properties via Jasypt will likely fail.");
        }
        if (Strings.isNullOrEmpty((String)algorithm)) {
            logger.error("JASYPT_ENCRYPTOR_ALGORITHM is not set. Decrypting properties via Jasypt will likely fail.");
        }
        encryptor.setPassword(password);
        encryptor.setAlgorithm(algorithm);
        return encryptor;
    }

    private String getEnvironmentVariable(String name, String defaultValue) {
        String value = System.getenv(name);
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = this.getString(name);
        return Strings.isNullOrEmpty((String)value) ? defaultValue : value;
    }

    private Optional<String> decryptableValue(String value) {
        int end;
        if (value == null) {
            return Optional.empty();
        }
        int start = value.indexOf(ENC_PREFIX);
        if (start != -1 && (end = value.lastIndexOf(ENC_SUFFIX)) != -1) {
            return Optional.of(value.substring(start + ENC_PREFIX.length(), end));
        }
        return Optional.empty();
    }
}

