/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.jndi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.killbill.commons.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIManager {
    private static final Logger logger = LoggerFactory.getLogger(JNDIManager.class);
    private static final String REGISTRY_CONTEXT_FACTORY = "com.sun.jndi.rmi.registry.RegistryContextFactory";
    private final int port;

    public JNDIManager() throws RemoteException {
        this(1099);
    }

    public JNDIManager(int port) throws RemoteException {
        this.port = port;
        try {
            LocateRegistry.createRegistry(port);
        }
        catch (ExportException exportException) {
            // empty catch block
        }
        System.setProperty("java.naming.provider.url", "rmi://127.0.0.1:" + port);
        System.setProperty("java.naming.factory.initial", REGISTRY_CONTEXT_FACTORY);
    }

    public void export(String name, Object object) {
        Preconditions.checkArgument((object instanceof Remote || object instanceof Reference || object instanceof Referenceable ? 1 : 0) != 0, (String)("object to bind must be Remote, Reference, or Referenceable, not " + object.getClass()), (Object[])new Object[0]);
        this.doExport(name, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExport(String name) {
        Context context = null;
        try {
            context = this.getContext();
            context.removeFromEnvironment(name);
        }
        catch (NamingException e) {
            logger.warn("Error un-exporting " + name, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    logger.warn("Error closing context while un-exporting " + name, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String name) {
        Context context = null;
        try {
            context = this.getContext();
            Object object = context.lookup(name);
            return object;
        }
        catch (NamingException e) {
            logger.warn("Error looking up " + name, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    logger.warn("Error closing context while looking up " + name, (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(String name, Object object) {
        Context context = null;
        try {
            context = this.getContext();
            context.rebind(name, object);
        }
        catch (NamingException e) {
            logger.warn("Error exporting " + name, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    logger.warn("Error closing context while exporting " + name, (Throwable)e);
                }
            }
        }
    }

    private Context getContext() throws NamingException {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("java.naming.provider.url", "rmi://127.0.0.1:" + this.port);
        environment.put("java.naming.factory.initial", REGISTRY_CONTEXT_FACTORY);
        return new InitialContext(environment);
    }
}

