/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import org.killbill.billing.lifecycle.ServiceFinder;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycle
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycle.class);
    private final SetMultimap<LifecycleHandlerType.LifecycleLevel, LifecycleHandler<? extends KillbillService>> handlersByLevel = Multimaps.newSetMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<Set<LifecycleHandler<? extends KillbillService>>>(){

        public Set<LifecycleHandler<? extends KillbillService>> get() {
            return new CopyOnWriteArraySet<LifecycleHandler<? extends KillbillService>>();
        }
    });

    @Inject
    public DefaultLifecycle(Injector injector) {
        this();
        ServiceFinder serviceFinder = new ServiceFinder(DefaultLifecycle.class.getClassLoader());
        this.init(serviceFinder, injector);
    }

    public DefaultLifecycle(Set<? extends KillbillService> services) {
        this();
        this.init(services);
    }

    private DefaultLifecycle() {
    }

    @Override
    public void fireStartupSequencePriorEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_PRE_EVENT_REGISTRATION);
    }

    @Override
    public void fireStartupSequencePostEventRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.STARTUP_POST_EVENT_REGISTRATION);
    }

    @Override
    public void fireShutdownSequencePriorEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_PRE_EVENT_UNREGISTRATION);
    }

    @Override
    public void fireShutdownSequencePostEventUnRegistration() {
        this.fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence.SHUTDOWN_POST_EVENT_UNREGISTRATION);
    }

    private Set<? extends KillbillService> findServices(Set<Class<? extends KillbillService>> services, Injector injector) {
        HashSet<KillbillService> result = new HashSet<KillbillService>();
        for (Class<? extends KillbillService> cur : services) {
            log.debug("Found service {}", (Object)cur.getName());
            try {
                KillbillService instance = (KillbillService)injector.getInstance(cur);
                log.debug("got instance {}", (Object)instance.getName());
                result.add(instance);
            }
            catch (ConfigurationException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), null);
            }
            catch (ProvisionException e) {
                if (cur.getSimpleName().startsWith("Test")) continue;
                this.logWarn("Failed to inject " + cur.getName(), (Exception)((Object)e));
            }
        }
        return result;
    }

    private void init(ServiceFinder serviceFinder, Injector injector) {
        this.init(serviceFinder.getServices(), injector);
    }

    private void init(Set<Class<? extends KillbillService>> servicesClasses, Injector injector) {
        Set<? extends KillbillService> services = this.findServices(servicesClasses, injector);
        this.init(services);
    }

    private void init(Set<? extends KillbillService> services) {
        for (KillbillService killbillService : services) {
            this.handlersByLevel.putAll(this.findAllHandlers(killbillService));
        }
    }

    private void fireSequence(LifecycleHandlerType.LifecycleLevel.Sequence seq) {
        List levels = LifecycleHandlerType.LifecycleLevel.getLevelsForSequence((LifecycleHandlerType.LifecycleLevel.Sequence)seq);
        for (LifecycleHandlerType.LifecycleLevel cur : levels) {
            this.doFireStage(cur);
        }
    }

    private void doFireStage(LifecycleHandlerType.LifecycleLevel level) {
        log.info("Killbill lifecycle firing stage {}", (Object)level);
        Set handlers = this.handlersByLevel.get((Object)level);
        for (LifecycleHandler cur : handlers) {
            try {
                Method method = cur.getMethod();
                KillbillService target = (KillbillService)cur.getTarget();
                log.info("Killbill lifecycle calling handler {} for service {}", (Object)cur.getMethod().getName(), (Object)target.getName());
                method.invoke((Object)target, new Object[0]);
            }
            catch (Exception e) {
                this.logWarn("Killbill lifecycle failed to invoke lifecycle handler", e);
            }
        }
    }

    protected void logWarn(String msg, @Nullable Exception e) {
        if (e == null) {
            log.warn(msg);
        } else {
            log.warn(msg, (Throwable)e);
        }
    }

    private Multimap<LifecycleHandlerType.LifecycleLevel, LifecycleHandler<? extends KillbillService>> findAllHandlers(KillbillService service) {
        HashMultimap methodsInService = HashMultimap.create();
        Class<?> clazz = service.getClass();
        for (Method method : clazz.getMethods()) {
            LifecycleHandlerType annotation = method.getAnnotation(LifecycleHandlerType.class);
            if (annotation == null) continue;
            LifecycleHandlerType.LifecycleLevel level = annotation.value();
            LifecycleHandler<KillbillService> handler = new LifecycleHandler<KillbillService>(service, method);
            methodsInService.put((Object)level, handler);
        }
        return methodsInService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LifecycleHandler<T> {
        private final T target;
        private final Method method;

        public LifecycleHandler(T target, Method method) {
            this.target = target;
            this.method = method;
        }

        public T getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

