/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.killbill.billing.platform.api.KillbillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFinder {
    private static final Logger log = LoggerFactory.getLogger(ServiceFinder.class);
    private final ClassLoader loader;
    private final Set<Class<? extends KillbillService>> servicesTypes;

    public ServiceFinder(ClassLoader loader) {
        this.loader = loader;
        this.servicesTypes = this.initialize();
        for (Class<? extends KillbillService> svc : this.servicesTypes) {
            log.debug("Found KillbillService class {}", (Object)svc.getName());
        }
    }

    public Set<Class<? extends KillbillService>> getServices() {
        return this.servicesTypes;
    }

    private Set<Class<? extends KillbillService>> initialize() {
        try {
            HashSet<String> packageFilter = new HashSet<String>();
            packageFilter.add("org.killbill.billing");
            String jarFilter = "killbill";
            return ServiceFinder.findClasses(this.loader, KillbillService.class.getName(), "killbill", packageFilter);
        }
        catch (ClassNotFoundException nfe) {
            throw new RuntimeException("Failed to initialize ClassFinder", nfe);
        }
    }

    private static Set<Class<? extends KillbillService>> findClasses(ClassLoader classLoader, String interfaceFilter, String jarFilter, Set<String> packageFilter) throws ClassNotFoundException {
        Object[] classPaths;
        HashSet<Class<? extends KillbillService>> result = new HashSet<Class<? extends KillbillService>>();
        try {
            classPaths = ((URLClassLoader)classLoader).getURLs();
        }
        catch (ClassCastException cce) {
            classPaths = System.getProperty("java.class.path", "").split(File.pathSeparator);
        }
        for (URL uRL : classPaths) {
            String protocol;
            File classPath;
            Enumeration<Object> files = null;
            ZipFile module = null;
            if (URL.class.isInstance(uRL)) {
                URL urlClassPath = uRL;
                classPath = new File(urlClassPath.getFile());
                protocol = urlClassPath.getProtocol();
            } else {
                classPath = new File(((Object)uRL).toString());
                protocol = "file";
            }
            if ("file".equals(protocol) && classPath.isDirectory()) {
                log.debug("DIR : " + classPath);
                ArrayList<String> dirListing = new ArrayList<String>();
                ServiceFinder.recursivelyListDir(dirListing, classPath, new StringBuffer());
                files = Collections.enumeration(dirListing);
            } else if (classPath.getName().endsWith(".jar")) {
                log.debug("JAR : " + classPath);
                String[] jarParts = classPath.getName().split("/");
                String jarName = jarParts[jarParts.length - 1];
                if (jarFilter != null && jarName != null && !jarName.startsWith(jarFilter)) continue;
                boolean failed = true;
                try {
                    module = new JarFile(classPath);
                    failed = false;
                }
                catch (MalformedURLException mue) {
                    throw new ClassNotFoundException("Bad classpath. Error: " + mue.getMessage());
                }
                catch (IOException io) {
                    throw new ClassNotFoundException("jar file '" + classPath.getName() + "' could not be instantiate from file path. Error: " + io.getMessage());
                }
                if (!failed) {
                    files = ((JarFile)module).entries();
                }
            }
            block10: while (files != null && files.hasMoreElements()) {
                String fileName = files.nextElement().toString();
                if (!fileName.endsWith(".class")) continue;
                String className = fileName.replaceAll("/", ".").substring(0, fileName.length() - 6);
                if (packageFilter != null) {
                    boolean skip = true;
                    for (String aPackageFilter : packageFilter) {
                        String filter = aPackageFilter + ".";
                        if (!className.startsWith(filter)) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                Class<?> theClass = null;
                try {
                    theClass = Class.forName(className, false, classLoader);
                }
                catch (NoClassDefFoundError e) {
                    continue;
                }
                if (!theClass.isInterface()) continue;
                Class<?>[] classInterfaces = ServiceFinder.getAllInterfaces(theClass);
                String interfaceName = null;
                for (Class<?> classInterface : classInterfaces) {
                    interfaceName = classInterface.getName();
                    if (!interfaceFilter.equals(interfaceName)) continue;
                    result.add(theClass);
                    continue block10;
                }
            }
            if (module == null) continue;
            try {
                module.close();
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("The module jar file '" + classPath.getName() + "' could not be closed. Error: " + ioe.getMessage());
            }
        }
        return result;
    }

    private static Class<?>[] getAllInterfaces(Class<?> theClass) {
        Class<?>[] classInterfaces;
        HashSet superInterfaces = new HashSet();
        for (Class<?> cur : classInterfaces = theClass.getInterfaces()) {
            ServiceFinder.getSuperInterfaces(superInterfaces, cur);
        }
        return superInterfaces.toArray(new Class[superInterfaces.size()]);
    }

    private static void getSuperInterfaces(Set<Class<?>> superInterfaces, Class<?> theInterface) {
        Class<?>[] classInterfaces;
        superInterfaces.add(theInterface);
        for (Class<?> cur : classInterfaces = theInterface.getInterfaces()) {
            ServiceFinder.getSuperInterfaces(superInterfaces, cur);
        }
    }

    private static void recursivelyListDir(List<String> dirListing, File dir, StringBuffer relativePath) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                int prevLen = relativePath.length();
                ServiceFinder.recursivelyListDir(dirListing, file, relativePath.append(prevLen == 0 ? "" : "/").append(file.getName()));
                relativePath.delete(prevLen, relativePath.length());
            }
        } else {
            dirListing.add(relativePath.toString());
        }
    }
}

