/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle.bus;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.killbill.bus.api.PersistentBusConfig;
import org.killbill.queue.api.PersistentQueueConfig;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.TimeSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPersistentBusConfig
extends PersistentBusConfig {
    private static final Logger logger = LoggerFactory.getLogger(ExternalPersistentBusConfig.class);
    public static final String MAIN_BUS_NAME = "main";
    public static final String EXTERNAL_BUS_NAME = "external";
    private static final String TABLE_NAME_DEFAULT_VALUE = "bus_events";
    private static final String TABLE_NAME_ALTERNATE_DEFAULT_VALUE = "bus_ext_events";
    private static final String HISTORY_TABLE_NAME_DEFAULT_VALUE = "bus_events_history";
    private static final String HISTORY_TABLE_NAME_ALTERNATE_DEFAULT_VALUE = "bus_ext_events_history";
    private final PersistentBusConfig internalPersistentBusConfig;
    private final PersistentBusConfig externalPersistentBusConfig;

    public ExternalPersistentBusConfig(ConfigSource configSource) {
        this.internalPersistentBusConfig = (PersistentBusConfig)new ConfigurationObjectFactory(configSource).buildWithReplacements(PersistentBusConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)MAIN_BUS_NAME));
        this.externalPersistentBusConfig = (PersistentBusConfig)new ConfigurationObjectFactory(configSource).buildWithReplacements(PersistentBusConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)EXTERNAL_BUS_NAME));
    }

    public boolean isInMemory() {
        return this.externalPersistentBusConfig.isInMemory();
    }

    public int getMaxFailureRetries() {
        return this.externalPersistentBusConfig.getMaxFailureRetries();
    }

    public int getMaxEntriesClaimed() {
        return this.externalPersistentBusConfig.getMaxEntriesClaimed();
    }

    public PersistentQueueConfig.PersistentQueueMode getPersistentQueueMode() {
        return this.externalPersistentBusConfig.getPersistentQueueMode();
    }

    public TimeSpan getClaimedTime() {
        return this.externalPersistentBusConfig.getClaimedTime();
    }

    public long getPollingSleepTimeMs() {
        return this.externalPersistentBusConfig.getPollingSleepTimeMs();
    }

    public boolean isProcessingOff() {
        return this.externalPersistentBusConfig.isProcessingOff();
    }

    public int geMaxDispatchThreads() {
        return this.externalPersistentBusConfig.geMaxDispatchThreads();
    }

    public int getEventQueueCapacity() {
        return 0;
    }

    public String getTableName() {
        if (this.internalPersistentBusConfig.getTableName().equals(this.externalPersistentBusConfig.getTableName())) {
            if (TABLE_NAME_DEFAULT_VALUE.equals(this.externalPersistentBusConfig.getTableName())) {
                logger.debug("Overriding default value for the external bus table name");
                return TABLE_NAME_ALTERNATE_DEFAULT_VALUE;
            }
            throw new IllegalArgumentException("The external and internal buses cannot share the same table name " + this.externalPersistentBusConfig.getTableName());
        }
        return this.externalPersistentBusConfig.getTableName();
    }

    public String getHistoryTableName() {
        if (this.internalPersistentBusConfig.getHistoryTableName().equals(this.externalPersistentBusConfig.getHistoryTableName())) {
            if (HISTORY_TABLE_NAME_DEFAULT_VALUE.equals(this.externalPersistentBusConfig.getHistoryTableName())) {
                logger.debug("Overriding default value for the external bus history table name");
                return HISTORY_TABLE_NAME_ALTERNATE_DEFAULT_VALUE;
            }
            throw new IllegalArgumentException("The external and internal buses cannot share the same history table name " + this.externalPersistentBusConfig.getHistoryTableName());
        }
        return this.externalPersistentBusConfig.getHistoryTableName();
    }

    public TimeSpan getReapThreshold() {
        return this.externalPersistentBusConfig.getReapThreshold();
    }

    public int getMaxReDispatchCount() {
        return this.externalPersistentBusConfig.getMaxReDispatchCount();
    }
}

