/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle.bus;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.killbill.billing.lifecycle.api.ExternalBusService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.bus.api.PersistentBus;

public class DefaultExternalBusService
implements ExternalBusService {
    public static final String EXTERNAL_BUS_SERVICE = "external-bus-service";
    private final PersistentBus eventBus;

    @Inject
    public DefaultExternalBusService(@Named(value="externalBus") PersistentBus eventBus) {
        this.eventBus = eventBus;
    }

    public String getName() {
        return EXTERNAL_BUS_SERVICE;
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_BUS)
    public void startBus() {
        this.eventBus.start();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_BUS)
    public void stopBus() {
        this.eventBus.stop();
    }

    public PersistentBus getBus() {
        return this.eventBus;
    }
}

